/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.data.input.AbstractInputSource;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.InputEntityIteratingReader;
import org.apache.druid.data.input.impl.systemfield.SystemFieldDecoratorFactory;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.StringUtils;

public class InlineInputSource
extends AbstractInputSource {
    public static final String TYPE_KEY = "inline";
    private final String data;

    @JsonCreator
    public InlineInputSource(@JsonProperty(value="data") String data) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)data) ? 1 : 0) != 0, (Object)"empty data");
        this.data = data;
    }

    @Override
    @JsonIgnore
    @Nonnull
    public Set<String> getTypes() {
        return Collections.singleton(TYPE_KEY);
    }

    @JsonProperty
    public String getData() {
        return this.data;
    }

    @Override
    @JsonIgnore
    public boolean isSplittable() {
        return false;
    }

    @Override
    public boolean needsFormat() {
        return true;
    }

    @Override
    protected InputSourceReader formattableReader(InputRowSchema inputRowSchema, InputFormat inputFormat, @Nullable File temporaryDirectory) {
        return new InputEntityIteratingReader(inputRowSchema, inputFormat, CloseableIterators.withEmptyBaggage(Stream.of(new ByteEntity(StringUtils.toUtf8(this.data))).iterator()), SystemFieldDecoratorFactory.NONE, temporaryDirectory);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineInputSource that = (InlineInputSource)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public String toString() {
        return "InlineInputSource{data='" + this.data + '\'' + '}';
    }
}

