/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.InjectableValues;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;

public class GuiceInjectableValues
extends InjectableValues {
    private final Injector injector;
    private final AtomicReference<HashSet<Key>> nullables;

    public GuiceInjectableValues(Injector injector) {
        this.injector = injector;
        this.nullables = new AtomicReference(new HashSet());
    }

    public Object findInjectableValue(Object valueId, DeserializationContext ctxt, BeanProperty forProperty, Object beanInstance) {
        if (this.nullables.get().contains((Key)valueId)) {
            return null;
        }
        if (valueId instanceof Key) {
            try {
                return this.injector.getInstance((Key)valueId);
            }
            catch (ConfigurationException ce) {
                if (forProperty.getAnnotation(Nullable.class) != null) {
                    HashSet<Key> encounteredNullables = new HashSet<Key>((Collection)this.nullables.get());
                    encounteredNullables.add((Key)valueId);
                    this.nullables.set(encounteredNullables);
                    return null;
                }
                throw ce;
            }
        }
        throw new IAE("Unknown class type [%s] for valueId [%s]", valueId.getClass().getName(), valueId.toString());
    }
}

