/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.inject.util.Providers;
import java.util.Arrays;
import java.util.Properties;
import org.apache.druid.guice.BaseInjectorBuilder;
import org.apache.druid.guice.ConfigModule;
import org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.druid.guice.DruidSecondaryModule;
import org.apache.druid.guice.ExtensionsLoader;
import org.apache.druid.guice.ExtensionsModule;
import org.apache.druid.guice.NullHandlingModule;
import org.apache.druid.guice.PropertiesModule;
import org.apache.druid.guice.RuntimeInfoModule;
import org.apache.druid.jackson.JacksonModule;
import org.apache.druid.math.expr.ExpressionProcessingModule;
import org.apache.druid.utils.RuntimeInfo;

public class StartupInjectorBuilder
extends BaseInjectorBuilder<StartupInjectorBuilder> {
    public StartupInjectorBuilder() {
        this.add(new DruidGuiceExtensions(), new JacksonModule(), new ConfigModule(), new NullHandlingModule(), new ExpressionProcessingModule(), binder -> binder.bind(DruidSecondaryModule.class));
    }

    public StartupInjectorBuilder withProperties(Properties properties) {
        this.add(binder -> binder.bind(Properties.class).toInstance((Object)properties));
        return this;
    }

    public StartupInjectorBuilder withEmptyProperties() {
        return this.withProperties(new Properties());
    }

    public StartupInjectorBuilder withExtensions() {
        this.add(new ExtensionsModule());
        return this;
    }

    public StartupInjectorBuilder forServer() {
        this.withExtensions();
        this.add(new PropertiesModule(Arrays.asList("common.runtime.properties", "runtime.properties")), new RuntimeInfoModule());
        return this;
    }

    public StartupInjectorBuilder forTests() {
        this.add(binder -> {
            binder.bind(ExtensionsLoader.class).toProvider(Providers.of(null));
            binder.bind(RuntimeInfo.class).toProvider(Providers.of(null));
        });
        return this;
    }
}

