/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.hll;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.primitives.UnsignedBytes;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.hll.ByteBitLookup;
import org.apache.druid.hll.VersionOneHyperLogLogCollector;
import org.apache.druid.hll.VersionZeroHyperLogLogCollector;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;

public abstract class HyperLogLogCollector
implements Comparable<HyperLogLogCollector> {
    public static final int DENSE_THRESHOLD = 128;
    public static final int BITS_FOR_BUCKETS = 11;
    public static final int NUM_BUCKETS = 2048;
    public static final int NUM_BYTES_FOR_BUCKETS = 1024;
    private static final double TWO_TO_THE_SIXTY_FOUR = Math.pow(2.0, 64.0);
    private static final double ALPHA = 0.7209201792610241;
    public static final double LOW_CORRECTION_THRESHOLD = 5120.0;
    public static final double HIGH_CORRECTION_THRESHOLD = TWO_TO_THE_SIXTY_FOUR / 30.0;
    public static final double CORRECTION_PARAMETER = 3023758.3915552306;
    private static final int BUCKET_MASK = 2047;
    private static final int MIN_BYTES_REQUIRED = 10;
    private static final int BITS_PER_BUCKET = 4;
    private static final int RANGE = (int)Math.pow(2.0, 4.0) - 1;
    private static final double[][] MIN_NUM_REGISTER_LOOKUP = new double[64][256];
    private static final int[] NUM_ZERO_LOOKUP;
    private ByteBuffer storageBuffer;
    private int initPosition;
    private Double estimatedCardinality;

    public static HyperLogLogCollector makeLatestCollector() {
        return new VersionOneHyperLogLogCollector();
    }

    public static HyperLogLogCollector makeCollector(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        if (remaining % 3 == 0 || remaining == 1027) {
            return new VersionZeroHyperLogLogCollector(buffer);
        }
        return new VersionOneHyperLogLogCollector(buffer);
    }

    public static HyperLogLogCollector makeCollectorSharingStorage(HyperLogLogCollector otherCollector) {
        return HyperLogLogCollector.makeCollector(otherCollector.getStorageBuffer().duplicate());
    }

    public static int getLatestNumBytesForDenseStorage() {
        return 1031;
    }

    public static byte[] makeEmptyVersionedByteArray() {
        byte[] arr = new byte[HyperLogLogCollector.getLatestNumBytesForDenseStorage()];
        arr[0] = 1;
        return arr;
    }

    public static double applyCorrection(double e, int zeroCount) {
        if ((e = 3023758.3915552306 / e) <= 5120.0) {
            return zeroCount == 0 ? e : 2048.0 * Math.log(2048.0 / (double)zeroCount);
        }
        if (e > HIGH_CORRECTION_THRESHOLD) {
            double ratio = e / TWO_TO_THE_SIXTY_FOUR;
            if (ratio >= 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return -TWO_TO_THE_SIXTY_FOUR * Math.log(1.0 - ratio);
        }
        return e;
    }

    public static double estimateByteBuffer(ByteBuffer buf) {
        return HyperLogLogCollector.makeCollector(buf.duplicate()).estimateCardinality();
    }

    private static double estimateSparse(ByteBuffer buf, byte minNum, byte overflowValue, short overflowPosition, boolean isUpperNibble) {
        ByteBuffer copy = buf.asReadOnlyBuffer();
        double e = 0.0;
        int zeroCount = 2048 - 2 * (buf.remaining() / 3);
        while (copy.hasRemaining()) {
            short position = copy.getShort();
            int register = copy.get() & 0xFF;
            if (overflowValue != 0 && position == overflowPosition) {
                int upperNibble = ((register & 0xF0) >>> 4) + minNum;
                int lowerNibble = (register & 0xF) + minNum;
                if (isUpperNibble) {
                    upperNibble = Math.max(upperNibble, overflowValue);
                } else {
                    lowerNibble = Math.max(lowerNibble, overflowValue);
                }
                e += 1.0 / Math.pow(2.0, upperNibble) + 1.0 / Math.pow(2.0, lowerNibble);
                zeroCount += ((upperNibble & 0xF0) == 0 ? 1 : 0) + ((lowerNibble & 0xF) == 0 ? 1 : 0);
                continue;
            }
            e += MIN_NUM_REGISTER_LOOKUP[minNum][register];
            zeroCount += NUM_ZERO_LOOKUP[register];
        }
        return HyperLogLogCollector.applyCorrection(e += (double)zeroCount, zeroCount);
    }

    private static double estimateDense(ByteBuffer buf, byte minNum, byte overflowValue, short overflowPosition, boolean isUpperNibble) {
        ByteBuffer copy = buf.asReadOnlyBuffer();
        double e = 0.0;
        int zeroCount = 0;
        int position = 0;
        while (copy.hasRemaining()) {
            int register = copy.get() & 0xFF;
            if (overflowValue != 0 && position == overflowPosition) {
                int upperNibble = ((register & 0xF0) >>> 4) + minNum;
                int lowerNibble = (register & 0xF) + minNum;
                if (isUpperNibble) {
                    upperNibble = Math.max(upperNibble, overflowValue);
                } else {
                    lowerNibble = Math.max(lowerNibble, overflowValue);
                }
                e += 1.0 / Math.pow(2.0, upperNibble) + 1.0 / Math.pow(2.0, lowerNibble);
                zeroCount += ((upperNibble & 0xF0) == 0 ? 1 : 0) + ((lowerNibble & 0xF) == 0 ? 1 : 0);
            } else {
                e += MIN_NUM_REGISTER_LOOKUP[minNum][register];
                zeroCount += NUM_ZERO_LOOKUP[register];
            }
            ++position;
        }
        return HyperLogLogCollector.applyCorrection(e, zeroCount);
    }

    private static boolean isSparse(ByteBuffer buffer) {
        return buffer.remaining() != 1024;
    }

    public HyperLogLogCollector(ByteBuffer byteBuffer) {
        this.storageBuffer = byteBuffer;
        this.initPosition = byteBuffer.position();
        this.estimatedCardinality = null;
    }

    public abstract byte getVersion();

    public abstract void setVersion(ByteBuffer var1);

    public abstract byte getRegisterOffset();

    public abstract void setRegisterOffset(byte var1);

    public abstract void setRegisterOffset(ByteBuffer var1, byte var2);

    public abstract short getNumNonZeroRegisters();

    public abstract void setNumNonZeroRegisters(short var1);

    public abstract void setNumNonZeroRegisters(ByteBuffer var1, short var2);

    public abstract byte getMaxOverflowValue();

    public abstract void setMaxOverflowValue(byte var1);

    public abstract void setMaxOverflowValue(ByteBuffer var1, byte var2);

    public abstract short getMaxOverflowRegister();

    public abstract void setMaxOverflowRegister(short var1);

    public abstract void setMaxOverflowRegister(ByteBuffer var1, short var2);

    public abstract int getNumHeaderBytes();

    public abstract int getNumBytesForDenseStorage();

    public abstract int getPayloadBytePosition();

    public abstract int getPayloadBytePosition(ByteBuffer var1);

    protected int getInitPosition() {
        return this.initPosition;
    }

    protected ByteBuffer getStorageBuffer() {
        return this.storageBuffer;
    }

    public void add(byte[] hashedValue) {
        if (hashedValue.length < 10) {
            throw new IAE("Insufficient bytes, need[%d] got [%d]", 10, hashedValue.length);
        }
        this.estimatedCardinality = null;
        ByteBuffer buffer = ByteBuffer.wrap(hashedValue);
        short bucket = (short)(buffer.getShort(hashedValue.length - 2) & 0x7FF);
        byte positionOf1 = 0;
        block3: for (int i = 0; i < 8; ++i) {
            byte lookupVal = ByteBitLookup.LOOKUP[UnsignedBytes.toInt((byte)hashedValue[i])];
            switch (lookupVal) {
                case 0: {
                    positionOf1 = (byte)(positionOf1 + 8);
                    continue block3;
                }
                default: {
                    positionOf1 = (byte)(positionOf1 + lookupVal);
                    i = 8;
                }
            }
        }
        this.add(bucket, positionOf1);
    }

    public void add(short bucket, byte positionOf1) {
        byte registerOffset;
        if (this.storageBuffer.isReadOnly()) {
            this.convertToMutableByteBuffer();
        }
        if (positionOf1 <= (registerOffset = this.getRegisterOffset())) {
            return;
        }
        if (positionOf1 > registerOffset + RANGE) {
            byte currMax = this.getMaxOverflowValue();
            if (positionOf1 > currMax) {
                if (currMax <= registerOffset + RANGE) {
                    this.add(this.getMaxOverflowRegister(), currMax);
                }
                this.setMaxOverflowValue(positionOf1);
                this.setMaxOverflowRegister(bucket);
            }
            return;
        }
        short numNonZeroRegisters = this.addNibbleRegister(bucket, (byte)((0xFF & positionOf1) - registerOffset));
        this.setNumNonZeroRegisters(numNonZeroRegisters);
        if (numNonZeroRegisters == 2048) {
            this.setRegisterOffset((byte)(registerOffset + 1));
            this.setNumNonZeroRegisters(this.decrementBuckets());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HyperLogLogCollector fold(@Nullable HyperLogLogCollector other) {
        if (other == null || other.storageBuffer.remaining() == 0) {
            return this;
        }
        if (this.storageBuffer.isReadOnly()) {
            this.convertToMutableByteBuffer();
        }
        if (this.storageBuffer.remaining() != this.getNumBytesForDenseStorage()) {
            this.convertToDenseStorage();
        }
        this.estimatedCardinality = null;
        if (this.getRegisterOffset() < other.getRegisterOffset()) {
            ByteBuffer tmpBuffer = ByteBuffer.allocate(this.storageBuffer.remaining());
            tmpBuffer.put(this.storageBuffer.asReadOnlyBuffer());
            tmpBuffer.clear();
            this.storageBuffer.duplicate().put(other.storageBuffer.asReadOnlyBuffer());
            if (other.storageBuffer.remaining() != other.getNumBytesForDenseStorage()) {
                int newLImit = this.storageBuffer.position() + other.storageBuffer.remaining();
                this.storageBuffer.limit(newLImit);
                this.convertToDenseStorage();
            }
            other = HyperLogLogCollector.makeCollector(tmpBuffer);
        }
        ByteBuffer otherBuffer = other.storageBuffer;
        int otherPosition = otherBuffer.position();
        try {
            byte otherOffset = other.getRegisterOffset();
            byte myOffset = this.getRegisterOffset();
            short numNonZero = this.getNumNonZeroRegisters();
            int offsetDiff = myOffset - otherOffset;
            if (offsetDiff < 0) {
                throw new ISE("offsetDiff[%d] < 0, shouldn't happen because of swap.", offsetDiff);
            }
            int myPayloadStart = this.getPayloadBytePosition();
            otherBuffer.position(other.getPayloadBytePosition());
            if (HyperLogLogCollector.isSparse(otherBuffer)) {
                while (otherBuffer.hasRemaining()) {
                    int payloadStartPosition = otherBuffer.getShort() - other.getNumHeaderBytes();
                    numNonZero = (short)(numNonZero + HyperLogLogCollector.mergeAndStoreByteRegister(this.storageBuffer, myPayloadStart + payloadStartPosition, offsetDiff, otherBuffer.get()));
                }
                if (numNonZero == 2048) {
                    numNonZero = this.decrementBuckets();
                    this.setRegisterOffset((byte)(myOffset + 1));
                    this.setNumNonZeroRegisters(numNonZero);
                }
            } else {
                int position = this.getPayloadBytePosition();
                while (otherBuffer.hasRemaining()) {
                    numNonZero = (short)(numNonZero + HyperLogLogCollector.mergeAndStoreByteRegister(this.storageBuffer, position, offsetDiff, otherBuffer.get()));
                    ++position;
                }
                if (numNonZero == 2048) {
                    numNonZero = this.decrementBuckets();
                    this.setRegisterOffset((byte)(myOffset + 1));
                    this.setNumNonZeroRegisters(numNonZero);
                }
            }
            this.setNumNonZeroRegisters(numNonZero);
            this.add(other.getMaxOverflowRegister(), other.getMaxOverflowValue());
            HyperLogLogCollector hyperLogLogCollector = this;
            return hyperLogLogCollector;
        }
        finally {
            otherBuffer.position(otherPosition);
        }
    }

    public HyperLogLogCollector fold(ByteBuffer buffer) {
        return this.fold(HyperLogLogCollector.makeCollector(buffer.duplicate()));
    }

    public ByteBuffer toByteBuffer() {
        short numNonZeroRegisters = this.getNumNonZeroRegisters();
        if (this.storageBuffer.remaining() == this.getNumBytesForDenseStorage() && numNonZeroRegisters < 128) {
            ByteBuffer retVal = ByteBuffer.wrap(new byte[numNonZeroRegisters * 3 + this.getNumHeaderBytes()]);
            this.setVersion(retVal);
            this.setRegisterOffset(retVal, this.getRegisterOffset());
            this.setNumNonZeroRegisters(retVal, numNonZeroRegisters);
            this.setMaxOverflowValue(retVal, this.getMaxOverflowValue());
            this.setMaxOverflowRegister(retVal, this.getMaxOverflowRegister());
            int startPosition = this.getPayloadBytePosition();
            retVal.position(this.getPayloadBytePosition(retVal));
            byte[] zipperBuffer = new byte[1024];
            ByteBuffer roStorageBuffer = this.storageBuffer.asReadOnlyBuffer();
            roStorageBuffer.position(startPosition);
            roStorageBuffer.get(zipperBuffer);
            for (int i = 0; i < 1024; ++i) {
                if (zipperBuffer[i] == 0) continue;
                short val = (short)(0xFFFF & i + startPosition - this.initPosition);
                retVal.putShort(val);
                retVal.put(zipperBuffer[i]);
            }
            retVal.rewind();
            return retVal.asReadOnlyBuffer();
        }
        return this.storageBuffer.asReadOnlyBuffer();
    }

    @JsonValue
    public byte[] toByteArray() {
        ByteBuffer buffer = this.toByteBuffer();
        byte[] theBytes = new byte[buffer.remaining()];
        buffer.get(theBytes);
        return theBytes;
    }

    public long estimateCardinalityRound() {
        return Math.round(this.estimateCardinality());
    }

    public double estimateCardinality() {
        if (this.estimatedCardinality == null) {
            byte registerOffset = this.getRegisterOffset();
            byte overflowValue = this.getMaxOverflowValue();
            short overflowRegister = this.getMaxOverflowRegister();
            short overflowPosition = (short)(overflowRegister >>> 1);
            boolean isUpperNibble = (overflowRegister & 1) == 0;
            this.storageBuffer.position(this.getPayloadBytePosition());
            this.estimatedCardinality = HyperLogLogCollector.isSparse(this.storageBuffer) ? Double.valueOf(HyperLogLogCollector.estimateSparse(this.storageBuffer, registerOffset, overflowValue, overflowPosition, isUpperNibble)) : Double.valueOf(HyperLogLogCollector.estimateDense(this.storageBuffer, registerOffset, overflowValue, overflowPosition, isUpperNibble));
            this.storageBuffer.position(this.initPosition);
        }
        return this.estimatedCardinality;
    }

    public boolean equals(Object o) {
        ByteBuffer denseStorageBuffer;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteBuffer otherBuffer = ((HyperLogLogCollector)o).storageBuffer;
        if (this.storageBuffer == null && otherBuffer != null) {
            return false;
        }
        if (this.storageBuffer == null && otherBuffer == null) {
            return true;
        }
        if (this.storageBuffer.remaining() != this.getNumBytesForDenseStorage()) {
            HyperLogLogCollector denseCollector = HyperLogLogCollector.makeCollector(this.storageBuffer.duplicate());
            denseCollector.convertToDenseStorage();
            denseStorageBuffer = denseCollector.storageBuffer;
        } else {
            denseStorageBuffer = this.storageBuffer;
        }
        if (otherBuffer.remaining() != this.getNumBytesForDenseStorage()) {
            HyperLogLogCollector otherCollector = HyperLogLogCollector.makeCollector(otherBuffer.duplicate());
            otherCollector.convertToDenseStorage();
            otherBuffer = otherCollector.storageBuffer;
        }
        return denseStorageBuffer.equals(otherBuffer);
    }

    public int hashCode() {
        int result = this.storageBuffer != null ? this.storageBuffer.hashCode() : 0;
        result = 31 * result + this.initPosition;
        return result;
    }

    public String toString() {
        return "HyperLogLogCollector{initPosition=" + this.initPosition + ", version=" + this.getVersion() + ", registerOffset=" + this.getRegisterOffset() + ", numNonZeroRegisters=" + this.getNumNonZeroRegisters() + ", maxOverflowValue=" + this.getMaxOverflowValue() + ", maxOverflowRegister=" + this.getMaxOverflowRegister() + '}';
    }

    private short decrementBuckets() {
        int startPosition = this.getPayloadBytePosition();
        short count = 0;
        for (int i = startPosition; i < startPosition + 1024; ++i) {
            byte val = (byte)(this.storageBuffer.get(i) - 17);
            if ((val & 0xF0) != 0) {
                count = (short)(count + 1);
            }
            if ((val & 0xF) != 0) {
                count = (short)(count + 1);
            }
            this.storageBuffer.put(i, val);
        }
        return count;
    }

    private void convertToMutableByteBuffer() {
        ByteBuffer tmpBuffer = ByteBuffer.allocate(this.storageBuffer.remaining());
        tmpBuffer.put(this.storageBuffer.asReadOnlyBuffer());
        tmpBuffer.position(0);
        this.storageBuffer = tmpBuffer;
        this.initPosition = 0;
    }

    private void convertToDenseStorage() {
        ByteBuffer tmpBuffer = ByteBuffer.allocate(this.getNumBytesForDenseStorage());
        this.setVersion(tmpBuffer);
        this.setRegisterOffset(tmpBuffer, this.getRegisterOffset());
        this.setNumNonZeroRegisters(tmpBuffer, this.getNumNonZeroRegisters());
        this.setMaxOverflowValue(tmpBuffer, this.getMaxOverflowValue());
        this.setMaxOverflowRegister(tmpBuffer, this.getMaxOverflowRegister());
        this.storageBuffer.position(this.getPayloadBytePosition());
        tmpBuffer.position(this.getPayloadBytePosition(tmpBuffer));
        while (this.storageBuffer.hasRemaining()) {
            tmpBuffer.put((int)this.storageBuffer.getShort(), this.storageBuffer.get());
        }
        tmpBuffer.rewind();
        this.storageBuffer = tmpBuffer;
        this.initPosition = 0;
    }

    private short addNibbleRegister(short bucket, byte positionOf1) {
        byte shiftedPositionOf1;
        short numNonZeroRegs = this.getNumNonZeroRegisters();
        int position = this.getPayloadBytePosition() + (short)(bucket >> 1);
        boolean isUpperNibble = (bucket & 1) == 0;
        byte by = shiftedPositionOf1 = isUpperNibble ? (byte)(positionOf1 << 4) : positionOf1;
        if (this.storageBuffer.remaining() != this.getNumBytesForDenseStorage()) {
            this.convertToDenseStorage();
        }
        byte origVal = this.storageBuffer.get(position);
        int newValueMask = isUpperNibble ? -16 : 15;
        byte originalValueMask = (byte)(newValueMask ^ 0xFF);
        if ((origVal & newValueMask) == 0 && shiftedPositionOf1 != 0) {
            numNonZeroRegs = (short)(numNonZeroRegs + 1);
        }
        this.storageBuffer.put(position, (byte)(UnsignedBytes.max((byte[])new byte[]{(byte)(origVal & newValueMask), shiftedPositionOf1}) | origVal & originalValueMask));
        return numNonZeroRegs;
    }

    private static short mergeAndStoreByteRegister(ByteBuffer storageBuffer, int position, int offsetDiff, byte byteToAdd) {
        if (byteToAdd == 0) {
            return 0;
        }
        byte currVal = storageBuffer.get(position);
        int upperNibble = currVal & 0xF0;
        int lowerNibble = currVal & 0xF;
        int otherUpper = (byteToAdd & 0xF0) - (offsetDiff << 4);
        int otherLower = (byteToAdd & 0xF) - offsetDiff;
        int newUpper = Math.max(upperNibble, otherUpper);
        int newLower = Math.max(lowerNibble, otherLower);
        storageBuffer.put(position, (byte)((newUpper | newLower) & 0xFF));
        short numNoLongerZero = 0;
        if (upperNibble == 0 && newUpper > 0) {
            numNoLongerZero = (short)(numNoLongerZero + 1);
        }
        if (lowerNibble == 0 && newLower > 0) {
            numNoLongerZero = (short)(numNoLongerZero + 1);
        }
        return numNoLongerZero;
    }

    @Override
    public int compareTo(HyperLogLogCollector other) {
        return Double.compare(this.estimateCardinality(), other.estimateCardinality());
    }

    static {
        for (int registerOffset = 0; registerOffset < 64; ++registerOffset) {
            for (int register = 0; register < 256; ++register) {
                int upper = ((register & 0xF0) >> 4) + registerOffset;
                int lower = (register & 0xF) + registerOffset;
                HyperLogLogCollector.MIN_NUM_REGISTER_LOOKUP[registerOffset][register] = 1.0 / Math.pow(2.0, upper) + 1.0 / Math.pow(2.0, lower);
            }
        }
        NUM_ZERO_LOOKUP = new int[256];
        for (int i = 0; i < NUM_ZERO_LOOKUP.length; ++i) {
            HyperLogLogCollector.NUM_ZERO_LOOKUP[i] = ((i & 0xF0) == 0 ? 1 : 0) + ((i & 0xF) == 0 ? 1 : 0);
        }
    }
}

