/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.vector.ExprEvalDoubleVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

public abstract class UnivariateDoubleFunctionVectorValueProcessor<TInput>
implements ExprVectorProcessor<double[]> {
    final ExprVectorProcessor<TInput> processor;
    final boolean[] outNulls;
    final double[] outValues;

    public UnivariateDoubleFunctionVectorValueProcessor(ExprVectorProcessor<TInput> processor, int maxVectorSize) {
        this.processor = processor;
        this.outNulls = new boolean[maxVectorSize];
        this.outValues = new double[maxVectorSize];
    }

    @Override
    public final ExprEvalVector<double[]> evalVector(Expr.VectorInputBinding bindings) {
        ExprEvalVector<TInput> lhs = this.processor.evalVector(bindings);
        int currentSize = bindings.getCurrentVectorSize();
        boolean[] inputNulls = lhs.getNullVector();
        boolean hasNulls = inputNulls != null;
        TInput input = lhs.values();
        if (hasNulls) {
            for (int i = 0; i < currentSize; ++i) {
                this.outNulls[i] = inputNulls[i];
                if (!this.outNulls[i]) {
                    this.processIndex(input, i);
                    continue;
                }
                this.outValues[i] = 0.0;
            }
        } else {
            for (int i = 0; i < currentSize; ++i) {
                this.outNulls[i] = false;
                this.processIndex(input, i);
            }
        }
        return this.asEval();
    }

    abstract void processIndex(TInput var1, int var2);

    final ExprEvalVector<double[]> asEval() {
        return new ExprEvalDoubleVector(this.outValues, this.outNulls);
    }
}

