/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.CastToTypeVectorProcessor;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.ObjectOutMultiObjectInVectorProcessor;
import org.apache.druid.math.expr.vector.ObjectOutObjectsInFunctionVectorProcessor;

public class VectorStringProcessors {
    public static <T> ExprVectorProcessor<T> concat(Expr.VectorInputBindingInspector inspector, Expr left, Expr right) {
        ObjectOutObjectsInFunctionVectorProcessor processor = NullHandling.sqlCompatible() ? new ObjectOutObjectsInFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize(), ExpressionType.STRING){

            @Override
            @Nullable
            protected String processValue(@Nullable Object leftVal, @Nullable Object rightVal) {
                return leftVal + (String)rightVal;
            }
        } : new ObjectOutObjectsInFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inspector.getMaxVectorSize(), ExpressionType.STRING){

            @Override
            @Nullable
            protected Object processValue(@Nullable Object leftVal, @Nullable Object rightVal) {
                return NullHandling.nullToEmptyIfNeeded((String)leftVal) + NullHandling.nullToEmptyIfNeeded((String)rightVal);
            }
        };
        return processor;
    }

    public static <T> ExprVectorProcessor<T> concat(Expr.VectorInputBindingInspector inspector, List<Expr> inputs) {
        ExprVectorProcessor[] inputProcessors = new ExprVectorProcessor[inputs.size()];
        for (int i = 0; i < inputs.size(); ++i) {
            inputProcessors[i] = CastToTypeVectorProcessor.cast(inputs.get(i).asVectorProcessor(inspector), ExpressionType.STRING, inspector.getMaxVectorSize());
        }
        ObjectOutMultiObjectInVectorProcessor processor = new ObjectOutMultiObjectInVectorProcessor(inputProcessors, inspector.getMaxVectorSize(), ExpressionType.STRING){

            @Override
            void processIndex(Object[][] in, int i) {
                String first = NullHandling.nullToEmptyIfNeeded(Evals.asString(in[0][i]));
                if (first == null) {
                    this.outValues[i] = null;
                    return;
                }
                StringBuilder builder = new StringBuilder(first);
                for (int inputNumber = 1; inputNumber < in.length; ++inputNumber) {
                    String s = NullHandling.nullToEmptyIfNeeded(Evals.asString(in[inputNumber][i]));
                    if (s == null) {
                        this.outValues[i] = null;
                        return;
                    }
                    builder.append(s);
                }
                this.outValues[i] = builder.toString();
            }
        };
        return processor;
    }
}

