/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FrameSignaturePair;
import org.apache.druid.query.Query;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.column.RowSignature;

public class FrameBasedInlineDataSource
implements DataSource {
    final List<FrameSignaturePair> frames;
    final RowSignature rowSignature;

    public FrameBasedInlineDataSource(List<FrameSignaturePair> frames, RowSignature rowSignature) {
        this.frames = frames;
        this.rowSignature = rowSignature;
    }

    public List<FrameSignaturePair> getFrames() {
        return this.frames;
    }

    public RowSignature getRowSignature() {
        return this.rowSignature;
    }

    public Sequence<Object[]> getRowsAsSequence() {
        Sequence cursorSequence = Sequences.simple(this.frames).flatMap(frameSignaturePair -> {
            Frame frame = frameSignaturePair.getFrame();
            RowSignature frameSignature = frameSignaturePair.getRowSignature();
            FrameReader frameReader = FrameReader.create(frameSignature);
            CursorHolder holder = frameReader.makeCursorFactory(frame).makeCursorHolder(CursorBuildSpec.FULL_SCAN);
            return Sequences.simple(Collections.singletonList(holder.asCursor())).withBaggage(holder);
        });
        return cursorSequence.flatMap(cursor -> {
            ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
            final List selectors = this.rowSignature.getColumnNames().stream().map(columnSelectorFactory::makeColumnValueSelector).collect(Collectors.toList());
            return Sequences.simple(() -> new Iterator<Object[]>(){

                @Override
                public boolean hasNext() {
                    return !cursor.isDone();
                }

                @Override
                public Object[] next() {
                    Object[] row = new Object[FrameBasedInlineDataSource.this.rowSignature.size()];
                    for (int i = 0; i < FrameBasedInlineDataSource.this.rowSignature.size(); ++i) {
                        row[i] = ((BaseObjectColumnValueSelector)selectors.get(i)).getObject();
                    }
                    cursor.advance();
                    return row;
                }
            });
        });
    }

    @Override
    public Set<String> getTableNames() {
        return Collections.emptySet();
    }

    @Override
    public List<DataSource> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public DataSource withChildren(List<DataSource> children) {
        if (!children.isEmpty()) {
            throw new IAE("Cannot accept children", new Object[0]);
        }
        return this;
    }

    @Override
    public boolean isCacheable(boolean isBroker) {
        return false;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public boolean isConcrete() {
        return true;
    }

    @Override
    public Function<SegmentReference, SegmentReference> createSegmentMapFunction(Query query, AtomicLong cpuTimeAcc) {
        return Function.identity();
    }

    @Override
    public DataSource withUpdatedDataSource(DataSource newSource) {
        return newSource;
    }

    @Override
    public byte[] getCacheKey() {
        return null;
    }

    @Override
    public DataSourceAnalysis getAnalysis() {
        return new DataSourceAnalysis(this, null, null, Collections.emptyList());
    }
}

