/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.query.FrameBasedInlineDataSource;
import org.apache.druid.segment.column.RowSignature;

public class FrameBasedInlineDataSourceSerializer
extends StdSerializer<FrameBasedInlineDataSource> {
    public FrameBasedInlineDataSourceSerializer() {
        super(FrameBasedInlineDataSource.class);
    }

    public void serialize(FrameBasedInlineDataSource value, JsonGenerator jg, SerializerProvider serializers) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("type", "inline");
        RowSignature rowSignature = value.getRowSignature();
        jg.writeObjectField("columnNames", rowSignature.getColumnNames());
        List columnTypes = IntStream.range(0, rowSignature.size()).mapToObj(i -> rowSignature.getColumnType(i).orElse(null)).collect(Collectors.toList());
        jg.writeObjectField("columnTypes", columnTypes);
        jg.writeArrayFieldStart("rows");
        value.getRowsAsSequence().forEach(row -> {
            try {
                JacksonUtils.writeObjectUsingSerializerProvider(jg, serializers, row);
            }
            catch (IOException e) {
                ArrayList<String> elements = new ArrayList<String>();
                for (Object o : row) {
                    elements.add(o.toString());
                }
                throw new RE(e, "Exception encountered while serializing [%s] in [%s]", String.join((CharSequence)", ", elements), FrameBasedInlineDataSource.class);
            }
        });
        jg.writeEndArray();
        jg.writeEndObject();
    }

    public void serializeWithType(FrameBasedInlineDataSource value, JsonGenerator jg, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(value, jg, serializers);
    }
}

