/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.PerSegmentQueryOptimizationContext;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.context.ResponseContext;

public final class QueryPlus<T> {
    private final Query<T> query;
    private final QueryMetrics<?> queryMetrics;
    private final String identity;

    public static <T> QueryPlus<T> wrap(Query<T> query) {
        Preconditions.checkNotNull(query);
        return new QueryPlus<T>(query, null, null);
    }

    private QueryPlus(Query<T> query, QueryMetrics<?> queryMetrics, String identity) {
        this.query = query;
        this.queryMetrics = queryMetrics;
        this.identity = identity;
    }

    public Query<T> getQuery() {
        return this.query;
    }

    @Nullable
    public QueryMetrics<?> getQueryMetrics() {
        return this.queryMetrics;
    }

    public QueryPlus<T> withIdentity(String identity) {
        return new QueryPlus<T>(this.query, this.queryMetrics, identity);
    }

    public QueryPlus<T> withQueryMetrics(QueryToolChest<T, ? extends Query<T>> queryToolChest) {
        if (this.queryMetrics != null) {
            return this;
        }
        QueryMetrics<Query<T>> metrics = queryToolChest.makeMetrics(this.query);
        if (this.identity != null) {
            metrics.identity(this.identity);
        }
        return new QueryPlus<T>(this.query, metrics, this.identity);
    }

    public QueryPlus<T> withoutThreadUnsafeState() {
        return this.withoutQueryMetrics();
    }

    private QueryPlus<T> withoutQueryMetrics() {
        if (this.queryMetrics == null) {
            return this;
        }
        return new QueryPlus<T>(this.query, null, this.identity);
    }

    public QueryPlus<T> withMaxQueuedBytes(long maxQueuedBytes) {
        return new QueryPlus<T>(this.query.withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)"maxQueuedBytes", (Object)maxQueuedBytes)), this.queryMetrics, this.identity);
    }

    public <U> QueryPlus<U> withQuery(Query<U> replacementQuery) {
        return new QueryPlus<U>(replacementQuery, this.queryMetrics, this.identity);
    }

    public Sequence<T> run(QuerySegmentWalker walker, ResponseContext context) {
        return this.query.getRunner(walker).run(this, context);
    }

    public QueryPlus<T> optimizeForSegment(PerSegmentQueryOptimizationContext optimizationContext) {
        return new QueryPlus<T>(this.query.optimizeForSegment(optimizationContext), this.queryMetrics, this.identity);
    }
}

