/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.firstlast.last;

import com.google.common.primitives.Longs;
import javax.annotation.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.query.aggregation.ObjectAggregateCombiner;
import org.apache.druid.segment.ColumnValueSelector;

public class GenericLastAggregateCombiner<T extends SerializablePair<Long, ?>>
extends ObjectAggregateCombiner<T> {
    private T lastValue;
    private final Class<T> pairClass;

    public GenericLastAggregateCombiner(Class<T> pairClass) {
        this.pairClass = pairClass;
    }

    @Override
    public void reset(ColumnValueSelector selector) {
        this.lastValue = (SerializablePair)selector.getObject();
    }

    @Override
    public void fold(ColumnValueSelector selector) {
        SerializablePair newValue = (SerializablePair)selector.getObject();
        if (Longs.compare((long)((Long)((SerializablePair)this.lastValue).lhs), (long)((Long)newValue.lhs)) < 0) {
            this.lastValue = newValue;
        }
    }

    @Override
    @Nullable
    public T getObject() {
        return this.lastValue;
    }

    @Override
    public Class<? extends T> classOfObject() {
        return this.pairClass;
    }
}

