/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.firstlast.last;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.firstlast.FirstLastUtils;
import org.apache.druid.query.aggregation.firstlast.first.StringFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.GenericLastAggregateCombiner;
import org.apache.druid.query.aggregation.firstlast.last.SingleStringLastDimensionVectorAggregator;
import org.apache.druid.query.aggregation.firstlast.last.StringLastAggregator;
import org.apache.druid.query.aggregation.firstlast.last.StringLastBufferAggregator;
import org.apache.druid.query.aggregation.firstlast.last.StringLastVectorAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.ExpressionVectorSelectors;

@JsonTypeName(value="stringLast")
public class StringLastAggregatorFactory
extends AggregatorFactory {
    public static final ColumnType TYPE = ColumnType.ofComplex("serializablePairLongString");
    private static final Aggregator NIL_AGGREGATOR = new StringLastAggregator((BaseLongColumnValueSelector)NilColumnValueSelector.instance(), (BaseObjectColumnValueSelector)NilColumnValueSelector.instance(), 0, false){

        @Override
        public void aggregate() {
        }
    };
    private static final BufferAggregator NIL_BUFFER_AGGREGATOR = new StringLastBufferAggregator((BaseLongColumnValueSelector)NilColumnValueSelector.instance(), (BaseObjectColumnValueSelector)NilColumnValueSelector.instance(), 0, false){

        @Override
        public void aggregate(ByteBuffer buf, int position) {
        }
    };
    private final String fieldName;
    private final String timeColumn;
    private final String name;
    protected final int maxStringBytes;

    @JsonCreator
    public StringLastAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="timeColumn") @Nullable String timeColumn, @JsonProperty(value="maxStringBytes") Integer maxStringBytes) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        if (maxStringBytes != null && maxStringBytes < 0) {
            throw new IAE("maxStringBytes must be greater than 0", new Object[0]);
        }
        this.name = name;
        this.fieldName = fieldName;
        this.timeColumn = timeColumn == null ? "__time" : timeColumn;
        this.maxStringBytes = maxStringBytes == null ? 1024 : maxStringBytes;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_AGGREGATOR;
        }
        return new StringLastAggregator(metricFactory.makeColumnValueSelector(this.timeColumn), valueSelector, this.maxStringBytes, FirstLastUtils.selectorNeedsFoldCheck(valueSelector, metricFactory.getColumnCapabilities(this.fieldName), SerializablePairLongString.class));
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_BUFFER_AGGREGATOR;
        }
        return new StringLastBufferAggregator(metricFactory.makeColumnValueSelector(this.timeColumn), valueSelector, this.maxStringBytes, FirstLastUtils.selectorNeedsFoldCheck(valueSelector, metricFactory.getColumnCapabilities(this.fieldName), SerializablePairLongString.class));
    }

    @Override
    public boolean canVectorize(ColumnInspector columnInspector) {
        return true;
    }

    @Override
    public VectorAggregator factorizeVector(VectorColumnSelectorFactory selectorFactory) {
        SingleValueDimensionVectorSelector sSelector;
        ColumnCapabilities capabilities = selectorFactory.getColumnCapabilities(this.fieldName);
        VectorValueSelector timeSelector = selectorFactory.makeValueSelector(this.timeColumn);
        if (Types.isNumeric(capabilities)) {
            VectorValueSelector valueSelector = selectorFactory.makeValueSelector(this.fieldName);
            VectorObjectSelector objectSelector = ExpressionVectorSelectors.castValueSelectorToObject(selectorFactory.getReadableVectorInspector(), this.fieldName, valueSelector, capabilities.toColumnType(), ColumnType.STRING);
            return new StringLastVectorAggregator(timeSelector, objectSelector, this.maxStringBytes);
        }
        if (capabilities != null && capabilities.is(ValueType.STRING) && capabilities.isDictionaryEncoded().isTrue() && !capabilities.hasMultipleValues().isTrue() && (sSelector = selectorFactory.makeSingleValueDimensionSelector(DefaultDimensionSpec.of(this.fieldName))).nameLookupPossibleInAdvance()) {
            return new SingleStringLastDimensionVectorAggregator(timeSelector, sSelector, this.maxStringBytes);
        }
        VectorObjectSelector vSelector = selectorFactory.makeObjectSelector(this.fieldName);
        if (capabilities != null) {
            return new StringLastVectorAggregator(timeSelector, vSelector, this.maxStringBytes);
        }
        return new StringLastVectorAggregator(null, vSelector, this.maxStringBytes);
    }

    @Override
    public Comparator getComparator() {
        return StringFirstAggregatorFactory.VALUE_COMPARATOR;
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return StringFirstAggregatorFactory.TIME_COMPARATOR.compare(lhs, rhs) > 0 ? lhs : rhs;
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new GenericLastAggregateCombiner<SerializablePairLongString>(SerializablePairLongString.class);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new StringLastAggregatorFactory(this.name, this.name, this.timeColumn, this.maxStringBytes);
    }

    @Override
    public Object deserialize(Object object) {
        Map map = (Map)object;
        return new SerializablePairLongString(((Number)map.get("lhs")).longValue(), (String)map.get("rhs"));
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object == null ? null : ((SerializablePairLongString)object).rhs;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public String getTimeColumn() {
        return this.timeColumn;
    }

    @JsonProperty
    public Integer getMaxStringBytes() {
        return this.maxStringBytes;
    }

    @Override
    public List<String> requiredFields() {
        return ImmutableList.of((Object)this.timeColumn, (Object)this.fieldName);
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(44).appendString(this.fieldName).appendString(this.timeColumn).appendInt(this.maxStringBytes).build();
    }

    @Override
    public ColumnType getIntermediateType() {
        return TYPE;
    }

    @Override
    public ColumnType getResultType() {
        return ColumnType.STRING;
    }

    @Override
    public int getMaxIntermediateSize() {
        return 12 + this.maxStringBytes;
    }

    @Override
    public AggregatorFactory withName(String newName) {
        return new StringLastAggregatorFactory(newName, this.getFieldName(), this.getTimeColumn(), this.getMaxStringBytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringLastAggregatorFactory that = (StringLastAggregatorFactory)o;
        return this.maxStringBytes == that.maxStringBytes && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.timeColumn, that.timeColumn) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.name, this.maxStringBytes, this.timeColumn);
    }

    public String toString() {
        return "StringLastAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", name='" + this.name + '\'' + ", maxStringBytes=" + this.maxStringBytes + ", timeColumn=" + this.timeColumn + '}';
    }
}

