/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.dimension;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;

public class DefaultDimensionSpec
implements DimensionSpec {
    private static final byte CACHE_TYPE_ID = 0;
    private final String dimension;
    private final String outputName;
    private final ColumnType outputType;

    public static DefaultDimensionSpec of(String dimensionName) {
        return new DefaultDimensionSpec(dimensionName, dimensionName);
    }

    public static DefaultDimensionSpec of(String dimensionName, ColumnType columnType) {
        return new DefaultDimensionSpec(dimensionName, dimensionName, columnType);
    }

    @JsonCreator
    public DefaultDimensionSpec(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="outputName") @Nullable String outputName, @JsonProperty(value="outputType") @Nullable ColumnType outputType) {
        this.dimension = dimension;
        this.outputType = outputType == null ? ColumnType.STRING : outputType;
        this.outputName = outputName == null ? dimension : outputName;
    }

    public DefaultDimensionSpec(String dimension, String outputName) {
        this(dimension, outputName, ColumnType.STRING);
    }

    @Override
    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @Override
    @JsonProperty
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    @JsonProperty
    public ColumnType getOutputType() {
        return this.outputType;
    }

    @Override
    public ExtractionFn getExtractionFn() {
        return null;
    }

    @Override
    public DimensionSelector decorate(DimensionSelector selector) {
        return selector;
    }

    @Override
    public SingleValueDimensionVectorSelector decorate(SingleValueDimensionVectorSelector selector) {
        return selector;
    }

    @Override
    public MultiValueDimensionVectorSelector decorate(MultiValueDimensionVectorSelector selector) {
        return selector;
    }

    @Override
    public boolean canVectorize() {
        return true;
    }

    @Override
    public boolean mustDecorate() {
        return false;
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(0).appendString(this.dimension).appendString(this.outputType.toString()).build();
    }

    @Override
    public boolean preservesOrdering() {
        return true;
    }

    @Override
    public DimensionSpec withDimension(String newDimension) {
        return new DefaultDimensionSpec(newDimension, this.outputName, this.outputType);
    }

    public String toString() {
        return "DefaultDimensionSpec{dimension='" + this.dimension + '\'' + ", outputName='" + this.outputName + '\'' + ", outputType='" + this.outputType + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultDimensionSpec)) {
            return false;
        }
        DefaultDimensionSpec that = (DefaultDimensionSpec)o;
        if (!Objects.equals(this.dimension, that.dimension)) {
            return false;
        }
        if (!Objects.equals(this.outputName, that.outputName)) {
            return false;
        }
        return Objects.equals(this.outputType, that.outputType);
    }

    public int hashCode() {
        int result = this.dimension != null ? this.dimension.hashCode() : 0;
        result = 31 * result + (this.outputName != null ? this.outputName.hashCode() : 0);
        result = 31 * result + (this.outputType != null ? this.outputType.hashCode() : 0);
        return result;
    }
}

