/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import inet.ipaddr.ipv4.IPv4Address;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.expression.IPv4AddressExprUtils;

public class IPv4AddressParseExprMacro
implements ExprMacroTable.ExprMacro {
    public static final String FN_NAME = "ipv4_parse";

    @Override
    public String name() {
        return FN_NAME;
    }

    @Override
    public Expr apply(List<Expr> args) {
        this.validationHelperCheckArgumentCount(args, 1);
        final Expr arg = args.get(0);
        class IPv4AddressParseExpr
        extends ExprMacroTable.BaseScalarMacroFunctionExpr {
            IPv4AddressParseExpr(List<Expr> args) {
                super(this$0, args);
            }

            @Override
            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                ExprEval eval = arg.eval(bindings);
                switch ((ExprType)eval.type().getType()) {
                    case STRING: {
                        return IPv4AddressParseExprMacro.evalAsString(eval);
                    }
                    case LONG: {
                        return IPv4AddressParseExprMacro.evalAsLong(eval);
                    }
                }
                return ExprEval.ofLong(null);
            }

            @Override
            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return ExpressionType.LONG;
            }
        }
        return new IPv4AddressParseExpr(args);
    }

    private static ExprEval evalAsString(ExprEval eval) {
        IPv4Address address = IPv4AddressExprUtils.parse(eval.asString());
        Long value = address == null ? null : Long.valueOf(IPv4AddressExprUtils.toLong(address));
        return ExprEval.ofLong(value);
    }

    private static ExprEval evalAsLong(ExprEval eval) {
        if (eval.isNumericNull() || !IPv4AddressExprUtils.overflowsUnsignedInt(eval.asLong())) {
            return eval;
        }
        return ExprEval.ofLong(null);
    }
}

