/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.groupby.epinephelinae.DictionaryBuildingUtils;
import org.apache.druid.query.groupby.epinephelinae.column.DimensionIdCodec;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.druid.query.groupby.epinephelinae.column.KeyMappingGroupByColumnSelectorStrategy;
import org.apache.druid.query.groupby.epinephelinae.column.MemoryFootprint;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.NullableTypeStrategy;

@NotThreadSafe
public class DictionaryBuildingGroupByColumnSelectorStrategy<DimensionType>
extends KeyMappingGroupByColumnSelectorStrategy<DimensionType> {
    private DictionaryBuildingGroupByColumnSelectorStrategy(DimensionIdCodec<DimensionType> dimensionIdCodec, ColumnType columnType, NullableTypeStrategy<DimensionType> nullableTypeStrategy, DimensionType defaultValue) {
        super(dimensionIdCodec, columnType, nullableTypeStrategy, defaultValue);
    }

    public static GroupByColumnSelectorStrategy forType(ColumnType columnType) {
        if (columnType.equals(ColumnType.STRING)) {
            throw DruidException.defensive("Should use special variant which handles multi-value dimensions", new Object[0]);
        }
        if (columnType.equals(ColumnType.DOUBLE) || columnType.equals(ColumnType.FLOAT) || columnType.equals(ColumnType.LONG)) {
            throw DruidException.defensive("Could used a fixed width strategy", new Object[0]);
        }
        if (ColumnType.STRING_ARRAY.equals(columnType)) {
            DictionaryBuildingGroupByColumnSelectorStrategy.forStringArrays();
        }
        return DictionaryBuildingGroupByColumnSelectorStrategy.forArrayAndComplexTypes(columnType);
    }

    private static GroupByColumnSelectorStrategy forArrayAndComplexTypes(ColumnType columnType) {
        return new DictionaryBuildingGroupByColumnSelectorStrategy<Object>(new UniValueDimensionIdCodec(columnType.getNullableStrategy()), columnType, columnType.getNullableStrategy(), null);
    }

    private static GroupByColumnSelectorStrategy forStringArrays() {
        return new DictionaryBuildingGroupByColumnSelectorStrategy<Object>(new StringArrayDimensionIdCodec(), ColumnType.STRING_ARRAY, ColumnType.STRING_ARRAY.getNullableStrategy(), null);
    }

    private static class StringArrayDimensionIdCodec
    implements DimensionIdCodec<Object> {
        private final BiMap<String, Integer> elementBiDictionary = HashBiMap.create();
        private final BiMap<ArrayList<Integer>, Integer> arrayBiDictionary = HashBiMap.create();

        private StringArrayDimensionIdCodec() {
        }

        @Override
        public MemoryFootprint<Integer> lookupId(Object dimension) {
            Object[] stringArray = (Object[])dimension;
            ArrayList<Integer> dictionaryEncodedStringArray = new ArrayList<Integer>();
            int estimatedFootprint = 0;
            for (Object element : stringArray) {
                String elementCasted = (String)element;
                Integer elementDictId = (Integer)this.elementBiDictionary.get((Object)elementCasted);
                if (elementDictId == null) {
                    elementDictId = this.elementBiDictionary.size();
                    this.elementBiDictionary.put((Object)elementCasted, (Object)elementDictId);
                    estimatedFootprint += DictionaryBuildingUtils.estimateEntryFootprint(elementCasted == null ? 0 : elementCasted.length() * 2);
                }
                dictionaryEncodedStringArray.add(elementDictId);
            }
            Integer arrayDictId = (Integer)this.arrayBiDictionary.get(dictionaryEncodedStringArray);
            if (arrayDictId == null) {
                arrayDictId = this.arrayBiDictionary.size();
                this.arrayBiDictionary.put(dictionaryEncodedStringArray, (Object)arrayDictId);
                estimatedFootprint += DictionaryBuildingUtils.estimateEntryFootprint(dictionaryEncodedStringArray.size() * 4);
            }
            return new MemoryFootprint<Integer>(arrayDictId, estimatedFootprint);
        }

        @Override
        public Object idToKey(int id) {
            ArrayList dictionaryEncodedStringArray = (ArrayList)this.arrayBiDictionary.inverse().get((Object)id);
            Object[] stringRepresentation = new Object[dictionaryEncodedStringArray.size()];
            for (int i = 0; i < dictionaryEncodedStringArray.size(); ++i) {
                stringRepresentation[i] = this.elementBiDictionary.inverse().get(dictionaryEncodedStringArray.get(i));
            }
            return stringRepresentation;
        }

        @Override
        public boolean canCompareIds() {
            return false;
        }

        @Override
        public void reset() {
            this.arrayBiDictionary.clear();
            this.elementBiDictionary.clear();
        }
    }

    private static class UniValueDimensionIdCodec
    implements DimensionIdCodec<Object> {
        private final List<Object> dictionary = DictionaryBuildingUtils.createDictionary();
        private final Object2IntMap<Object> reverseDictionary;
        private final NullableTypeStrategy nullableTypeStrategy;

        public UniValueDimensionIdCodec(NullableTypeStrategy nullableTypeStrategy) {
            this.reverseDictionary = DictionaryBuildingUtils.createReverseDictionary(nullableTypeStrategy);
            this.nullableTypeStrategy = nullableTypeStrategy;
        }

        @Override
        public MemoryFootprint<Integer> lookupId(Object dimension) {
            int dictId = this.reverseDictionary.getInt(dimension);
            int footprintIncrease = 0;
            if (dictId < 0) {
                int size = this.dictionary.size();
                this.dictionary.add(dimension);
                this.reverseDictionary.put(dimension, size);
                dictId = size;
                footprintIncrease = DictionaryBuildingUtils.estimateEntryFootprint(this.nullableTypeStrategy.estimateSizeBytes(dimension));
            }
            return new MemoryFootprint<Integer>(dictId, footprintIncrease);
        }

        @Override
        public Object idToKey(int id) {
            if (id >= this.dictionary.size()) {
                throw DruidException.defensive("Unknown dictionary id [%d]", id);
            }
            return this.dictionary.get(id);
        }

        @Override
        public boolean canCompareIds() {
            return false;
        }

        @Override
        public void reset() {
            this.dictionary.clear();
            this.reverseDictionary.clear();
        }
    }
}

