/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.RowSignature;

public class ScanResultValue
implements Comparable<ScanResultValue> {
    private final String segmentId;
    private final List<String> columns;
    private final Object events;
    private final RowSignature rowSignature;

    @JsonCreator
    public ScanResultValue(@JsonProperty(value="segmentId") @Nullable String segmentId, @JsonProperty(value="columns") List<String> columns, @JsonProperty(value="events") Object events, @Nullable @JsonProperty(value="rowSignature") RowSignature rowSignature) {
        this.segmentId = segmentId;
        this.columns = columns;
        this.events = events;
        this.rowSignature = rowSignature;
    }

    public ScanResultValue(String segmentId, List<String> columns, Object events) {
        this(segmentId, columns, events, null);
    }

    @Nullable
    @JsonProperty
    public String getSegmentId() {
        return this.segmentId;
    }

    @JsonProperty
    public List<String> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Object getEvents() {
        return this.events;
    }

    @Nullable
    @JsonProperty
    public RowSignature getRowSignature() {
        return this.rowSignature;
    }

    public long getFirstEventTimestamp(ScanQuery.ResultFormat resultFormat) {
        if (resultFormat.equals((Object)ScanQuery.ResultFormat.RESULT_FORMAT_LIST)) {
            Object timestampObj = ((Map)((List)this.getEvents()).get(0)).get("__time");
            if (timestampObj == null) {
                throw new ISE("Unable to compare timestamp for rows without a time column", new Object[0]);
            }
            return DimensionHandlerUtils.convertObjectToLong(timestampObj);
        }
        if (resultFormat.equals((Object)ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST)) {
            int timeColumnIndex = this.getColumns().indexOf("__time");
            if (timeColumnIndex == -1) {
                throw new ISE("Unable to compare timestamp for rows without a time column", new Object[0]);
            }
            List firstEvent = (List)((List)this.getEvents()).get(0);
            return DimensionHandlerUtils.convertObjectToLong(firstEvent.get(timeColumnIndex));
        }
        throw new UOE("Unable to get first event timestamp using result format of [%s]", resultFormat.toString());
    }

    public List<ScanResultValue> toSingleEventScanResultValues() {
        ArrayList<ScanResultValue> singleEventScanResultValues = new ArrayList<ScanResultValue>();
        List events = (List)this.getEvents();
        for (Object event : events) {
            singleEventScanResultValues.add(new ScanResultValue(this.segmentId, this.columns, Collections.singletonList(event), this.rowSignature));
        }
        return singleEventScanResultValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanResultValue that = (ScanResultValue)o;
        if (!Objects.equals(this.segmentId, that.segmentId)) {
            return false;
        }
        if (!Objects.equals(this.columns, that.columns)) {
            return false;
        }
        if (!Objects.equals(this.rowSignature, that.rowSignature)) {
            return false;
        }
        return Objects.equals(this.events, that.events);
    }

    public int hashCode() {
        int result = this.segmentId != null ? this.segmentId.hashCode() : 0;
        result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
        result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
        result = 31 * result + (this.rowSignature != null ? this.rowSignature.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ScanResultValue{segmentId='" + this.segmentId + '\'' + ", columns=" + this.columns + ", events=" + this.events + ", rowSignature=" + this.rowSignature + '}';
    }

    @Override
    public int compareTo(ScanResultValue that) {
        if (that == null) {
            return 1;
        }
        if (this.segmentId != null && that.segmentId != null) {
            return this.segmentId.compareTo(that.segmentId);
        }
        return this.segmentId != null ? 1 : 0;
    }
}

