/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.topn.TopNAlgorithmSelector;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpecBuilder;
import org.apache.druid.query.topn.TopNNumericResultBuilder;
import org.apache.druid.query.topn.TopNResultBuilder;
import org.joda.time.DateTime;

public class NumericTopNMetricSpec
implements TopNMetricSpec {
    private static final byte CACHE_TYPE_ID = 0;
    private final String metric;

    @JsonCreator
    public NumericTopNMetricSpec(@JsonProperty(value="metric") String metric) {
        this.metric = metric;
    }

    @Override
    public void verifyPreconditions(List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs) {
        Preconditions.checkNotNull((Object)this.metric, (Object)"metric can't be null");
        Preconditions.checkNotNull(aggregatorSpecs, (Object)"aggregations cannot be null");
        Preconditions.checkArgument((aggregatorSpecs.size() > 0 || postAggregatorSpecs.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least one AggregatorFactory or PostAggregator");
        AggregatorFactory aggregator = (AggregatorFactory)Iterables.tryFind(aggregatorSpecs, (Predicate)new Predicate<AggregatorFactory>(){

            public boolean apply(AggregatorFactory input) {
                return input.getName().equals(NumericTopNMetricSpec.this.metric);
            }
        }).orNull();
        PostAggregator postAggregator = (PostAggregator)Iterables.tryFind(postAggregatorSpecs, (Predicate)new Predicate<PostAggregator>(){

            public boolean apply(PostAggregator input) {
                return input.getName().equals(NumericTopNMetricSpec.this.metric);
            }
        }).orNull();
        Preconditions.checkArgument((aggregator != null || postAggregator != null ? 1 : 0) != 0, (String)"Must have an AggregatorFactory or PostAggregator for metric[%s], gave[%s] and [%s]", (Object)this.metric, aggregatorSpecs, postAggregatorSpecs);
    }

    @JsonProperty
    public String getMetric() {
        return this.metric;
    }

    @Override
    public Comparator getComparator(List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs) {
        Comparator comp = null;
        for (AggregatorFactory factory : aggregatorSpecs) {
            if (!this.metric.equals(factory.getName())) continue;
            comp = factory.getComparator();
            break;
        }
        for (PostAggregator pf : postAggregatorSpecs) {
            if (!this.metric.equals(pf.getName())) continue;
            comp = pf.getComparator();
            break;
        }
        return comp;
    }

    @Override
    public TopNResultBuilder getResultBuilder(DateTime timestamp, DimensionSpec dimSpec, int threshold, Comparator comparator, List<AggregatorFactory> aggFactories, List<PostAggregator> postAggs) {
        return new TopNNumericResultBuilder(timestamp, dimSpec, this.metric, threshold, comparator, aggFactories, postAggs);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] metricBytes = StringUtils.toUtf8(this.metric);
        return ByteBuffer.allocate(1 + metricBytes.length).put((byte)0).put(metricBytes).array();
    }

    @Override
    public <T> TopNMetricSpecBuilder<T> configureOptimizer(TopNMetricSpecBuilder<T> builder) {
        return builder;
    }

    @Override
    public void initTopNAlgorithmSelector(TopNAlgorithmSelector selector) {
        selector.setAggregateTopNMetricFirst(true);
    }

    @Override
    public String getMetricName(DimensionSpec dimSpec) {
        return this.metric;
    }

    @Override
    public boolean canBeOptimizedUnordered() {
        return true;
    }

    public String toString() {
        return "NumericTopNMetricSpec{metric='" + this.metric + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericTopNMetricSpec that = (NumericTopNMetricSpec)o;
        return !(this.metric != null ? !this.metric.equals(that.metric) : that.metric != null);
    }

    public int hashCode() {
        return this.metric != null ? this.metric.hashCode() : 0;
    }
}

