/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.segment.serde.cell.StorableBuffer;

public interface StagedSerde<T> {
    public StorableBuffer serializeDelayed(@Nullable T var1);

    default public byte[] serialize(T value) {
        StorableBuffer storableBuffer = this.serializeDelayed(value);
        ByteBuffer byteBuffer = ByteBuffer.allocate(storableBuffer.getSerializedSize()).order(ByteOrder.nativeOrder());
        storableBuffer.store(byteBuffer);
        return byteBuffer.array();
    }

    @Nullable
    public T deserialize(ByteBuffer var1);

    default public T deserialize(byte[] bytes) {
        return this.deserialize(ByteBuffer.wrap(bytes).order(ByteOrder.nativeOrder()));
    }
}

