/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.vector;

import com.google.common.base.Preconditions;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.segment.vector.VectorOffset;
import org.roaringbitmap.BatchIterator;

public class BitmapVectorOffset
implements VectorOffset {
    private final ImmutableBitmap bitmap;
    private final int[] offsets;
    private final int startOffset;
    private final int endOffset;
    private BatchIterator iterator;
    private boolean pastEnd;
    private int currentVectorSize;
    private boolean isContiguous;

    public BitmapVectorOffset(int vectorSize, ImmutableBitmap bitmap, int startOffset, int endOffset) {
        this.bitmap = bitmap;
        this.offsets = new int[vectorSize];
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.reset();
    }

    @Override
    public int getId() {
        Preconditions.checkState((this.currentVectorSize > 0 ? 1 : 0) != 0, (Object)"currentVectorSize > 0");
        return this.offsets[0];
    }

    @Override
    public void advance() {
        this.currentVectorSize = 0;
        this.isContiguous = false;
        if (this.pastEnd) {
            return;
        }
        while (this.currentVectorSize == 0 && this.iterator.hasNext()) {
            int to;
            int from;
            int numRead = this.iterator.nextBatch(this.offsets);
            for (from = 0; from < numRead && this.offsets[from] < this.startOffset; ++from) {
            }
            if (from > 0) {
                System.arraycopy(this.offsets, from, this.offsets, 0, numRead - from);
            }
            for (to = numRead - from; to > 0 && this.offsets[to - 1] >= this.endOffset; --to) {
                this.pastEnd = true;
            }
            this.currentVectorSize = to;
        }
        if (this.currentVectorSize > 1) {
            int adjusted = this.currentVectorSize - 1;
            this.isContiguous = this.offsets[adjusted] - this.offsets[0] == adjusted;
        }
    }

    @Override
    public boolean isDone() {
        return this.currentVectorSize == 0;
    }

    @Override
    public boolean isContiguous() {
        return this.isContiguous;
    }

    @Override
    public int getMaxVectorSize() {
        return this.offsets.length;
    }

    @Override
    public int getCurrentVectorSize() {
        return this.currentVectorSize;
    }

    @Override
    public int getStartOffset() {
        if (this.isContiguous) {
            return this.offsets[0];
        }
        throw new UnsupportedOperationException("not contiguous");
    }

    @Override
    public int[] getOffsets() {
        if (this.isContiguous) {
            throw new UnsupportedOperationException("is contiguous");
        }
        return this.offsets;
    }

    @Override
    public void reset() {
        this.iterator = this.bitmap.batchIterator();
        this.currentVectorSize = 0;
        this.pastEnd = false;
        this.isContiguous = false;
        this.advance();
    }
}

