/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.timeline.Overshadowable;
import org.apache.druid.timeline.partition.OvershadowableManager;
import org.apache.druid.timeline.partition.PartitionChunk;

public class PartitionHolder<T extends Overshadowable<T>>
implements Iterable<PartitionChunk<T>> {
    private final OvershadowableManager<T> overshadowableManager;
    private short maxMinorVersion;

    public static <T extends Overshadowable<T>> PartitionHolder<T> copyWithOnlyVisibleChunks(PartitionHolder<T> partitionHolder) {
        return new PartitionHolder<T>(OvershadowableManager.copyVisible(partitionHolder.overshadowableManager), partitionHolder.maxMinorVersion);
    }

    public static <T extends Overshadowable<T>> PartitionHolder<T> deepCopy(PartitionHolder<T> partitionHolder) {
        return new PartitionHolder<T>(OvershadowableManager.deepCopy(partitionHolder.overshadowableManager), partitionHolder.maxMinorVersion);
    }

    public PartitionHolder(PartitionChunk<T> initialChunk) {
        this.overshadowableManager = new OvershadowableManager();
        this.add(initialChunk);
    }

    public PartitionHolder(List<PartitionChunk<T>> initialChunks) {
        this.overshadowableManager = new OvershadowableManager();
        for (PartitionChunk<T> chunk : initialChunks) {
            this.add(chunk);
        }
    }

    protected PartitionHolder(OvershadowableManager<T> overshadowableManager, short maxMinorVersion) {
        this.overshadowableManager = overshadowableManager;
        this.maxMinorVersion = maxMinorVersion;
    }

    public boolean add(PartitionChunk<T> chunk) {
        boolean added = this.overshadowableManager.addChunk(chunk);
        if (added && ((Overshadowable)chunk.getObject()).getMinorVersion() > this.maxMinorVersion) {
            this.maxMinorVersion = ((Overshadowable)chunk.getObject()).getMinorVersion();
        }
        return added;
    }

    public short getMaxMinorVersion() {
        return this.maxMinorVersion;
    }

    @Nullable
    public PartitionChunk<T> remove(PartitionChunk<T> chunk) {
        return this.overshadowableManager.removeChunk(chunk);
    }

    public boolean isEmpty() {
        return this.overshadowableManager.isEmpty();
    }

    public boolean isComplete() {
        if (this.overshadowableManager.isEmpty()) {
            return false;
        }
        Iterator<PartitionChunk<T>> iter = this.iterator();
        PartitionChunk<T> curr = iter.next();
        if (!curr.isStart()) {
            return false;
        }
        if (curr.isEnd()) {
            return this.overshadowableManager.isComplete();
        }
        while (iter.hasNext()) {
            PartitionChunk<T> next = iter.next();
            if (!curr.abuts(next)) {
                return false;
            }
            if (next.isEnd()) {
                return this.overshadowableManager.isComplete();
            }
            curr = next;
        }
        return false;
    }

    public PartitionChunk<T> getChunk(int partitionNum) {
        return this.overshadowableManager.getChunk(partitionNum);
    }

    @Override
    public Iterator<PartitionChunk<T>> iterator() {
        return this.overshadowableManager.visibleChunksIterator();
    }

    public List<PartitionChunk<T>> getOvershadowed() {
        return this.overshadowableManager.getOvershadowedChunks();
    }

    public Iterable<T> payloads() {
        return Iterables.transform((Iterable)this, PartitionChunk::getObject);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionHolder that = (PartitionHolder)o;
        return Objects.equals(this.overshadowableManager, that.overshadowableManager);
    }

    public int hashCode() {
        return Objects.hash(this.overshadowableManager);
    }

    public String toString() {
        return "PartitionHolder{overshadowableManager=" + this.overshadowableManager + '}';
    }

    public boolean hasData() {
        for (Overshadowable payload : this.payloads()) {
            if (!payload.hasData()) continue;
            return true;
        }
        return false;
    }
}

