/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.RangeSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;
import org.apache.druid.timeline.partition.TombstonePartitionedChunk;

public class TombstoneShardSpec
implements ShardSpec {
    public static TombstoneShardSpec INSTANCE = new TombstoneShardSpec();

    @Override
    @JsonProperty(value="partitionNum")
    public int getPartitionNum() {
        return 0;
    }

    @Override
    public ShardSpecLookup getLookup(List<? extends ShardSpec> shardSpecs) {
        return TombstoneShardSpec.createLookup(shardSpecs);
    }

    static ShardSpecLookup createLookup(List<? extends ShardSpec> shardSpecs) {
        return (timestamp, row) -> (ShardSpec)shardSpecs.get(0);
    }

    @Override
    public List<String> getDomainDimensions() {
        return ImmutableList.of();
    }

    @Override
    public boolean possibleInDomain(Map<String, RangeSet<String>> domain) {
        return true;
    }

    @Override
    @JsonProperty(value="partitions")
    public int getNumCorePartitions() {
        return 0;
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        return TombstonePartitionedChunk.make(obj);
    }

    @Override
    public String getType() {
        return "tombstone";
    }

    public String toString() {
        return "TombstoneShardSpec{partitionNum=" + this.getPartitionNum() + ", partitions=" + this.getNumCorePartitions() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hash(0);
    }
}

