/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections;

import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.druid.collections.CombiningIterable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.Result;
import org.junit.Assert;
import org.junit.Test;

public class CombiningIterableTest {
    @Test
    public void testCreateSplatted() {
        List<Integer> firstList = Arrays.asList(1, 2, 5, 7, 9, 10, 20);
        List<Integer> secondList = Arrays.asList(1, 2, 5, 8, 9);
        HashSet<Integer> mergedLists = new HashSet<Integer>();
        mergedLists.addAll(firstList);
        mergedLists.addAll(secondList);
        ArrayList<List<Integer>> iterators = new ArrayList<List<Integer>>();
        iterators.add(firstList);
        iterators.add(secondList);
        CombiningIterable actualIterable = CombiningIterable.createSplatted(iterators, (Comparator)Ordering.natural());
        Assert.assertEquals((long)mergedLists.size(), (long)Iterables.size((Iterable)actualIterable));
        HashSet actualHashset = Sets.newHashSet((Iterable)actualIterable);
        Assert.assertEquals((Object)actualHashset, mergedLists);
    }

    @Test
    public void testMerge() {
        List<Result> resultsBefore = Arrays.asList(new Result(DateTimes.of((String)"2011-01-01"), (Object)1L), new Result(DateTimes.of((String)"2011-01-01"), (Object)2L));
        List<Result> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-01"), (Object)3L));
        CombiningIterable resultsAfter = CombiningIterable.create(resultsBefore, Comparator.comparing(Result::getTimestamp), (arg1, arg2) -> {
            if (arg1 == null) {
                return arg2;
            }
            if (arg2 == null) {
                return arg1;
            }
            return new Result(arg1.getTimestamp(), (Object)((Long)arg1.getValue() + (Long)arg2.getValue()));
        });
        Iterator it1 = expectedResults.iterator();
        Iterator it2 = resultsAfter.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Result r1 = (Result)it1.next();
            Result r2 = (Result)it2.next();
            Assert.assertEquals((Object)r1.getTimestamp(), (Object)r2.getTimestamp());
            Assert.assertEquals((Object)r1.getValue(), (Object)r2.getValue());
        }
    }
}

