/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.druid.collections.RangeIntSet;
import org.junit.Assert;
import org.junit.Test;

public class RangeIntSetTest {
    @Test
    public void test_constructor_zeroZero() {
        Assert.assertEquals(Collections.emptySet(), (Object)new RangeIntSet(0, 0));
    }

    @Test
    public void test_constructor_zeroTwo() {
        Assert.assertEquals((Object)ImmutableSet.of((Object)0, (Object)1), (Object)new RangeIntSet(0, 2));
    }

    @Test
    public void test_contains() {
        Assert.assertFalse((boolean)new RangeIntSet(0, 2).contains(-1));
        Assert.assertTrue((boolean)new RangeIntSet(0, 2).contains(0));
        Assert.assertTrue((boolean)new RangeIntSet(0, 2).contains(1));
        Assert.assertFalse((boolean)new RangeIntSet(0, 2).contains(2));
        Assert.assertFalse((boolean)new RangeIntSet(0, 2).contains(3));
    }

    @Test
    public void test_headSet() {
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)new RangeIntSet(0, 2).headSet(-1));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)new RangeIntSet(0, 2).headSet(0));
        Assert.assertEquals((Object)ImmutableSet.of((Object)0), (Object)new RangeIntSet(0, 2).headSet(1));
        Assert.assertEquals((Object)ImmutableSet.of((Object)0, (Object)1), (Object)new RangeIntSet(0, 2).headSet(2));
        Assert.assertEquals((Object)ImmutableSet.of((Object)0, (Object)1), (Object)new RangeIntSet(0, 2).headSet(3));
    }

    @Test
    public void test_tailSet() {
        Assert.assertEquals((Object)ImmutableSet.of((Object)0, (Object)1), (Object)new RangeIntSet(0, 2).tailSet(-1));
        Assert.assertEquals((Object)ImmutableSet.of((Object)0, (Object)1), (Object)new RangeIntSet(0, 2).tailSet(0));
        Assert.assertEquals((Object)ImmutableSet.of((Object)1), (Object)new RangeIntSet(0, 2).tailSet(1));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)new RangeIntSet(0, 2).tailSet(2));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)new RangeIntSet(0, 2).tailSet(3));
    }

    @Test
    public void test_subSet() {
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)new RangeIntSet(0, 2).subSet(-2, -1));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)new RangeIntSet(0, 2).subSet(-1, 0));
        Assert.assertEquals((Object)ImmutableSet.of((Object)0), (Object)new RangeIntSet(0, 2).subSet(-1, 1));
        Assert.assertEquals((Object)ImmutableSet.of((Object)0, (Object)1), (Object)new RangeIntSet(0, 2).subSet(-1, 2));
        Assert.assertEquals((Object)ImmutableSet.of((Object)0, (Object)1), (Object)new RangeIntSet(0, 2).subSet(-1, 3));
        Assert.assertEquals((Object)ImmutableSet.of((Object)0), (Object)new RangeIntSet(0, 2).subSet(0, 1));
        Assert.assertEquals((Object)ImmutableSet.of((Object)0, (Object)1), (Object)new RangeIntSet(0, 2).subSet(0, 2));
        Assert.assertEquals((Object)ImmutableSet.of((Object)0, (Object)1), (Object)new RangeIntSet(0, 2).subSet(0, 3));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)new RangeIntSet(0, 2).subSet(1, 1));
        Assert.assertEquals((Object)ImmutableSet.of((Object)1), (Object)new RangeIntSet(0, 2).subSet(1, 2));
        Assert.assertEquals((Object)ImmutableSet.of((Object)1), (Object)new RangeIntSet(0, 2).subSet(1, 3));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)new RangeIntSet(0, 2).subSet(2, 3));
    }

    @Test
    public void test_firstInt() {
        Assert.assertEquals((long)0L, (long)new RangeIntSet(0, 2).firstInt());
        Assert.assertThrows(NoSuchElementException.class, () -> new RangeIntSet(0, 0).firstInt());
    }

    @Test
    public void test_lastInt() {
        Assert.assertEquals((long)1L, (long)new RangeIntSet(0, 2).lastInt());
        Assert.assertThrows(NoSuchElementException.class, () -> new RangeIntSet(0, 0).firstInt());
    }

    @Test
    public void test_size() {
        Assert.assertEquals((long)0L, (long)new RangeIntSet(0, 0).size());
        Assert.assertEquals((long)2L, (long)new RangeIntSet(0, 2).size());
    }

    @Test
    public void test_iterator() {
        Assert.assertEquals((Object)ImmutableList.of((Object)0, (Object)1), (Object)ImmutableList.copyOf((Iterator)new RangeIntSet(0, 2).iterator()));
    }

    @Test
    public void test_iterator_from() {
        Assert.assertEquals((Object)ImmutableList.of((Object)0, (Object)1), (Object)ImmutableList.copyOf((Iterator)new RangeIntSet(0, 2).iterator(0)));
        Assert.assertEquals((Object)ImmutableList.of((Object)1), (Object)ImmutableList.copyOf((Iterator)new RangeIntSet(0, 2).iterator(1)));
        Assert.assertEquals((Object)ImmutableList.of(), (Object)ImmutableList.copyOf((Iterator)new RangeIntSet(0, 2).iterator(2)));
        Assert.assertEquals((Object)ImmutableList.of(), (Object)ImmutableList.copyOf((Iterator)new RangeIntSet(0, 2).iterator(3)));
    }

    @Test
    public void test_equals() {
        Assert.assertEquals((Object)new RangeIntSet(0, 0), (Object)new RangeIntSet(0, 0));
        Assert.assertEquals((Object)new RangeIntSet(0, 0), (Object)new RangeIntSet(1, 0));
        Assert.assertNotEquals((Object)new RangeIntSet(0, 0), (Object)new RangeIntSet(0, 1));
    }

    @Test
    public void test_equals_empty() {
        Assert.assertEquals((Object)new RangeIntSet(0, 0), (Object)new RangeIntSet(1, 1));
        Assert.assertEquals((Object)new RangeIntSet(0, 0), (Object)new RangeIntSet(1, 0));
        Assert.assertEquals((Object)new RangeIntSet(0, 0), (Object)new RangeIntSet(0, -1));
    }

    @Test
    public void test_equals_otherSet() {
        Assert.assertEquals((Object)ImmutableSet.of((Object)0, (Object)1), (Object)new RangeIntSet(0, 2));
        Assert.assertNotEquals((Object)ImmutableSet.of((Object)0, (Object)1, (Object)2), (Object)new RangeIntSet(0, 2));
    }
}

