/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.spatial.search;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.collections.spatial.search.Bound;
import org.apache.druid.collections.spatial.search.RectangularBound;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.junit.Assert;
import org.junit.Test;

public class RectangularBoundTest {
    @Test
    public void testCacheKey() {
        Assert.assertArrayEquals((byte[])new RectangularBound(new float[]{1.0f, 1.0f}, new float[]{2.0f, 2.0f}, 1).getCacheKey(), (byte[])new RectangularBound(new float[]{1.0f, 1.0f}, new float[]{2.0f, 2.0f}, 1).getCacheKey());
        Assert.assertFalse((boolean)Arrays.equals(new RectangularBound(new float[]{1.0f, 1.0f}, new float[]{2.0f, 2.0f}, 1).getCacheKey(), new RectangularBound(new float[]{1.0f, 1.0f}, new float[]{2.0f, 3.0f}, 1).getCacheKey()));
        Assert.assertFalse((boolean)Arrays.equals(new RectangularBound(new float[]{1.0f, 1.0f}, new float[]{2.0f, 2.0f}, 1).getCacheKey(), new RectangularBound(new float[]{1.0f, 0.0f}, new float[]{2.0f, 2.0f}, 1).getCacheKey()));
        Assert.assertFalse((boolean)Arrays.equals(new RectangularBound(new float[]{1.0f, 1.0f}, new float[]{2.0f, 2.0f}, 1).getCacheKey(), new RectangularBound(new float[]{1.0f, 1.0f}, new float[]{2.0f, 2.0f}, 2).getCacheKey()));
    }

    @Test
    public void testRectangularBound() {
        float[][] insidePoints = new float[][]{{37.79572f, -122.40907f}, {37.796257f, -122.396385f}, {37.79686f, -122.39335f}, {37.79662f, -122.39798f}};
        float[][] outsidePoints = new float[][]{{37.798058f, -122.392365f}, {37.781975f, -122.41887f}, {37.798298f, -122.39609f}, {37.783596f, -122.41932f}};
        RectangularBound rectangularBound = new RectangularBound(new float[]{37.781857f, -122.41795f}, new float[]{37.797638f, -122.39229f}, 10);
        for (float[] insidePoint : insidePoints) {
            Assert.assertTrue((boolean)rectangularBound.contains(insidePoint));
        }
        for (float[] outsidePoint : outsidePoints) {
            Assert.assertFalse((boolean)rectangularBound.contains(outsidePoint));
        }
    }

    @Test
    public void testDeSer() throws JsonProcessingException {
        RectangularBound rectangularBound = new RectangularBound(new float[]{39.09497f, -84.517f}, new float[]{39.095474f, -84.51537f});
        DefaultObjectMapper objectMapper = DefaultObjectMapper.INSTANCE;
        String val = objectMapper.writeValueAsString((Object)rectangularBound);
        Bound deSerVal = (Bound)objectMapper.readValue(val, Bound.class);
        Assert.assertEquals((Object)deSerVal, (Object)rectangularBound);
    }

    @Test
    public void testEqualsContract() {
        EqualsVerifier.forClass(RectangularBound.class).usingGetClass().verify();
    }
}

