/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.utils;

import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class IdUtilsTest {
    private static final String THINGO = "thingToValidate";
    public static final String VALID_ID_CHARS = "alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!";

    @Test
    public void testValidIdName() {
        IdUtils.validateId((String)THINGO, (String)VALID_ID_CHARS);
    }

    @Test
    public void testInvalidNull() {
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [thingToValidate]: must not be null").assertThrowsAndMatches(() -> IdUtils.validateId((String)THINGO, null));
    }

    @Test
    public void testInvalidEmpty() {
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [thingToValidate]: must not be null").assertThrowsAndMatches(() -> IdUtils.validateId((String)THINGO, (String)""));
    }

    @Test
    public void testInvalidSlashes() {
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [thingToValidate]: Value [/paths/are/bad/since/we/make/files/from/stuff] cannot contain '/'.").assertThrowsAndMatches(() -> IdUtils.validateId((String)THINGO, (String)"/paths/are/bad/since/we/make/files/from/stuff"));
    }

    @Test
    public void testInvalidLeadingDot() {
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [thingToValidate]: Value [./nice/try] cannot start with '.'.").assertThrowsAndMatches(() -> IdUtils.validateId((String)THINGO, (String)"./nice/try"));
    }

    @Test
    public void testInvalidSpacesRegexTabs() {
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [thingToValidate]: Value [spaces\tare\tbetter\tthan\ttabs\twhich\tare\tillegal] contains illegal whitespace characters.  Only space is allowed.").assertThrowsAndMatches(() -> IdUtils.validateId((String)THINGO, (String)"spaces\tare\tbetter\tthan\ttabs\twhich\tare\tillegal"));
    }

    @Test
    public void testInvalidSpacesRegexNewline() {
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [thingToValidate]: Value [new\nline] contains illegal whitespace characters.  Only space is allowed.").assertThrowsAndMatches(() -> IdUtils.validateId((String)THINGO, (String)"new\nline"));
    }

    @Test
    public void testInvalidSpacesRegexCarriageReturn() {
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [thingToValidate]: Value [does\rexist\rby\ritself] contains illegal whitespace characters.  Only space is allowed.").assertThrowsAndMatches(() -> IdUtils.validateId((String)THINGO, (String)"does\rexist\rby\ritself"));
    }

    @Test
    public void testInvalidSpacesRegexLineTabulation() {
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [thingToValidate]: Value [what\u000bis line tabulation] contains illegal whitespace characters.  Only space is allowed.").assertThrowsAndMatches(() -> IdUtils.validateId((String)THINGO, (String)"what\u000bis line tabulation"));
    }

    @Test
    public void testInvalidSpacesRegexFormFeed() {
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [thingToValidate]: Value [form\ffeed?] contains illegal whitespace characters.  Only space is allowed.").assertThrowsAndMatches(() -> IdUtils.validateId((String)THINGO, (String)"form\ffeed?"));
    }

    @Test
    public void testInvalidUnprintableChars() {
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [thingToValidate]: Value [form\u0081feed?] contains illegal UTF8 character [#129] at position [4]").assertThrowsAndMatches(() -> IdUtils.validateId((String)THINGO, (String)"form\u0081feed?"));
    }

    @Test
    public void testInvalidEmojis() {
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [thingToValidate]: Value [form\ud83d\udcaffeed?] contains illegal UTF8 character [#55357] at position [4]").assertThrowsAndMatches(() -> IdUtils.validateId((String)THINGO, (String)"form\ud83d\udcaffeed?"));
    }

    @Test
    public void testNewTaskIdWithoutInterval() {
        String id = IdUtils.newTaskId((String)"prefix", (String)"suffix", (DateTime)DateTimes.of((String)"2020-01-01"), (String)"type", (String)"datasource", null);
        String expected = String.join((CharSequence)"_", "prefix", "type", "datasource", "suffix", DateTimes.of((String)"2020-01-01").toString());
        Assert.assertEquals((Object)expected, (Object)id);
    }

    @Test
    public void testNewTaskIdWithInterval() {
        String id = IdUtils.newTaskId((String)"prefix", (String)"suffix", (DateTime)DateTimes.of((String)"2020-01-01"), (String)"type", (String)"datasource", (Interval)Intervals.of((String)"2020-01-01/2020-06-01"));
        String expected = String.join((CharSequence)"_", "prefix", "type", "datasource", "suffix", DateTimes.of((String)"2020-01-01").toString(), DateTimes.of((String)"2020-06-01").toString(), DateTimes.of((String)"2020-01-01").toString());
        Assert.assertEquals((Object)expected, (Object)id);
    }
}

