/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class AggregateProjectionSpecTest
extends InitializedNullHandlingTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws JsonProcessingException {
        AggregateProjectionSpec spec = new AggregateProjectionSpec("some_projection", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"time")}), Arrays.asList(new StringDimensionSchema("a"), new LongDimensionSchema("b"), new LongDimensionSchema("time"), new FloatDimensionSchema("c"), new DoubleDimensionSchema("d")), new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("e", "e")});
        Assert.assertEquals((Object)spec, (Object)JSON_MAPPER.readValue(JSON_MAPPER.writeValueAsString((Object)spec), AggregateProjectionSpec.class));
    }

    @Test
    public void testInvalidGrouping() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> new AggregateProjectionSpec("other_projection", null, null, null));
        Assert.assertEquals((Object)"groupingColumns and aggregators must not both be null or empty", (Object)t.getMessage());
        t = Assert.assertThrows(DruidException.class, () -> new AggregateProjectionSpec("other_projection", null, Collections.emptyList(), null));
        Assert.assertEquals((Object)"groupingColumns and aggregators must not both be null or empty", (Object)t.getMessage());
    }

    @Test
    public void testEqualsAndHashcode() {
        EqualsVerifier.forClass(AggregateProjectionSpec.class).usingGetClass().withPrefabValues(DimensionSchema.class, (Object)new StringDimensionSchema("a"), (Object)new DoubleDimensionSchema("d")).withIgnoredFields(new String[]{"timeColumnName"}).verify();
    }
}

