/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.JSONPathFieldSpec;
import org.apache.druid.java.util.common.parsers.JSONPathFieldType;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JsonReaderTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testParseMultipleRows() throws IOException {
        JsonInputFormat format = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz", "baz"), (Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz2", "baz2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg", "$.o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg2", "$.o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg", ".o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg2", ".o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_baz", null, Collections.singletonList("baz")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_baz2", null, Collections.singletonList("baz2")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg", null, Arrays.asList("o", "mg")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg2", null, Arrays.asList("o", "mg2")))), null, null, false, Boolean.valueOf(false), Boolean.valueOf(false));
        ByteEntity source = new ByteEntity(StringUtils.toUtf8((String)"{\"timestamp\":\"2019-01-01\",\"bar\":null,\"foo\":\"x\",\"baz\":4,\"o\":{\"mg\":1}}{\"timestamp\":\"2019-01-01\",\"bar\":null,\"foo\":\"x\",\"baz\":4,\"o\":{\"mg\":2}}\n{\"timestamp\":\"2019-01-01\",\"bar\":null,\"foo\":\"x\",\"baz\":4,\"o\":{\"mg\":3}}\n"));
        InputEntityReader reader = format.createReader(new InputRowSchema(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"bar", (Object)"foo"))), ColumnsFilter.all()), (InputEntity)source, null);
        int numExpectedIterations = 3;
        try (CloseableIterator iterator = reader.read();){
            int numActualIterations = 0;
            while (iterator.hasNext()) {
                InputRow row = (InputRow)iterator.next();
                String msgId = String.valueOf(++numActualIterations);
                Assert.assertEquals((Object)DateTimes.of((String)"2019-01-01"), (Object)row.getTimestamp());
                Assert.assertEquals((Object)"x", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("foo")));
                Assert.assertEquals((Object)"4", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("baz")));
                Assert.assertEquals((Object)"4", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("root_baz")));
                Assert.assertEquals((Object)"4", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("tree_baz")));
                Assert.assertEquals((Object)msgId, (Object)Iterables.getOnlyElement((Iterable)row.getDimension("path_omg")));
                Assert.assertEquals((Object)msgId, (Object)Iterables.getOnlyElement((Iterable)row.getDimension("jq_omg")));
                Assert.assertEquals((Object)msgId, (Object)Iterables.getOnlyElement((Iterable)row.getDimension("tree_omg")));
                Assert.assertTrue((boolean)row.getDimension("root_baz2").isEmpty());
                Assert.assertTrue((boolean)row.getDimension("tree_baz2").isEmpty());
                Assert.assertTrue((boolean)row.getDimension("path_omg2").isEmpty());
                Assert.assertTrue((boolean)row.getDimension("jq_omg2").isEmpty());
                Assert.assertTrue((boolean)row.getDimension("tree_omg2").isEmpty());
            }
            Assert.assertEquals((long)3L, (long)numActualIterations);
        }
    }

    @Test
    public void testParsePrettyFormatJSON() throws IOException {
        JsonInputFormat format = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz", "baz"), (Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz2", "baz2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg", "$.o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg2", "$.o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg", ".o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg2", ".o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_baz", null, Collections.singletonList("baz")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_baz2", null, Collections.singletonList("baz2")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg", null, Arrays.asList("o", "mg")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg2", null, Arrays.asList("o", "mg2")))), null, null, false, Boolean.valueOf(false), Boolean.valueOf(false));
        ByteEntity source = new ByteEntity(StringUtils.toUtf8((String)"{\n    \"timestamp\": \"2019-01-01\",\n    \"bar\": null,\n    \"foo\": \"x\",\n    \"baz\": 4,\n    \"o\": {\n        \"mg\": 1\n    }\n}"));
        InputEntityReader reader = format.createReader(new InputRowSchema(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"bar", (Object)"foo"))), ColumnsFilter.all()), (InputEntity)source, null);
        boolean numExpectedIterations = true;
        try (CloseableIterator iterator = reader.read();){
            int numActualIterations = 0;
            while (iterator.hasNext()) {
                InputRow row = (InputRow)iterator.next();
                Assert.assertEquals((Object)DateTimes.of((String)"2019-01-01"), (Object)row.getTimestamp());
                Assert.assertEquals((Object)"x", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("foo")));
                Assert.assertEquals((Object)"4", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("baz")));
                Assert.assertEquals((Object)"4", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("root_baz")));
                Assert.assertEquals((Object)"4", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("tree_baz")));
                Assert.assertEquals((Object)"1", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("path_omg")));
                Assert.assertEquals((Object)"1", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("jq_omg")));
                Assert.assertEquals((Object)"1", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("tree_omg")));
                Assert.assertTrue((boolean)row.getDimension("root_baz2").isEmpty());
                Assert.assertTrue((boolean)row.getDimension("tree_baz2").isEmpty());
                Assert.assertTrue((boolean)row.getDimension("path_omg2").isEmpty());
                Assert.assertTrue((boolean)row.getDimension("jq_omg2").isEmpty());
                Assert.assertTrue((boolean)row.getDimension("tree_omg2").isEmpty());
                ++numActualIterations;
            }
            Assert.assertEquals((long)1L, (long)numActualIterations);
        }
    }

    @Test
    public void testInvalidJSONText() throws IOException {
        JsonInputFormat format = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz", "baz"), (Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz2", "baz2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg", "$.o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg2", "$.o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg", ".o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg2", ".o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_baz", null, Collections.singletonList("baz")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_baz2", null, Collections.singletonList("baz2")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg", null, Arrays.asList("o", "mg")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg2", null, Arrays.asList("o", "mg2")))), null, null, false, Boolean.valueOf(false), Boolean.valueOf(false));
        ByteEntity source = new ByteEntity(StringUtils.toUtf8((String)"{\"timestamp\":\"2019-01-01\",\"bar\":null,\"foo\":\"x\",\"baz\":4,\"o\":{\"mg\":1}}{\"timestamp\":\"2019-01-01\",\"bar\":null,\"foo\":\"x\",\"baz\":4xxx,\"o\":{\"mg\":2}}{\"timestamp\":\"2019-01-01\",\"bar\":null,\"foo\":\"x\",\"baz\":4,\"o\":{\"mg\":3}}"));
        InputEntityReader reader = format.createReader(new InputRowSchema(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"bar", (Object)"foo"))), ColumnsFilter.all()), (InputEntity)source, null);
        this.expectedException.expect(ParseException.class);
        boolean numExpectedIterations = false;
        try (CloseableIterator iterator = reader.read();){
            int numActualIterations = 0;
            while (iterator.hasNext()) {
                iterator.next();
                ++numActualIterations;
            }
            Assert.assertEquals((long)0L, (long)numActualIterations);
        }
    }

    @Test
    public void testSampleMultipleRows() throws IOException {
        JsonInputFormat format = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz", "baz"), (Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz2", "baz2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg", "$.o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg2", "$.o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg", ".o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg2", ".o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_baz", null, Collections.singletonList("baz")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_baz2", null, Collections.singletonList("baz2")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg", null, Arrays.asList("o", "mg")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg2", null, Arrays.asList("o", "mg2")))), null, null, false, Boolean.valueOf(false), Boolean.valueOf(false));
        ByteEntity source = new ByteEntity(StringUtils.toUtf8((String)"{\"timestamp\":\"2019-01-01\",\"bar\":null,\"foo\":\"x\",\"baz\":4,\"o\":{\"mg\":1}}{\"timestamp\":\"2019-01-01\",\"bar\":null,\"foo\":\"x\",\"baz\":4,\"o\":{\"mg\":2}}\n{\"timestamp\":\"2019-01-01\",\"bar\":null,\"foo\":\"x\",\"baz\":4,\"o\":{\"mg\":3}}\n"));
        InputEntityReader reader = format.createReader(new InputRowSchema(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"bar", (Object)"foo"))), ColumnsFilter.all()), (InputEntity)source, null);
        int acturalRowCount = 0;
        try (CloseableIterator iterator = reader.sample();){
            while (iterator.hasNext()) {
                InputRowListPlusRawValues rawValues = (InputRowListPlusRawValues)iterator.next();
                Assert.assertEquals((long)3L, (long)rawValues.getInputRows().size());
                for (int i = 0; i < 3; ++i) {
                    InputRow row = (InputRow)rawValues.getInputRows().get(i);
                    String msgId = String.valueOf(++acturalRowCount);
                    Assert.assertEquals((Object)DateTimes.of((String)"2019-01-01"), (Object)row.getTimestamp());
                    Assert.assertEquals((Object)"x", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("foo")));
                    Assert.assertEquals((Object)"4", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("baz")));
                    Assert.assertEquals((Object)"4", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("root_baz")));
                    Assert.assertEquals((Object)"4", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("tree_baz")));
                    Assert.assertEquals((Object)msgId, (Object)Iterables.getOnlyElement((Iterable)row.getDimension("path_omg")));
                    Assert.assertEquals((Object)msgId, (Object)Iterables.getOnlyElement((Iterable)row.getDimension("jq_omg")));
                    Assert.assertEquals((Object)msgId, (Object)Iterables.getOnlyElement((Iterable)row.getDimension("tree_omg")));
                    Assert.assertTrue((boolean)row.getDimension("root_baz2").isEmpty());
                    Assert.assertTrue((boolean)row.getDimension("tree_baz2").isEmpty());
                    Assert.assertTrue((boolean)row.getDimension("path_omg2").isEmpty());
                    Assert.assertTrue((boolean)row.getDimension("jq_omg2").isEmpty());
                    Assert.assertTrue((boolean)row.getDimension("tree_omg2").isEmpty());
                }
            }
        }
        Assert.assertEquals((long)3L, (long)acturalRowCount);
    }

    @Test
    public void testSamplInvalidJSONText() throws IOException {
        JsonInputFormat format = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz", "baz"), (Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz2", "baz2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg", "$.o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg2", "$.o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg", ".o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg2", ".o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_baz", null, Collections.singletonList("baz")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_baz2", null, Collections.singletonList("baz2")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg", null, Arrays.asList("o", "mg")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg2", null, Arrays.asList("o", "mg2")))), null, null, false, Boolean.valueOf(false), Boolean.valueOf(false));
        ByteEntity source = new ByteEntity(StringUtils.toUtf8((String)"{\"timestamp\":\"2019-01-01\",\"bar\":null,\"foo\":\"x\",\"baz\":4,\"o\":{\"mg\":1}}{\"timestamp\":\"2019-01-01\",\"bar\":null,\"foo\":\"x\",\"baz\":4xxx,\"o\":{\"mg\":2}}\n{\"timestamp\":\"2019-01-01\",\"bar\":null,\"foo\":\"x\",\"baz\":4,\"o\":{\"mg\":3}}\n"));
        InputEntityReader reader = format.createReader(new InputRowSchema(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"bar", (Object)"foo"))), ColumnsFilter.all()), (InputEntity)source, null);
        boolean numExpectedIterations = true;
        try (CloseableIterator iterator = reader.sample();){
            int numActualIterations = 0;
            while (iterator.hasNext()) {
                ++numActualIterations;
                InputRowListPlusRawValues rawValues = (InputRowListPlusRawValues)iterator.next();
                Assert.assertNotNull((Object)rawValues.getParseException());
            }
            Assert.assertEquals((long)1L, (long)numActualIterations);
        }
    }

    @Test
    public void testEmptyJSONText() throws IOException {
        JsonInputFormat format = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz", "baz"), (Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz2", "baz2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg", "$.o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg2", "$.o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg", ".o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg2", ".o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_baz", null, Collections.singletonList("baz")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_baz2", null, Collections.singletonList("baz2")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg", null, Arrays.asList("o", "mg")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg2", null, Arrays.asList("o", "mg2")))), null, null, false, Boolean.valueOf(false), Boolean.valueOf(false));
        ByteEntity source = new ByteEntity(StringUtils.toUtf8((String)""));
        InputEntityReader reader = format.createReader(new InputRowSchema(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"bar", (Object)"foo"))), ColumnsFilter.all()), (InputEntity)source, null);
        this.expectedException.expect(ParseException.class);
        boolean numExpectedIterations = false;
        try (CloseableIterator iterator = reader.read();){
            int numActualIterations = 0;
            while (iterator.hasNext()) {
                iterator.next();
                ++numActualIterations;
            }
            Assert.assertEquals((long)0L, (long)numActualIterations);
        }
    }

    @Test
    public void testSampleEmptyText() throws IOException {
        JsonInputFormat format = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz", "baz"), (Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz2", "baz2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg", "$.o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg2", "$.o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg", ".o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg2", ".o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_baz", null, Collections.singletonList("baz")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_baz2", null, Collections.singletonList("baz2")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg", null, Arrays.asList("o", "mg")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg2", null, Arrays.asList("o", "mg2")))), null, null, false, Boolean.valueOf(false), Boolean.valueOf(false));
        ByteEntity source = new ByteEntity(StringUtils.toUtf8((String)""));
        InputEntityReader reader = format.createReader(new InputRowSchema(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"bar", (Object)"foo"))), ColumnsFilter.all()), (InputEntity)source, null);
        boolean numExpectedIterations = true;
        try (CloseableIterator iterator = reader.sample();){
            int numActualIterations = 0;
            while (iterator.hasNext()) {
                ++numActualIterations;
                InputRowListPlusRawValues rawValues = (InputRowListPlusRawValues)iterator.next();
                Assert.assertNotNull((Object)rawValues.getParseException());
            }
            Assert.assertEquals((long)1L, (long)numActualIterations);
        }
    }
}

