/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.guice.DruidSecondaryModule;
import org.apache.druid.guice.GuiceAnnotationIntrospector;
import org.junit.Assert;
import org.junit.Test;

public class StringDimensionSchemaTest {
    private final ObjectMapper jsonMapper = new ObjectMapper();

    public StringDimensionSchemaTest() {
        GuiceAnnotationIntrospector introspector = new GuiceAnnotationIntrospector();
        DruidSecondaryModule.setupAnnotationIntrospector((ObjectMapper)this.jsonMapper, (AnnotationIntrospector)introspector);
        this.jsonMapper.registerSubtypes(new Class[]{StringDimensionSchema.class});
    }

    @Test
    public void testDeserializeFromSimpleString() throws JsonProcessingException {
        String json = "\"dim\"";
        StringDimensionSchema schema = (StringDimensionSchema)this.jsonMapper.readValue("\"dim\"", DimensionSchema.class);
        Assert.assertEquals((Object)new StringDimensionSchema("dim"), (Object)schema);
    }

    @Test
    public void testDeserializeFromJson() throws JsonProcessingException {
        String json = "{\n  \"type\" : \"StringDimensionSchema\",\n  \"name\" : \"dim\",\n  \"multiValueHandling\" : \"SORTED_SET\",\n  \"createBitmapIndex\" : false\n}";
        StringDimensionSchema schema = (StringDimensionSchema)this.jsonMapper.readValue("{\n  \"type\" : \"StringDimensionSchema\",\n  \"name\" : \"dim\",\n  \"multiValueHandling\" : \"SORTED_SET\",\n  \"createBitmapIndex\" : false\n}", DimensionSchema.class);
        Assert.assertEquals((Object)new StringDimensionSchema("dim", DimensionSchema.MultiValueHandling.SORTED_SET, Boolean.valueOf(false)), (Object)schema);
    }
}

