/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.field.ConstantFieldPointer;
import org.apache.druid.frame.field.DoubleArrayFieldReader;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.frame.field.IndexArrayFieldPointer;
import org.apache.druid.frame.field.NumericArrayFieldWriter;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;

public class DoubleArrayFieldReaderTest
extends InitializedNullHandlingTest {
    private static final long MEMORY_POSITION = 1L;
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    public ColumnValueSelector writeSelector;
    private WritableMemory memory;
    private FieldWriter fieldWriter;
    private static final Object[] DOUBLES_ARRAY_1 = new Object[]{Double.MAX_VALUE, Double.MIN_VALUE, null, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.MIN_NORMAL, null, 0.0, 1.234234, Double.NaN, -1.344234, 129123.123123, -2.131221333E7, null, 1111.0, 23.0, null};
    private static final Object[] DOUBLES_ARRAY_2 = new Object[]{null, Double.MAX_VALUE, 12.234234, -21.344234, Double.POSITIVE_INFINITY, null, Double.MIN_VALUE, 129123.123123, null, 0.0, Double.MIN_NORMAL, 1111.0, Double.NaN, Double.NEGATIVE_INFINITY, null, -2133.33, 23.0, null};
    private static final List<Double> DOUBLES_LIST_1 = Arrays.stream(DOUBLES_ARRAY_1).map(val -> (Double)val).collect(Collectors.toList());
    private static final List<Double> DOUBLES_LIST_2 = Arrays.stream(DOUBLES_ARRAY_2).map(val -> (Double)val).collect(Collectors.toList());

    @Before
    public void setUp() {
        this.memory = WritableMemory.allocate((int)1000);
        this.fieldWriter = NumericArrayFieldWriter.getDoubleArrayFieldWriter((ColumnValueSelector)this.writeSelector);
    }

    @After
    public void tearDown() {
        this.fieldWriter.close();
    }

    @Test
    public void test_isNull_null() {
        this.writeToMemory(null, 1L);
        Assert.assertTrue((boolean)new DoubleArrayFieldReader().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_aValue() {
        this.writeToMemory(DOUBLES_ARRAY_1, 1L);
        Assert.assertFalse((boolean)new DoubleArrayFieldReader().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_emptyArray() {
        this.writeToMemory(new Object[0], 1L);
        Assert.assertFalse((boolean)new DoubleArrayFieldReader().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_arrayWithSingleNullElement() {
        this.writeToMemory(new Object[]{null}, 1L);
        Assert.assertFalse((boolean)new DoubleArrayFieldReader().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_makeColumnValueSelector_null() {
        long sz = this.writeToMemory(null, 1L);
        ColumnValueSelector readSelector = new DoubleArrayFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, sz));
        Assert.assertTrue((boolean)readSelector.isNull());
    }

    @Test
    public void test_makeColumnValueSelector_aValue() {
        long sz = this.writeToMemory(DOUBLES_ARRAY_1, 1L);
        ColumnValueSelector readSelector = new DoubleArrayFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, sz));
        this.assertResults(DOUBLES_LIST_1, readSelector.getObject());
    }

    @Test
    public void test_makeColumnValueSelector_multipleValues() {
        long sz = this.writeToMemory(DOUBLES_ARRAY_1, 1L);
        long sz2 = this.writeToMemory(DOUBLES_ARRAY_2, 1L + sz);
        IndexArrayFieldPointer pointer = new IndexArrayFieldPointer((List<Long>)ImmutableList.of((Object)1L, (Object)(1L + sz)), (List<Long>)ImmutableList.of((Object)sz, (Object)sz2));
        ColumnValueSelector readSelector = new DoubleArrayFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)pointer);
        pointer.setPointer(0);
        this.assertResults(DOUBLES_LIST_1, readSelector.getObject());
        pointer.setPointer(1);
        this.assertResults(DOUBLES_LIST_2, readSelector.getObject());
    }

    @Test
    public void test_makeColumnValueSelector_emptyArray() {
        long sz = this.writeToMemory(new Object[0], 1L);
        ColumnValueSelector readSelector = new DoubleArrayFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, sz));
        this.assertResults(Collections.emptyList(), readSelector.getObject());
    }

    @Test
    public void test_makeColumnValueSelector_arrayWithSingleNullElement() {
        long sz = this.writeToMemory(new Object[]{null}, 1L);
        ColumnValueSelector readSelector = new DoubleArrayFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, sz));
        this.assertResults(Collections.singletonList(null), readSelector.getObject());
    }

    private long writeToMemory(Object value, long initialPosition) {
        Mockito.when((Object)this.writeSelector.getObject()).thenReturn(value);
        long bytesWritten = this.fieldWriter.writeTo(this.memory, initialPosition, this.memory.getCapacity() - initialPosition);
        if (bytesWritten < 0L) {
            throw new ISE("Could not write", new Object[0]);
        }
        return bytesWritten;
    }

    private void assertResults(List<Double> expected, Object actual) {
        if (expected == null) {
            Assert.assertNull((Object)actual);
        }
        Assert.assertTrue((boolean)(actual instanceof Object[]));
        ArrayList<Double> actualList = new ArrayList<Double>();
        for (Object val : (Object[])actual) {
            actualList.add((Double)val);
        }
        Assert.assertEquals(expected, actualList);
    }
}

