/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import java.util.List;
import java.util.Objects;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.field.ConstantFieldPointer;
import org.apache.druid.frame.field.DoubleFieldReader;
import org.apache.druid.frame.field.DoubleFieldWriter;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.frame.write.FrameWriterTestData;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.StringPredicateDruidPredicateFactory;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.concrete.RowBasedFrameRowsAndColumnsTest;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;

public class DoubleFieldReaderTest
extends InitializedNullHandlingTest {
    private static final long MEMORY_POSITION = 1L;
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    public BaseDoubleColumnValueSelector writeSelector;
    private WritableMemory memory;
    private FieldWriter fieldWriter;

    @Before
    public void setUp() {
        this.memory = WritableMemory.allocate((int)1000);
        this.fieldWriter = DoubleFieldWriter.forPrimitive((BaseDoubleColumnValueSelector)this.writeSelector);
    }

    @After
    public void tearDown() {
        this.fieldWriter.close();
    }

    @Test
    public void test_isNull_defaultOrNull() {
        this.writeToMemory(null);
        Assert.assertTrue((boolean)DoubleFieldReader.forPrimitive().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_aValue() {
        this.writeToMemory(5.1);
        Assert.assertFalse((boolean)DoubleFieldReader.forPrimitive().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_makeColumnValueSelector_defaultOrNull() {
        this.writeToMemory(null);
        ColumnValueSelector readSelector = DoubleFieldReader.forPrimitive().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L));
        Assert.assertTrue((boolean)readSelector.isNull());
    }

    @Test
    public void test_makeColumnValueSelector_aValue() {
        this.writeToMemory(5.1);
        ColumnValueSelector readSelector = DoubleFieldReader.forPrimitive().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L));
        Assert.assertEquals((Object)5.1, (Object)readSelector.getObject());
    }

    @Test
    public void test_makeDimensionSelector_defaultOrNull() {
        this.writeToMemory(null);
        DimensionSelector readSelector = DoubleFieldReader.forPrimitive().makeDimensionSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L), null);
        IndexedInts row = readSelector.getRow();
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertNull((Object)readSelector.lookupName(0));
        Assert.assertFalse((boolean)readSelector.supportsLookupNameUtf8());
        Assert.assertFalse((boolean)readSelector.nameLookupPossibleInAdvance());
        Assert.assertEquals((long)-1L, (long)readSelector.getValueCardinality());
        Assert.assertEquals(String.class, (Object)readSelector.classOfObject());
        Assert.assertNull((Object)readSelector.idLookup());
        Assert.assertFalse((boolean)readSelector.makeValueMatcher("0.0").matches(false));
        Assert.assertTrue((boolean)readSelector.makeValueMatcher((String)null).matches(false));
        Assert.assertFalse((boolean)readSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"0.0")).matches(false));
        Assert.assertTrue((boolean)readSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.of((DruidObjectPredicate)DruidObjectPredicate.isNull())).matches(false));
    }

    @Test
    public void testCompareRows() {
        List<Double> rows = FrameWriterTestData.TEST_DOUBLES.getData(KeyOrder.ASCENDING);
        ColumnAccessor accessor = RowBasedFrameRowsAndColumnsTest.MAKER.apply(MapOfColumnsRowsAndColumns.builder().add("dim1", rows.toArray(), ColumnType.DOUBLE).build()).findColumn("dim1").toAccessor();
        for (int i = 1; i < rows.size(); ++i) {
            if (Objects.equals(accessor.getObject(i - 1), accessor.getObject(i))) {
                Assert.assertEquals((long)0L, (long)accessor.compareRows(i - 1, i));
                continue;
            }
            Assert.assertTrue((accessor.compareRows(i - 1, i) < 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void test_makeDimensionSelector_aValue() {
        this.writeToMemory(5.1);
        DimensionSelector readSelector = DoubleFieldReader.forPrimitive().makeDimensionSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L), null);
        IndexedInts row = readSelector.getRow();
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((Object)"5.1", (Object)readSelector.lookupName(0));
        Assert.assertFalse((boolean)readSelector.supportsLookupNameUtf8());
        Assert.assertFalse((boolean)readSelector.nameLookupPossibleInAdvance());
        Assert.assertEquals((long)-1L, (long)readSelector.getValueCardinality());
        Assert.assertEquals(String.class, (Object)readSelector.classOfObject());
        Assert.assertNull((Object)readSelector.idLookup());
        Assert.assertTrue((boolean)readSelector.makeValueMatcher("5.1").matches(false));
        Assert.assertFalse((boolean)readSelector.makeValueMatcher("5").matches(false));
        Assert.assertTrue((boolean)readSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"5.1")).matches(false));
        Assert.assertFalse((boolean)readSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"5")).matches(false));
    }

    @Test
    public void test_makeDimensionSelector_aValue_extractionFn() {
        this.writeToMemory(20.5);
        DimensionSelector readSelector = DoubleFieldReader.forPrimitive().makeDimensionSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L), (ExtractionFn)new SubstringDimExtractionFn(1, null));
        IndexedInts row = readSelector.getRow();
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((Object)"0.5", (Object)readSelector.lookupName(0));
        Assert.assertFalse((boolean)readSelector.supportsLookupNameUtf8());
        Assert.assertFalse((boolean)readSelector.nameLookupPossibleInAdvance());
        Assert.assertEquals((long)-1L, (long)readSelector.getValueCardinality());
        Assert.assertEquals(String.class, (Object)readSelector.classOfObject());
        Assert.assertNull((Object)readSelector.idLookup());
        Assert.assertTrue((boolean)readSelector.makeValueMatcher("0.5").matches(false));
        Assert.assertFalse((boolean)readSelector.makeValueMatcher("2").matches(false));
        Assert.assertTrue((boolean)readSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"0.5")).matches(false));
        Assert.assertFalse((boolean)readSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"2")).matches(false));
    }

    private void writeToMemory(Double value) {
        Mockito.when((Object)this.writeSelector.isNull()).thenReturn((Object)(value == null ? 1 : 0));
        if (value != null) {
            Mockito.when((Object)this.writeSelector.getDouble()).thenReturn((Object)value);
        }
        if (this.fieldWriter.writeTo(this.memory, 1L, this.memory.getCapacity() - 1L) < 0L) {
            throw new ISE("Could not write", new Object[0]);
        }
    }
}

