/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.field.ConstantFieldPointer;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.frame.field.IndexArrayFieldPointer;
import org.apache.druid.frame.field.LongArrayFieldReader;
import org.apache.druid.frame.field.NumericArrayFieldWriter;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;

public class LongArrayFieldReaderTest
extends InitializedNullHandlingTest {
    private static final long MEMORY_POSITION = 1L;
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    public ColumnValueSelector writeSelector;
    private WritableMemory memory;
    private FieldWriter fieldWriter;
    private static final Object[] LONGS_ARRAY_1 = new Object[]{Long.MIN_VALUE, Long.MAX_VALUE, null, 0L, 123L, -123L};
    private static final Object[] LONGS_ARRAY_2 = new Object[]{null, 234L, Long.MAX_VALUE, null, Long.MIN_VALUE, 0L, -234L, null};
    private static final List<Long> LONGS_LIST_1 = Arrays.stream(LONGS_ARRAY_1).map(val -> (Long)val).collect(Collectors.toList());
    private static final List<Long> LONGS_LIST_2 = Arrays.stream(LONGS_ARRAY_2).map(val -> (Long)val).collect(Collectors.toList());

    @Before
    public void setUp() {
        this.memory = WritableMemory.allocate((int)1000);
        this.fieldWriter = NumericArrayFieldWriter.getLongArrayFieldWriter((ColumnValueSelector)this.writeSelector);
    }

    @After
    public void tearDown() {
        this.fieldWriter.close();
    }

    @Test
    public void test_isNull_null() {
        this.writeToMemory(null, 1L);
        Assert.assertTrue((boolean)new LongArrayFieldReader().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_aValue() {
        this.writeToMemory(LONGS_ARRAY_1, 1L);
        Assert.assertFalse((boolean)new LongArrayFieldReader().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_emptyArray() {
        this.writeToMemory(new Object[0], 1L);
        Assert.assertFalse((boolean)new LongArrayFieldReader().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_arrayWithSingleNullElement() {
        this.writeToMemory(new Object[]{null}, 1L);
        Assert.assertFalse((boolean)new LongArrayFieldReader().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_makeColumnValueSelector_null() {
        long sz = this.writeToMemory(null, 1L);
        ColumnValueSelector readSelector = new LongArrayFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, sz));
        Assert.assertTrue((boolean)readSelector.isNull());
    }

    @Test
    public void test_makeColumnValueSelector_aValue() {
        long sz = this.writeToMemory(LONGS_ARRAY_1, 1L);
        ColumnValueSelector readSelector = new LongArrayFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, sz));
        this.assertResults(LONGS_LIST_1, readSelector.getObject());
    }

    @Test
    public void test_makeColumnValueSelector_multipleValues() {
        long sz = this.writeToMemory(LONGS_ARRAY_1, 1L);
        long sz2 = this.writeToMemory(LONGS_ARRAY_2, 1L + sz);
        IndexArrayFieldPointer pointer = new IndexArrayFieldPointer((List<Long>)ImmutableList.of((Object)1L, (Object)(1L + sz)), (List<Long>)ImmutableList.of((Object)sz, (Object)sz2));
        ColumnValueSelector readSelector = new LongArrayFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)pointer);
        pointer.setPointer(0);
        this.assertResults(LONGS_LIST_1, readSelector.getObject());
        pointer.setPointer(1);
        this.assertResults(LONGS_LIST_2, readSelector.getObject());
    }

    @Test
    public void test_makeColumnValueSelector_emptyArray() {
        long sz = this.writeToMemory(new Object[0], 1L);
        ColumnValueSelector readSelector = new LongArrayFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, sz));
        this.assertResults(Collections.emptyList(), readSelector.getObject());
    }

    @Test
    public void test_makeColumnValueSelector_arrayWithSingleNullElement() {
        long sz = this.writeToMemory(new Object[]{null}, 1L);
        ColumnValueSelector readSelector = new LongArrayFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, sz));
        this.assertResults(Collections.singletonList(null), readSelector.getObject());
    }

    private long writeToMemory(Object value, long initialPosition) {
        Mockito.when((Object)this.writeSelector.getObject()).thenReturn(value);
        long bytesWritten = this.fieldWriter.writeTo(this.memory, initialPosition, this.memory.getCapacity() - initialPosition);
        if (bytesWritten < 0L) {
            throw new ISE("Could not write", new Object[0]);
        }
        return bytesWritten;
    }

    private void assertResults(List<Long> expected, Object actual) {
        if (expected == null) {
            Assert.assertNull((Object)actual);
        }
        Assert.assertTrue((boolean)(actual instanceof Object[]));
        ArrayList<Long> actualList = new ArrayList<Long>();
        for (Object val : (Object[])actual) {
            actualList.add((Long)val);
        }
        Assert.assertEquals(expected, actualList);
    }
}

