/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.frame.key.RowKeyComparisonRunLengths;
import org.apache.druid.frame.key.RunLengthEntry;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Test;

public class RowKeyComparisonRunLengthsTest {
    @Test
    public void testRunLengthsWithNoKeyColumns() {
        List keyColumns = Collections.emptyList();
        RowSignature signature = RowSignature.empty();
        RowKeyComparisonRunLengths runLengths = RowKeyComparisonRunLengths.create(keyColumns, (RowSignature)signature);
        Assert.assertEquals((long)0L, (long)runLengths.getRunLengthEntries().length);
    }

    @Test
    public void testRunLengthsWithInvalidOrder() {
        List<KeyColumn> keyColumns = Collections.singletonList(new KeyColumn("a", KeyOrder.NONE));
        RowSignature signature = RowSignature.builder().add("a", ColumnType.LONG).build();
        Assert.assertThrows(DruidException.class, () -> RowKeyComparisonRunLengths.create((List)keyColumns, (RowSignature)signature));
    }

    @Test
    public void testRunLengthsWithIncompleteRowSignature() {
        List<KeyColumn> keyColumns = Collections.singletonList(new KeyColumn("a", KeyOrder.NONE));
        RowSignature signature = RowSignature.empty();
        Assert.assertThrows(DruidException.class, () -> RowKeyComparisonRunLengths.create((List)keyColumns, (RowSignature)signature));
    }

    @Test
    public void testRunLengthsWithEmptyType() {
        List<KeyColumn> keyColumns = Collections.singletonList(new KeyColumn("a", KeyOrder.NONE));
        RowSignature signature1 = RowSignature.builder().add("a", null).build();
        Assert.assertThrows(DruidException.class, () -> RowKeyComparisonRunLengths.create((List)keyColumns, (RowSignature)signature1));
        RowSignature signature2 = RowSignature.builder().add("a", ColumnType.UNKNOWN_COMPLEX).build();
        Assert.assertThrows(DruidException.class, () -> RowKeyComparisonRunLengths.create((List)keyColumns, (RowSignature)signature2));
    }

    @Test
    public void testRunLengthsWithByteComparableTypes() {
        List<KeyColumn> keyColumns = Collections.singletonList(new KeyColumn("a", KeyOrder.ASCENDING));
        ImmutableList byteComparableTypes = ImmutableList.of((Object)ColumnType.LONG, (Object)ColumnType.FLOAT, (Object)ColumnType.DOUBLE, (Object)ColumnType.STRING, (Object)ColumnType.LONG_ARRAY, (Object)ColumnType.FLOAT_ARRAY, (Object)ColumnType.DOUBLE_ARRAY, (Object)ColumnType.STRING_ARRAY);
        for (ColumnType columnType : byteComparableTypes) {
            RowSignature signature = RowSignature.builder().add("a", columnType).build();
            RowKeyComparisonRunLengths runLengths = RowKeyComparisonRunLengths.create(keyColumns, (RowSignature)signature);
            Assert.assertEquals((long)1L, (long)runLengths.getRunLengthEntries().length);
            Assert.assertTrue((boolean)runLengths.getRunLengthEntries()[0].isByteComparable());
            Assert.assertEquals((long)1L, (long)runLengths.getRunLengthEntries()[0].getRunLength());
            Assert.assertEquals((Object)KeyOrder.ASCENDING, (Object)runLengths.getRunLengthEntries()[0].getOrder());
        }
    }

    @Test
    public void testRunLengthsWithNonByteComparableTypes() {
        List<KeyColumn> keyColumns = Collections.singletonList(new KeyColumn("a", KeyOrder.ASCENDING));
        ImmutableList byteComparableTypes = ImmutableList.of((Object)ColumnType.NESTED_DATA);
        for (ColumnType columnType : byteComparableTypes) {
            RowSignature signature = RowSignature.builder().add("a", columnType).build();
            RowKeyComparisonRunLengths runLengths = RowKeyComparisonRunLengths.create(keyColumns, (RowSignature)signature);
            Assert.assertEquals((long)1L, (long)runLengths.getRunLengthEntries().length);
            Assert.assertFalse((boolean)runLengths.getRunLengthEntries()[0].isByteComparable());
            Assert.assertEquals((long)1L, (long)runLengths.getRunLengthEntries()[0].getRunLength());
            Assert.assertEquals((Object)KeyOrder.ASCENDING, (Object)runLengths.getRunLengthEntries()[0].getOrder());
        }
    }

    @Test
    public void testRunLengthsWithMultipleColumns() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("longAsc1", KeyOrder.ASCENDING), (Object)new KeyColumn("stringAsc1", KeyOrder.ASCENDING), (Object)new KeyColumn("stringDesc1", KeyOrder.DESCENDING), (Object)new KeyColumn("longDesc1", KeyOrder.DESCENDING), (Object)new KeyColumn("complexDesc1", KeyOrder.DESCENDING), (Object)new KeyColumn("complexAsc1", KeyOrder.ASCENDING), (Object)new KeyColumn("complexAsc2", KeyOrder.ASCENDING), (Object)new KeyColumn("stringAsc2", KeyOrder.ASCENDING));
        RowSignature signature = RowSignature.builder().add("longAsc1", ColumnType.LONG).add("stringAsc1", ColumnType.STRING).add("stringDesc1", ColumnType.STRING).add("longDesc1", ColumnType.LONG).add("complexDesc1", ColumnType.NESTED_DATA).add("complexAsc1", ColumnType.NESTED_DATA).add("complexAsc2", ColumnType.NESTED_DATA).add("stringAsc2", ColumnType.STRING).build();
        RunLengthEntry[] runLengthEntries = RowKeyComparisonRunLengths.create((List)keyColumns, (RowSignature)signature).getRunLengthEntries();
        Assert.assertEquals((long)6L, (long)runLengthEntries.length);
        Assert.assertTrue((boolean)runLengthEntries[0].isByteComparable());
        Assert.assertEquals((long)2L, (long)runLengthEntries[0].getRunLength());
        Assert.assertEquals((Object)KeyOrder.ASCENDING, (Object)runLengthEntries[0].getOrder());
        Assert.assertTrue((boolean)runLengthEntries[1].isByteComparable());
        Assert.assertEquals((long)2L, (long)runLengthEntries[1].getRunLength());
        Assert.assertEquals((Object)KeyOrder.DESCENDING, (Object)runLengthEntries[1].getOrder());
        Assert.assertFalse((boolean)runLengthEntries[2].isByteComparable());
        Assert.assertEquals((long)1L, (long)runLengthEntries[2].getRunLength());
        Assert.assertEquals((Object)KeyOrder.DESCENDING, (Object)runLengthEntries[2].getOrder());
        Assert.assertFalse((boolean)runLengthEntries[3].isByteComparable());
        Assert.assertEquals((long)1L, (long)runLengthEntries[3].getRunLength());
        Assert.assertEquals((Object)KeyOrder.ASCENDING, (Object)runLengthEntries[3].getOrder());
        Assert.assertFalse((boolean)runLengthEntries[4].isByteComparable());
        Assert.assertEquals((long)1L, (long)runLengthEntries[4].getRunLength());
        Assert.assertEquals((Object)KeyOrder.ASCENDING, (Object)runLengthEntries[4].getOrder());
        Assert.assertTrue((boolean)runLengthEntries[5].isByteComparable());
        Assert.assertEquals((long)1L, (long)runLengthEntries[5].getRunLength());
        Assert.assertEquals((Object)KeyOrder.ASCENDING, (Object)runLengthEntries[5].getOrder());
    }

    @Test
    public void testRunLengthsWithAllPermutationsOfThreeLengthKeyColumns() {
        ImmutableList.Builder expectedResultsBuilder = ImmutableList.builder();
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.ASCENDING, 3)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 2)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 2)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 2)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.DESCENDING, 2), new RunLengthEntry(true, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.ASCENDING, 2), new RunLengthEntry(true, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 2)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.DESCENDING, 3)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 2)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 2)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.ASCENDING, 2), new RunLengthEntry(false, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.DESCENDING, 2), new RunLengthEntry(false, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.ASCENDING, 2), new RunLengthEntry(false, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.DESCENDING, 2), new RunLengthEntry(false, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(true, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.ASCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1)});
        expectedResultsBuilder.add((Object)new RunLengthEntry[]{new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1), new RunLengthEntry(false, KeyOrder.DESCENDING, 1)});
        ImmutableList expectedResults = expectedResultsBuilder.build();
        ImmutableList columnTypeAndKeyOrder = ImmutableList.of((Object)Pair.of((Object)ColumnType.STRING, (Object)KeyOrder.ASCENDING), (Object)Pair.of((Object)ColumnType.STRING, (Object)KeyOrder.DESCENDING), (Object)Pair.of((Object)ColumnType.NESTED_DATA, (Object)KeyOrder.ASCENDING), (Object)Pair.of((Object)ColumnType.NESTED_DATA, (Object)KeyOrder.DESCENDING));
        for (int i = 0; i < 64; ++i) {
            Pair<List<KeyColumn>, RowSignature> keyColumnsAndRowSignature = this.generateKeyColumns((List<Pair<ColumnType, KeyOrder>>)columnTypeAndKeyOrder, i);
            Object[] actualEntries = RowKeyComparisonRunLengths.create((List)((List)keyColumnsAndRowSignature.lhs), (RowSignature)((RowSignature)keyColumnsAndRowSignature.rhs)).getRunLengthEntries();
            Assert.assertArrayEquals((String)StringUtils.format((String)"Result %d incorrect", (Object[])new Object[]{i}), (Object[])((Object[])expectedResults.get(i)), (Object[])actualEntries);
        }
    }

    private Pair<List<KeyColumn>, RowSignature> generateKeyColumns(List<Pair<ColumnType, KeyOrder>> columnTypeAndKeyOrder, int index) {
        ArrayList<KeyColumn> keyColumns = new ArrayList<KeyColumn>();
        RowSignature.Builder builder = RowSignature.builder();
        int firstKeyColumn = index % 4;
        keyColumns.add(new KeyColumn("a", (KeyOrder)columnTypeAndKeyOrder.get((int)firstKeyColumn).rhs));
        builder.add("a", (ColumnType)columnTypeAndKeyOrder.get((int)firstKeyColumn).lhs);
        int secondKeyColumn = (index /= 4) % 4;
        keyColumns.add(new KeyColumn("b", (KeyOrder)columnTypeAndKeyOrder.get((int)secondKeyColumn).rhs));
        builder.add("b", (ColumnType)columnTypeAndKeyOrder.get((int)secondKeyColumn).lhs);
        int thirdKeyColumn = (index /= 4) % 4;
        keyColumns.add(new KeyColumn("c", (KeyOrder)columnTypeAndKeyOrder.get((int)thirdKeyColumn).rhs));
        builder.add("c", (ColumnType)columnTypeAndKeyOrder.get((int)thirdKeyColumn).lhs);
        return Pair.of(keyColumns, (Object)builder.build());
    }
}

