/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Collections;
import java.util.List;
import org.apache.druid.frame.allocation.HeapMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.channel.BlockingQueueFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannels;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class OutputChannelsTest {
    @Test
    public void test_none() {
        OutputChannels channels = OutputChannels.none();
        Assert.assertEquals((Object)IntSets.emptySet(), (Object)channels.getPartitionNumbers());
        Assert.assertEquals(Collections.emptyList(), (Object)channels.getAllChannels());
        Assert.assertEquals(Collections.emptyList(), (Object)channels.getChannelsForPartition(0));
        Assert.assertTrue((boolean)channels.areReadableChannelsReady());
    }

    @Test
    public void test_wrap() {
        OutputChannels channels = OutputChannels.wrap((List)ImmutableList.of((Object)OutputChannel.nil((int)1)));
        Assert.assertEquals((Object)IntSet.of((int)1), (Object)channels.getPartitionNumbers());
        Assert.assertEquals((long)1L, (long)channels.getAllChannels().size());
        Assert.assertEquals(Collections.emptyList(), (Object)channels.getChannelsForPartition(0));
        Assert.assertEquals((long)1L, (long)channels.getChannelsForPartition(1).size());
        Assert.assertTrue((boolean)channels.areReadableChannelsReady());
    }

    @Test
    public void test_readOnly() {
        BlockingQueueFrameChannel channel = BlockingQueueFrameChannel.minimal();
        OutputChannels channels = OutputChannels.wrap((List)ImmutableList.of((Object)OutputChannel.immediatelyReadablePair((WritableFrameChannel)channel.writable(), (MemoryAllocator)HeapMemoryAllocator.unlimited(), (ReadableFrameChannel)channel.readable(), (int)1)));
        OutputChannels readOnlyChannels = channels.readOnly();
        Assert.assertEquals((Object)IntSet.of((int)1), (Object)readOnlyChannels.getPartitionNumbers());
        Assert.assertEquals((long)1L, (long)readOnlyChannels.getAllChannels().size());
        Assert.assertEquals((long)1L, (long)channels.getChannelsForPartition(1).size());
        Assert.assertTrue((boolean)channels.areReadableChannelsReady());
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((OutputChannel)Iterables.getOnlyElement((Iterable)readOnlyChannels.getAllChannels())).getWritableChannel());
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"Writable channel is not available. The output channel might be marked as read-only, hence no writes are allowed.")));
        IllegalStateException e2 = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((OutputChannel)Iterables.getOnlyElement((Iterable)readOnlyChannels.getAllChannels())).getFrameMemoryAllocator());
        MatcherAssert.assertThat((Object)e2, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"Frame allocator is not available. The output channel might be marked as read-only, hence memory allocator is not required.")));
    }
}

