/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import org.apache.druid.guice.ExtensionsConfig;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class ExtensionsConfigTest {
    @Test
    public void testSerdeWithDefaults() throws Exception {
        String json = "{}";
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        ExtensionsConfig config = (ExtensionsConfig)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, ExtensionsConfig.class)), ExtensionsConfig.class);
        Assert.assertTrue((boolean)config.searchCurrentClassloader());
        Assert.assertEquals((Object)"extensions", (Object)config.getDirectory());
        Assert.assertEquals((Object)"hadoop-dependencies", (Object)config.getHadoopDependenciesDir());
        Assert.assertNull((Object)config.getHadoopContainerDruidClasspath());
        Assert.assertNull((Object)config.getLoadList());
    }

    @Test
    public void testSerdeWithNonDefaults() throws Exception {
        String json = "{\n  \"searchCurrentClassloader\": false,\n  \"directory\": \"testExtensions\",\n  \"hadoopDependenciesDir\": \"testHadoopDependenciesDir\",\n  \"hadoopContainerDruidClasspath\": \"testHadoopContainerClasspath\",\n  \"loadList\": [\"b\",\"a\"]\n}";
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        ExtensionsConfig config = (ExtensionsConfig)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, ExtensionsConfig.class)), ExtensionsConfig.class);
        Assert.assertFalse((boolean)config.searchCurrentClassloader());
        Assert.assertEquals((Object)"testExtensions", (Object)config.getDirectory());
        Assert.assertEquals((Object)"testHadoopDependenciesDir", (Object)config.getHadoopDependenciesDir());
        Assert.assertEquals((Object)"testHadoopContainerClasspath", (Object)config.getHadoopContainerDruidClasspath());
        Assert.assertEquals((Object)ImmutableList.of((Object)"b", (Object)"a"), new ArrayList(config.getLoadList()));
    }

    @Test
    public void testLoadList() throws Exception {
        String json = "{\n  \"searchCurrentClassloader\": false,\n  \"directory\": \"testExtensions\",\n  \"hadoopDependenciesDir\": \"testHadoopDependenciesDir\",\n  \"hadoopContainerDruidClasspath\": \"testHadoopContainerClasspath\",\n  \"loadList\": [\"b\",\"b\",\"a\",\"c\",\"d\",\"a\"]\n}";
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        ExtensionsConfig config = (ExtensionsConfig)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, ExtensionsConfig.class)), ExtensionsConfig.class);
        Assert.assertEquals((Object)ImmutableList.of((Object)"b", (Object)"a", (Object)"c", (Object)"d"), new ArrayList(config.getLoadList()));
    }
}

