/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.hll;

import com.google.caliper.Param;
import com.google.caliper.Runner;
import com.google.caliper.SimpleBenchmark;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.druid.hll.ByteBuffers;
import org.apache.druid.hll.HyperLogLogCollector;

public class HyperLogLogCollectorBenchmark
extends SimpleBenchmark {
    private final HashFunction fn = Hashing.murmur3_128();
    private final List<HyperLogLogCollector> collectors = new ArrayList<HyperLogLogCollector>();
    @Param(value={"true"})
    boolean targetIsDirect;
    @Param(value={"default", "random", "0"})
    String alignment;
    boolean alignSource;
    boolean alignTarget;
    int cacheLine = 64;
    ByteBuffer chunk;
    final int count = 100000;
    int[] positions = new int[100000];
    int[] sizes = new int[100000];

    protected void setUp() {
        boolean random = false;
        Random rand = new Random(0L);
        int defaultOffset = 0;
        switch (this.alignment) {
            case "default": {
                this.alignSource = false;
                this.alignTarget = false;
                break;
            }
            case "random": {
                random = true;
                break;
            }
            default: {
                defaultOffset = Integer.parseInt(this.alignment);
            }
        }
        int val = 0;
        this.chunk = ByteBuffers.allocateAlignedByteBuffer((HyperLogLogCollector.getLatestNumBytesForDenseStorage() + this.cacheLine + this.cacheLine) * 100000, this.cacheLine);
        int pos = 0;
        for (int i = 0; i < 100000; ++i) {
            int offset;
            HyperLogLogCollector c = HyperLogLogCollector.makeLatestCollector();
            for (int k = 0; k < 40; ++k) {
                c.add(this.fn.hashInt(++val).asBytes());
            }
            ByteBuffer sparseHeapCopy = c.toByteBuffer();
            int size = sparseHeapCopy.remaining();
            int n = offset = random ? (int)(rand.nextDouble() * 64.0) : defaultOffset;
            if (this.alignSource && pos % this.cacheLine != offset) {
                pos += pos % this.cacheLine < offset ? offset - pos % this.cacheLine : this.cacheLine + offset - pos % this.cacheLine;
            }
            this.positions[i] = pos;
            this.sizes[i] = size;
            this.chunk.limit(pos + size);
            this.chunk.position(pos);
            ByteBuffer buf = this.chunk.duplicate();
            buf.mark();
            pos += size;
            buf.put(sparseHeapCopy);
            buf.reset();
            this.collectors.add(HyperLogLogCollector.makeCollector((ByteBuffer)buf));
        }
    }

    private ByteBuffer allocateEmptyHLLBuffer(boolean direct, boolean aligned, int offset) {
        ByteBuffer buf;
        int size = HyperLogLogCollector.getLatestNumBytesForDenseStorage();
        byte[] emptyBytes = HyperLogLogCollector.makeEmptyVersionedByteArray();
        if (direct) {
            if (aligned) {
                buf = ByteBuffers.allocateAlignedByteBuffer(size + offset, this.cacheLine);
                buf.position(offset);
                buf.mark();
                buf.limit(size + offset);
            } else {
                buf = ByteBuffer.allocateDirect(size);
                buf.mark();
                buf.limit(size);
            }
            buf.put(emptyBytes);
            buf.reset();
        } else {
            buf = ByteBuffer.allocate(size);
            buf.limit(size);
            buf.put(emptyBytes);
            buf.rewind();
        }
        return buf;
    }

    public double timeFold(int reps) {
        ByteBuffer buf = this.allocateEmptyHLLBuffer(this.targetIsDirect, this.alignTarget, 0);
        for (int k = 0; k < reps; ++k) {
            for (int i = 0; i < 100000; ++i) {
                int pos = this.positions[i];
                int size = this.sizes[i];
                HyperLogLogCollector.makeCollector((ByteBuffer)buf.duplicate().position(0).limit(HyperLogLogCollector.getLatestNumBytesForDenseStorage())).fold(HyperLogLogCollector.makeCollector((ByteBuffer)this.chunk.duplicate().limit(pos + size).position(pos)));
            }
        }
        return HyperLogLogCollector.makeCollector((ByteBuffer)buf.duplicate()).estimateCardinality();
    }

    public static void main(String[] args) {
        Runner.main(HyperLogLogCollectorBenchmark.class, (String[])args);
    }
}

