/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.junit.Assert;
import org.junit.Test;

public class TaskStatusTest {
    static final String STACK_TRACE = "org.apache.druid.java.util.common.ISE: Lock for interval [2024-04-23T00:00:00.000Z/2024-04-24T00:00:00.000Z] was revoked.\n\tat org.apache.druid.indexing.common.task.AbstractBatchIndexTask.tryTimeChunkLock(AbstractBatchIndexTask.java:465) ~[druid-indexing-service-2024.03.0-iap.jar:2024.03.0-iap]\n\tat org.apache.druid.indexing.common.task.batch.parallel.PartialHashSegmentGenerateTask.isReady(PartialHashSegmentGenerateTask.java:152) ~[druid-indexing-service-2024.03.0-iap.jar:2024.03.0-iap]\n\tat org.apache.druid.indexing.overlord.TaskQueue.manageInternalCritical(TaskQueue.java:420) [druid-indexing-service-2024.03.0-iap.jar:2024.03.0-iap]\n\tat org.apache.druid.indexing.overlord.TaskQueue.manageInternal(TaskQueue.java:373) [druid-indexing-service-2024.03.0-iap.jar:2024.03.0-iap]\n\tat org.apache.druid.indexing.overlord.TaskQueue.manage(TaskQueue.java:356) [druid-indexing-service-2024.03.0-iap.jar:2024.03.0-iap]\n\tat org.apache.druid.indexing.overlord.TaskQueue.access$000(TaskQueue.java:91) [druid-indexing-service-2024.03.0-iap.jar:2024.03.0-iap]\n\tat org.apache.druid.indexing.overlord.TaskQueue$1.run(TaskQueue.java:212) [druid-indexing-service-2024.03.0-iap.jar:2024.03.0-iap]\n\tat java.base/java.util.concurrent.Executors$RunnableAdapter.call(Executors.java:515) [?:?]\n\tat java.base/java.util.concurrent.FutureTask.run(FutureTask.java:264) [?:?]\n\tat java.base/java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1128) [?:?]\n\tat java.base/java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:628) [?:?]\n\tat java.base/java.lang.Thread.run(Thread.java:829) [?:?]\n";
    static final String EXPECTED_ERROR_MESSAGE = "org.apache.druid.java.util.common.ISE: Lock for interval [2024-04-23T00:00:00.000Z/2024-04-24T00:00:00.000Z] was revoked.\n\tat org.apache.druid.indexing.common.task.AbstractBatchIndexTask.tryTimeChunkLock(AbstractBatchIndexTask.java:465) ~[druid-indexing-service-2024.03.0-iap.jar:2024.03.0-iap]\n\tat org.apache.druid.indexing.common.task.batch.parallel.PartialHashSegmentGenerateTask.isReady(PartialHashSegmentGenerateTask.java:152) ~[druid-indexing-service-2024.03.0-iap.jar:2024.03.0-iap]\n\tat org.apache.druid.i...584 characters omitted...e$1.run(TaskQueue.java:212) [druid-indexing-service-2024.03.0-iap.jar:2024.03.0-iap]\n\tat java.base/java.util.concurrent.Executors$RunnableAdapter.call(Executors.java:515) [?:?]\n\tat java.base/java.util.concurrent.FutureTask.run(FutureTask.java:264) [?:?]\n\tat java.base/java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1128) [?:?]\n\tat java.base/java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:628) [?:?]\n\tat java.base/java.lang.Thread.run(Thread.java:829) [?:?]\n";

    @Test
    public void testSerde() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        TaskStatus status = new TaskStatus("testId", TaskState.RUNNING, 1000L, "an error message", TaskLocation.create((String)"testHost", (int)1010, (int)-1));
        String json = mapper.writeValueAsString((Object)status);
        Assert.assertEquals((Object)status, (Object)mapper.readValue(json, TaskStatus.class));
        String jsonNoLocation = "{\n\"id\": \"testId\",\n\"status\": \"SUCCESS\",\n\"duration\": 3000,\n\"errorMsg\": \"hello\"\n}";
        TaskStatus statusNoLocation = new TaskStatus("testId", TaskState.SUCCESS, 3000L, "hello", null);
        Assert.assertEquals((Object)statusNoLocation, (Object)mapper.readValue("{\n\"id\": \"testId\",\n\"status\": \"SUCCESS\",\n\"duration\": 3000,\n\"errorMsg\": \"hello\"\n}", TaskStatus.class));
        TaskStatus success = TaskStatus.success((String)"forkTaskID", (TaskLocation)TaskLocation.create((String)"localhost", (int)0, (int)1));
        Assert.assertEquals((Object)success.getLocation().getHost(), (Object)"localhost");
        Assert.assertEquals((long)success.getLocation().getPort(), (long)0L);
        Assert.assertEquals((long)success.getLocation().getTlsPort(), (long)1L);
    }

    @Test
    public void testTruncation() {
        TaskStatus status = TaskStatus.failure((String)"testId", (String)STACK_TRACE);
        Assert.assertEquals((Object)status.getErrorMsg(), (Object)EXPECTED_ERROR_MESSAGE);
    }
}

