/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.partitions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Map;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SingleDimensionPartitionsSpecTest {
    private static final Integer TARGET_ROWS_PER_SEGMENT = 1;
    private static final Integer MAX_ROWS_PER_SEGMENT = null;
    private static final Integer HISTORICAL_NULL = -1;
    private static final String PARTITION_DIMENSION = "a";
    private static final boolean ASSUME_GROUPED = false;
    private static final SingleDimensionPartitionsSpec SPEC = new SingleDimensionPartitionsSpec(TARGET_ROWS_PER_SEGMENT, MAX_ROWS_PER_SEGMENT, "a", false);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void serde() {
        String json = SingleDimensionPartitionsSpecTest.serialize(SPEC);
        SingleDimensionPartitionsSpec spec = SingleDimensionPartitionsSpecTest.deserialize(json);
        Assert.assertEquals((Object)SPEC, (Object)spec);
    }

    @Test
    public void deserializeWithBackwardCompatibility() {
        String serialized = "{\"type\":\"single_dim\",\"targetPartitionSize\":" + TARGET_ROWS_PER_SEGMENT + ",\"maxPartitionSize\":" + MAX_ROWS_PER_SEGMENT + ",\"partitionDimension\":\"a\",\"assumeGrouped\":false}";
        SingleDimensionPartitionsSpec spec = SingleDimensionPartitionsSpecTest.deserialize(serialized);
        Assert.assertEquals((Object)SPEC, (Object)spec);
    }

    @Test
    public void testDeserializeWithUnrecognizedProperty() {
        String json = "{\"type\":\"single_dim\",\"targetPartitionSize\":100,\"partitionDimension\":\"dim1\",\"partitionDimensions\":[\"dim2\"]}";
        try {
            SingleDimensionPartitionsSpecTest.deserialize(json);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("UnrecognizedPropertyException: Unrecognized field \"partitionDimensions\""));
        }
    }

    @Test
    public void testGetSerializableObjectContainsNoExtraField() {
        this.verifySerializableFields(SPEC);
        this.verifySerializableFields(new SingleDimensionPartitionsSpec(null, null, "abc", false, Integer.valueOf(100), null));
    }

    private void verifySerializableFields(SingleDimensionPartitionsSpec spec) {
        Map jsonMap = spec.getSerializableObject();
        Assert.assertEquals((long)4L, (long)jsonMap.size());
        Assert.assertTrue((boolean)jsonMap.containsKey("maxRowsPerSegment"));
        Assert.assertTrue((boolean)jsonMap.containsKey("targetRowsPerSegment"));
        Assert.assertTrue((boolean)jsonMap.containsKey("assumeGrouped"));
        Assert.assertTrue((boolean)jsonMap.containsKey("partitionDimension"));
    }

    @Test
    public void havingBothTargetForbidden() {
        new Tester().targetRowsPerSegment(1).targetPartitionSize(1).testIllegalArgumentException("At most one of [Property{name='targetRowsPerSegment', value=1}] or [Property{name='targetPartitionSize', value=1}] must be present");
    }

    @Test
    public void havingBothMaxForbidden() {
        new Tester().maxRowsPerSegment(1).maxPartitionSize(1).testIllegalArgumentException("At most one of [Property{name='maxRowsPerSegment', value=1}] or [Property{name='maxPartitionSize', value=1}] must be present");
    }

    @Test
    public void havingNeitherTargetNorMaxForbidden() {
        new Tester().testIllegalArgumentException("Exactly one of targetRowsPerSegment or maxRowsPerSegment must be present");
    }

    @Test
    public void targetRowsPerSegmentMustBePositive() {
        new Tester().targetRowsPerSegment(0).testIllegalArgumentException("targetRowsPerSegment must be greater than 0");
    }

    @Test
    public void targetRowsPerSegmentHistoricalNull() {
        new Tester().targetRowsPerSegment(HISTORICAL_NULL).testIllegalArgumentException("Exactly one of targetRowsPerSegment or maxRowsPerSegment must be present");
    }

    @Test
    public void targetPartitionSizeMustBePositive() {
        new Tester().targetPartitionSize(0).testIllegalArgumentException("targetRowsPerSegment must be greater than 0");
    }

    @Test
    public void targetMaxRowsPerSegmentOverflows() {
        new Tester().targetRowsPerSegment(Integer.MAX_VALUE).testIllegalArgumentException("targetRowsPerSegment is too large");
    }

    @Test
    public void targetPartitionSizeOverflows() {
        new Tester().targetPartitionSize(Integer.MAX_VALUE).testIllegalArgumentException("targetRowsPerSegment is too large");
    }

    @Test
    public void maxRowsPerSegmentMustBePositive() {
        new Tester().maxRowsPerSegment(0).testIllegalArgumentException("maxRowsPerSegment must be greater than 0");
    }

    @Test
    public void maxRowsPerSegmentHistoricalNull() {
        new Tester().maxRowsPerSegment(HISTORICAL_NULL).testIllegalArgumentException("Exactly one of targetRowsPerSegment or maxRowsPerSegment must be present");
    }

    @Test
    public void maxPartitionSizeMustBePositive() {
        new Tester().maxPartitionSize(0).testIllegalArgumentException("maxRowsPerSegment must be greater than 0");
    }

    @Test
    public void maxPartitionHistoricalNull() {
        new Tester().maxPartitionSize(HISTORICAL_NULL).testIllegalArgumentException("Exactly one of targetRowsPerSegment or maxRowsPerSegment must be present");
    }

    @Test
    public void resolvesMaxFromTargetRowsPerSegment() {
        SingleDimensionPartitionsSpec spec = new Tester().targetRowsPerSegment(123).build();
        Assert.assertEquals((long)184L, (long)spec.getMaxRowsPerSegment().intValue());
    }

    @Test
    public void resolvesMaxFromTargetPartitionSize() {
        SingleDimensionPartitionsSpec spec = new Tester().targetPartitionSize(123).build();
        Assert.assertEquals((Object)184, (Object)spec.getMaxRowsPerSegment());
    }

    @Test
    public void resolvesMaxFromMaxRowsPerSegment() {
        SingleDimensionPartitionsSpec spec = new Tester().maxRowsPerSegment(123).build();
        Assert.assertEquals((long)123L, (long)spec.getMaxRowsPerSegment().intValue());
    }

    @Test
    public void resolvesMaxFromMaxPartitionSize() {
        SingleDimensionPartitionsSpec spec = new Tester().maxPartitionSize(123).build();
        Assert.assertEquals((long)123L, (long)spec.getMaxRowsPerSegment().intValue());
    }

    @Test
    public void getPartitionDimensionFromNull() {
        SingleDimensionPartitionsSpec spec = new Tester().targetPartitionSize(1).partitionDimension(null).build();
        Assert.assertEquals(Collections.emptyList(), (Object)spec.getPartitionDimensions());
    }

    @Test
    public void getPartitionDimensionFromNonNull() {
        String partitionDimension = PARTITION_DIMENSION;
        SingleDimensionPartitionsSpec spec = new Tester().targetPartitionSize(1).partitionDimension(partitionDimension).build();
        Assert.assertEquals(Collections.singletonList(partitionDimension), (Object)spec.getPartitionDimensions());
    }

    private static String serialize(SingleDimensionPartitionsSpec spec) {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)spec);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static SingleDimensionPartitionsSpec deserialize(String serialized) {
        try {
            return (SingleDimensionPartitionsSpec)OBJECT_MAPPER.readValue(serialized, SingleDimensionPartitionsSpec.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class Tester {
        private Integer targetRowsPerSegment;
        private Integer maxRowsPerSegment;
        private String partitionDimension;
        private Integer targetPartitionSize;
        private Integer maxPartitionSize;

        private Tester() {
        }

        Tester targetRowsPerSegment(Integer targetRowsPerSegment) {
            this.targetRowsPerSegment = targetRowsPerSegment;
            return this;
        }

        Tester maxRowsPerSegment(Integer maxRowsPerSegment) {
            this.maxRowsPerSegment = maxRowsPerSegment;
            return this;
        }

        Tester partitionDimension(String partitionDimension) {
            this.partitionDimension = partitionDimension;
            return this;
        }

        Tester targetPartitionSize(Integer targetPartitionSize) {
            this.targetPartitionSize = targetPartitionSize;
            return this;
        }

        Tester maxPartitionSize(Integer maxPartitionSize) {
            this.maxPartitionSize = maxPartitionSize;
            return this;
        }

        void testIllegalArgumentException(String exceptionExpectedMessage) {
            SingleDimensionPartitionsSpecTest.this.exception.expect(IllegalArgumentException.class);
            SingleDimensionPartitionsSpecTest.this.exception.expectMessage(exceptionExpectedMessage);
            this.build();
        }

        SingleDimensionPartitionsSpec build() {
            return new SingleDimensionPartitionsSpec(this.targetRowsPerSegment, this.maxRowsPerSegment, this.partitionDimension, false, this.targetPartitionSize, this.maxPartitionSize);
        }
    }
}

