/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.druid.io.LimitedOutputStream;
import org.apache.druid.java.util.common.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class LimitedOutputStreamTest {
    @Test
    public void test_limitZero() throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             LimitedOutputStream stream = new LimitedOutputStream((OutputStream)baos, 0L, LimitedOutputStreamTest::makeErrorMessage);){
            IOException e = (IOException)Assert.assertThrows(IOException.class, () -> LimitedOutputStreamTest.lambda$test_limitZero$0((OutputStream)stream));
            MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"Limit[0] exceeded")));
        }
    }

    @Test
    public void test_limitThree() throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             LimitedOutputStream stream = new LimitedOutputStream((OutputStream)baos, 3L, LimitedOutputStreamTest::makeErrorMessage);){
            stream.write(97);
            stream.write(new byte[]{98});
            stream.write(new byte[]{99}, 0, 1);
            IOException e = (IOException)Assert.assertThrows(IOException.class, () -> LimitedOutputStreamTest.lambda$test_limitThree$1((OutputStream)stream));
            MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"Limit[3] exceeded")));
        }
    }

    private static String makeErrorMessage(long limit) {
        return StringUtils.format((String)"Limit[%d] exceeded", (Object[])new Object[]{limit});
    }

    private static /* synthetic */ void lambda$test_limitThree$1(OutputStream stream) throws Throwable {
        stream.write(100);
    }

    private static /* synthetic */ void lambda$test_limitZero$0(OutputStream stream) throws Throwable {
        stream.write(98);
    }
}

