/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.BasicMonitorScheduler;
import org.apache.druid.java.util.metrics.DruidMonitorSchedulerConfig;
import org.apache.druid.java.util.metrics.Monitor;
import org.joda.time.Duration;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BasicMonitorSchedulerTest {
    private final DruidMonitorSchedulerConfig config = new DruidMonitorSchedulerConfig(){

        public Duration getEmissionDuration() {
            return Duration.millis((long)5L);
        }
    };
    private ServiceEmitter emitter;
    private ScheduledExecutorService exec;

    @Before
    public void setup() {
        this.emitter = (ServiceEmitter)Mockito.mock(ServiceEmitter.class);
        this.exec = Execs.scheduledSingleThreaded((String)"BasicMonitorSchedulerTest");
    }

    @After
    public void teardown() {
        this.exec.shutdownNow();
    }

    @Test
    public void testStart_RepeatScheduling() throws InterruptedException {
        Monitor monitor = (Monitor)Mockito.mock(Monitor.class);
        Mockito.when((Object)monitor.monitor((ServiceEmitter)ArgumentMatchers.any())).thenReturn((Object)true);
        BasicMonitorScheduler scheduler = new BasicMonitorScheduler(this.config, this.emitter, (List)ImmutableList.of((Object)monitor), this.exec);
        scheduler.start();
        Thread.sleep(100L);
        ((Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.atLeast((int)2))).monitor((ServiceEmitter)ArgumentMatchers.any());
        scheduler.stop();
    }

    @Test
    public void testStart_RepeatAndStopScheduling() throws InterruptedException {
        Monitor monitor = (Monitor)Mockito.mock(Monitor.class);
        Mockito.when((Object)monitor.monitor((ServiceEmitter)ArgumentMatchers.any())).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        BasicMonitorScheduler scheduler = new BasicMonitorScheduler(this.config, this.emitter, (List)ImmutableList.of((Object)monitor), this.exec);
        scheduler.start();
        Thread.sleep(100L);
        ((Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.atLeast((int)5))).monitor((ServiceEmitter)ArgumentMatchers.any());
        scheduler.stop();
    }

    @Test
    public void testStart_UnexpectedExceptionWhileMonitoring_ContinueMonitor() throws InterruptedException {
        Monitor monitor = (Monitor)Mockito.mock(Monitor.class);
        Mockito.when((Object)monitor.monitor((ServiceEmitter)ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException("Test throwing exception while monitoring")});
        BasicMonitorScheduler scheduler = new BasicMonitorScheduler(this.config, this.emitter, (List)ImmutableList.of((Object)monitor), this.exec);
        scheduler.start();
        Thread.sleep(1000L);
        ((Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.atLeast((int)2))).monitor((ServiceEmitter)ArgumentMatchers.any());
        scheduler.stop();
    }
}

