/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics.cgroups;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.HashMap;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.Memory;
import org.apache.druid.java.util.metrics.cgroups.ProcCgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class MemoryTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File procDir;
    private File cgroupDir;
    private CgroupDiscoverer discoverer;

    @Before
    public void setUp() throws Exception {
        this.cgroupDir = this.temporaryFolder.newFolder();
        this.procDir = this.temporaryFolder.newFolder();
        this.discoverer = new ProcCgroupDiscoverer(this.procDir.toPath());
        TestUtils.setUpCgroups(this.procDir, this.cgroupDir);
        File memoryDir = new File(this.cgroupDir, "memory/system.slice/some.service");
        FileUtils.mkdirp((File)memoryDir);
        TestUtils.copyResource("/memory.stat", new File(memoryDir, "memory.stat"));
        TestUtils.copyResource("/memory.numa_stat", new File(memoryDir, "memory.numa_stat"));
        TestUtils.copyResource("/memory.usage_in_bytes", new File(memoryDir, "memory.usage_in_bytes"));
        TestUtils.copyResource("/memory.limit_in_bytes", new File(memoryDir, "memory.limit_in_bytes"));
    }

    @Test
    public void testWontCrash() {
        Memory memory = new Memory(cgroup -> {
            throw new RuntimeException("shouldContinue");
        });
        Memory.MemoryStat stat = memory.snapshot("memory.usage_in_bytes", "memory.limit_in_bytes");
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)stat.getNumaMemoryStats());
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)stat.getMemoryStats());
    }

    @Test
    public void testSimpleSnapshot() {
        Memory memory = new Memory(this.discoverer);
        Memory.MemoryStat stat = memory.snapshot("memory.usage_in_bytes", "memory.limit_in_bytes");
        Assert.assertEquals((long)5000000L, (long)stat.getUsage());
        Assert.assertEquals((long)8000000L, (long)stat.getLimit());
        HashMap<String, Long> expectedMemoryStats = new HashMap<String, Long>();
        expectedMemoryStats.put("inactive_anon", 0L);
        expectedMemoryStats.put("total_pgfault", 13137L);
        expectedMemoryStats.put("total_unevictable", 0L);
        expectedMemoryStats.put("pgfault", 13137L);
        expectedMemoryStats.put("mapped_file", 0x144000L);
        expectedMemoryStats.put("total_pgpgout", 5975L);
        expectedMemoryStats.put("total_active_anon", 1757184L);
        expectedMemoryStats.put("total_rss", 1818624L);
        expectedMemoryStats.put("rss", 1818624L);
        expectedMemoryStats.put("total_inactive_anon", 0L);
        expectedMemoryStats.put("active_file", 5873664L);
        expectedMemoryStats.put("total_swap", 0L);
        expectedMemoryStats.put("dirty", 0L);
        expectedMemoryStats.put("total_mapped_file", 0x144000L);
        expectedMemoryStats.put("total_rss_huge", 0L);
        expectedMemoryStats.put("total_inactive_file", 2019328L);
        expectedMemoryStats.put("cache", 0x787000L);
        expectedMemoryStats.put("rss_huge", 0L);
        expectedMemoryStats.put("shmem", 0L);
        expectedMemoryStats.put("swap", 0L);
        expectedMemoryStats.put("total_pgpgin", 8346L);
        expectedMemoryStats.put("unevictable", 0L);
        expectedMemoryStats.put("active_anon", 1757184L);
        expectedMemoryStats.put("total_dirty", 0L);
        expectedMemoryStats.put("total_active_file", 5873664L);
        expectedMemoryStats.put("hierarchical_memory_limit", 0x7FFFFFFFFFFFF000L);
        expectedMemoryStats.put("total_cache", 0x787000L);
        expectedMemoryStats.put("pgpgin", 8346L);
        expectedMemoryStats.put("pgmajfault", 120L);
        expectedMemoryStats.put("inactive_file", 2019328L);
        expectedMemoryStats.put("hierarchical_memsw_limit", 0x7FFFFFFFFFFFF000L);
        expectedMemoryStats.put("writeback", 0L);
        expectedMemoryStats.put("total_shmem", 0L);
        expectedMemoryStats.put("pgpgout", 5975L);
        expectedMemoryStats.put("total_pgmajfault", 120L);
        expectedMemoryStats.put("total_writeback", 0L);
        Assert.assertEquals(expectedMemoryStats, (Object)stat.getMemoryStats());
        HashMap expectedMemoryNumaStats = new HashMap();
        HashMap<String, Long> expectedNumaNode0Stats = new HashMap<String, Long>();
        expectedNumaNode0Stats.put("anon", 432L);
        expectedNumaNode0Stats.put("total", 2359L);
        expectedNumaNode0Stats.put("hierarchical_total", 2359L);
        expectedNumaNode0Stats.put("file", 1927L);
        expectedNumaNode0Stats.put("unevictable", 0L);
        expectedNumaNode0Stats.put("hierarchical_file", 1927L);
        expectedNumaNode0Stats.put("hierarchical_anon", 432L);
        expectedNumaNode0Stats.put("hierarchical_unevictable", 0L);
        expectedMemoryNumaStats.put(0L, expectedNumaNode0Stats);
        Assert.assertEquals(expectedMemoryNumaStats, (Object)stat.getNumaMemoryStats());
    }
}

