/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junitparams.converters.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionTypeFactory;
import org.apache.druid.math.expr.Function;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.LongExpr;
import org.apache.druid.math.expr.NullLongExpr;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.column.TypeStrategiesTest;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EvalTest
extends InitializedNullHandlingTest {
    @BeforeClass
    public static void setupClass() {
        TypeStrategies.registerComplex((String)TypeStrategiesTest.NULLABLE_TEST_PAIR_TYPE.getComplexTypeName(), (TypeStrategy)new TypeStrategiesTest.NullableLongPairTypeStrategy());
    }

    private long evalLong(String x, Expr.ObjectBinding bindings) {
        ExprEval ret = this.eval(x, bindings);
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ret.type());
        return ret.asLong();
    }

    private double evalDouble(String x, Expr.ObjectBinding bindings) {
        ExprEval ret = this.eval(x, bindings);
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ret.type());
        return ret.asDouble();
    }

    private ExprEval eval(String x, Expr.ObjectBinding bindings) {
        return Parser.parse((String)x, (ExprMacroTable)ExprMacroTable.nil()).eval(bindings);
    }

    @Test
    public void testDoubleEval() {
        Expr.ObjectBinding bindings = InputBindings.forMap((Map)ImmutableMap.of((Object)"x", (Object)2.0));
        Assert.assertEquals((double)2.0, (double)this.evalDouble("x", bindings), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)this.evalDouble("\"x\"", bindings), (double)1.0E-4);
        Assert.assertEquals((double)304.0, (double)this.evalDouble("300 + \"x\" * 2", bindings), (double)1.0E-4);
        Assert.assertEquals((long)0L, (long)this.evalLong("1.0 && 0.0", bindings));
        Assert.assertEquals((long)1L, (long)this.evalLong("1.0 && 2.0", bindings));
        Assert.assertEquals((long)1L, (long)this.evalLong("1.0 || 0.0", bindings));
        Assert.assertEquals((long)0L, (long)this.evalLong("0.0 || 0.0", bindings));
        Assert.assertEquals((long)1L, (long)this.evalLong("2.0 > 1.0", bindings));
        Assert.assertEquals((long)1L, (long)this.evalLong("2.0 >= 2.0", bindings));
        Assert.assertEquals((long)1L, (long)this.evalLong("1.0 < 2.0", bindings));
        Assert.assertEquals((long)1L, (long)this.evalLong("2.0 <= 2.0", bindings));
        Assert.assertEquals((long)1L, (long)this.evalLong("2.0 == 2.0", bindings));
        Assert.assertEquals((long)1L, (long)this.evalLong("2.0 != 1.0", bindings));
        Assert.assertEquals((long)1L, (long)this.evalLong("notdistinctfrom(2.0, 2.0)", bindings));
        Assert.assertEquals((long)1L, (long)this.evalLong("isdistinctfrom(2.0, 1.0)", bindings));
        Assert.assertEquals((long)0L, (long)this.evalLong("notdistinctfrom(2.0, 1.0)", bindings));
        Assert.assertEquals((long)0L, (long)this.evalLong("isdistinctfrom(2.0, 2.0)", bindings));
        Assert.assertEquals((long)0L, (long)this.evalLong("istrue(0.0)", bindings));
        Assert.assertEquals((long)1L, (long)this.evalLong("isfalse(0.0)", bindings));
        Assert.assertEquals((long)1L, (long)this.evalLong("nottrue(0.0)", bindings));
        Assert.assertEquals((long)0L, (long)this.evalLong("notfalse(0.0)", bindings));
        Assert.assertEquals((long)1L, (long)this.evalLong("istrue(1.0)", bindings));
        Assert.assertEquals((long)0L, (long)this.evalLong("isfalse(1.0)", bindings));
        Assert.assertEquals((long)0L, (long)this.evalLong("nottrue(1.0)", bindings));
        Assert.assertEquals((long)1L, (long)this.evalLong("notfalse(1.0)", bindings));
        Assert.assertEquals((long)1L, (long)this.evalLong("!-1.0", bindings));
        Assert.assertEquals((long)1L, (long)this.evalLong("!0.0", bindings));
        Assert.assertEquals((long)0L, (long)this.evalLong("!2.0", bindings));
        Assert.assertEquals((double)3.5, (double)this.evalDouble("2.0 + 1.5", bindings), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)this.evalDouble("2.0 - 1.5", bindings), (double)1.0E-4);
        Assert.assertEquals((double)3.0, (double)this.evalDouble("2.0 * 1.5", bindings), (double)1.0E-4);
        Assert.assertEquals((double)4.0, (double)this.evalDouble("2.0 / 0.5", bindings), (double)1.0E-4);
        Assert.assertEquals((double)0.2, (double)this.evalDouble("2.0 % 0.3", bindings), (double)1.0E-4);
        Assert.assertEquals((double)8.0, (double)this.evalDouble("2.0 ^ 3.0", bindings), (double)1.0E-4);
        Assert.assertEquals((double)-1.5, (double)this.evalDouble("-1.5", bindings), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)this.evalDouble("sqrt(4.0)", bindings), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)this.evalDouble("if(1.0, 2.0, 3.0)", bindings), (double)1.0E-4);
        Assert.assertEquals((double)3.0, (double)this.evalDouble("if(0.0, 2.0, 3.0)", bindings), (double)1.0E-4);
    }

    @Test
    public void testLongEval() {
        Expr.ObjectBinding bindings = InputBindings.forMap((Map)ImmutableMap.of((Object)"x", (Object)Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.evalLong("x", bindings));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.evalLong("\"x\"", bindings));
        Assert.assertEquals((long)92233720368547759L, (long)this.evalLong("\"x\" / 100 + 1", bindings));
        Assert.assertFalse((this.evalLong("9223372036854775807 && 0", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("9223372036854775807 && 9223372036854775806", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("9223372036854775807 || 0", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertFalse((this.evalLong("-9223372036854775807 || -9223372036854775807", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("-9223372036854775807 || 9223372036854775807", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertFalse((this.evalLong("0 || 0", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("9223372036854775807 > 9223372036854775806", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("9223372036854775807 >= 9223372036854775807", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("9223372036854775806 < 9223372036854775807", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("9223372036854775807 <= 9223372036854775807", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("9223372036854775807 == 9223372036854775807", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("9223372036854775807 != 9223372036854775806", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("notdistinctfrom(9223372036854775807, 9223372036854775807)", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("isdistinctfrom(9223372036854775807, 9223372036854775806)", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.evalLong("9223372036854775806 + 1", bindings));
        Assert.assertEquals((long)0x7FFFFFFFFFFFFFFEL, (long)this.evalLong("9223372036854775807 - 1", bindings));
        Assert.assertEquals((long)0x7FFFFFFFFFFFFFFEL, (long)this.evalLong("4611686018427387903 * 2", bindings));
        Assert.assertEquals((long)0x3FFFFFFFFFFFFFFFL, (long)this.evalLong("9223372036854775806 / 2", bindings));
        Assert.assertEquals((long)7L, (long)this.evalLong("9223372036854775807 % 9223372036854775800", bindings));
        Assert.assertEquals((long)9223372030926249001L, (long)this.evalLong("3037000499 ^ 2", bindings));
        Assert.assertEquals((long)-9223372036854775807L, (long)this.evalLong("-9223372036854775807", bindings));
        Assert.assertTrue((this.evalLong("!-9223372036854775807", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.evalLong("!0", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertFalse((this.evalLong("!9223372036854775807", bindings) > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)3037000499L, (long)this.evalLong("cast(sqrt(9223372036854775807), 'long')", bindings));
        Assert.assertEquals((long)1L, (long)this.evalLong("if(x == 9223372036854775807, 1, 0)", bindings));
        Assert.assertEquals((long)0L, (long)this.evalLong("if(x - 1 == 9223372036854775807, 1, 0)", bindings));
        Assert.assertEquals((long)1271030400000L, (long)this.evalLong("timestamp('2010-04-12')", bindings));
        Assert.assertEquals((long)1270998000000L, (long)this.evalLong("timestamp('2010-04-12T+09:00')", bindings));
        Assert.assertEquals((long)1271055781000L, (long)this.evalLong("timestamp('2010-04-12T07:03:01')", bindings));
        Assert.assertEquals((long)1271023381000L, (long)this.evalLong("timestamp('2010-04-12T07:03:01+09:00')", bindings));
        Assert.assertEquals((long)1271023381419L, (long)this.evalLong("timestamp('2010-04-12T07:03:01.419+09:00')", bindings));
        Assert.assertEquals((long)1271030400L, (long)this.evalLong("unix_timestamp('2010-04-12')", bindings));
        Assert.assertEquals((long)1270998000L, (long)this.evalLong("unix_timestamp('2010-04-12T+09:00')", bindings));
        Assert.assertEquals((long)1271055781L, (long)this.evalLong("unix_timestamp('2010-04-12T07:03:01')", bindings));
        Assert.assertEquals((long)1271023381L, (long)this.evalLong("unix_timestamp('2010-04-12T07:03:01+09:00')", bindings));
        Assert.assertEquals((long)1271023381L, (long)this.evalLong("unix_timestamp('2010-04-12T07:03:01.419+09:00')", bindings));
        Assert.assertEquals((Object)"", (Object)this.eval("nvl(if(x == 9223372036854775807, '', 'x'), 'NULL')", bindings).asString());
        Assert.assertEquals((Object)"x", (Object)this.eval("nvl(if(x == 9223372036854775806, '', 'x'), 'NULL')", bindings).asString());
    }

    @Test
    public void testIsNotDistinctFrom() {
        Assert.assertEquals((Object)1L, (Object)new Function.IsNotDistinctFromFunc().apply((List)ImmutableList.of((Object)new NullLongExpr(), (Object)new NullLongExpr()), InputBindings.nilBindings()).value());
        Assert.assertEquals((Object)0L, (Object)new Function.IsNotDistinctFromFunc().apply((List)ImmutableList.of((Object)new LongExpr(Long.valueOf(0L)), (Object)new NullLongExpr()), InputBindings.nilBindings()).value());
        Assert.assertEquals((Object)1L, (Object)new Function.IsNotDistinctFromFunc().apply((List)ImmutableList.of((Object)new LongExpr(Long.valueOf(0L)), (Object)new LongExpr(Long.valueOf(0L))), InputBindings.nilBindings()).value());
    }

    @Test
    public void testIsDistinctFrom() {
        Assert.assertEquals((Object)0L, (Object)new Function.IsDistinctFromFunc().apply((List)ImmutableList.of((Object)new NullLongExpr(), (Object)new NullLongExpr()), InputBindings.nilBindings()).value());
        Assert.assertEquals((Object)1L, (Object)new Function.IsDistinctFromFunc().apply((List)ImmutableList.of((Object)new LongExpr(Long.valueOf(0L)), (Object)new NullLongExpr()), InputBindings.nilBindings()).value());
        Assert.assertEquals((Object)0L, (Object)new Function.IsDistinctFromFunc().apply((List)ImmutableList.of((Object)new LongExpr(Long.valueOf(0L)), (Object)new LongExpr(Long.valueOf(0L))), InputBindings.nilBindings()).value());
    }

    @Test
    public void testIsFalse() {
        Assert.assertEquals((Object)0L, (Object)new Function.IsFalseFunc().apply((List)ImmutableList.of((Object)new NullLongExpr()), InputBindings.nilBindings()).value());
        Assert.assertEquals((Object)1L, (Object)new Function.IsFalseFunc().apply((List)ImmutableList.of((Object)new LongExpr(Long.valueOf(0L))), InputBindings.nilBindings()).value());
        Assert.assertEquals((Object)0L, (Object)new Function.IsFalseFunc().apply((List)ImmutableList.of((Object)new LongExpr(Long.valueOf(1L))), InputBindings.nilBindings()).value());
    }

    @Test
    public void testIsTrue() {
        Assert.assertEquals((Object)0L, (Object)new Function.IsTrueFunc().apply((List)ImmutableList.of((Object)new NullLongExpr()), InputBindings.nilBindings()).value());
        Assert.assertEquals((Object)0L, (Object)new Function.IsTrueFunc().apply((List)ImmutableList.of((Object)new LongExpr(Long.valueOf(0L))), InputBindings.nilBindings()).value());
        Assert.assertEquals((Object)1L, (Object)new Function.IsTrueFunc().apply((List)ImmutableList.of((Object)new LongExpr(Long.valueOf(1L))), InputBindings.nilBindings()).value());
    }

    @Test
    public void testIsNotFalse() {
        Assert.assertEquals((Object)1L, (Object)new Function.IsNotFalseFunc().apply((List)ImmutableList.of((Object)new NullLongExpr()), InputBindings.nilBindings()).value());
        Assert.assertEquals((Object)0L, (Object)new Function.IsNotFalseFunc().apply((List)ImmutableList.of((Object)new LongExpr(Long.valueOf(0L))), InputBindings.nilBindings()).value());
        Assert.assertEquals((Object)1L, (Object)new Function.IsNotFalseFunc().apply((List)ImmutableList.of((Object)new LongExpr(Long.valueOf(1L))), InputBindings.nilBindings()).value());
    }

    @Test
    public void testIsNotTrue() {
        Assert.assertEquals((Object)1L, (Object)new Function.IsNotTrueFunc().apply((List)ImmutableList.of((Object)new NullLongExpr()), InputBindings.nilBindings()).value());
        Assert.assertEquals((Object)1L, (Object)new Function.IsNotTrueFunc().apply((List)ImmutableList.of((Object)new LongExpr(Long.valueOf(0L))), InputBindings.nilBindings()).value());
        Assert.assertEquals((Object)0L, (Object)new Function.IsNotTrueFunc().apply((List)ImmutableList.of((Object)new LongExpr(Long.valueOf(1L))), InputBindings.nilBindings()).value());
    }

    @Test
    public void testArrayToScalar() {
        Assert.assertEquals((long)1L, (long)ExprEval.ofLongArray((Object[])new Long[]{1L}).asLong());
        Assert.assertEquals((double)1.0, (double)ExprEval.ofLongArray((Object[])new Long[]{1L}).asDouble(), (double)0.0);
        Assert.assertEquals((long)1L, (long)ExprEval.ofLongArray((Object[])new Long[]{1L}).asInt());
        Assert.assertEquals((Object)true, (Object)ExprEval.ofLongArray((Object[])new Long[]{1L}).asBoolean());
        Assert.assertEquals((Object)"1", (Object)ExprEval.ofLongArray((Object[])new Long[]{1L}).asString());
        Assert.assertEquals(null, (Object)ExprEval.ofLongArray((Object[])new Long[]{null}).asString());
        Assert.assertEquals((long)0L, (long)ExprEval.ofLongArray((Object[])new Long[]{1L, 2L}).asLong());
        Assert.assertEquals((double)0.0, (double)ExprEval.ofLongArray((Object[])new Long[]{1L, 2L}).asDouble(), (double)0.0);
        Assert.assertEquals((Object)"[1, 2]", (Object)ExprEval.ofLongArray((Object[])new Long[]{1L, 2L}).asString());
        Assert.assertEquals((long)0L, (long)ExprEval.ofLongArray((Object[])new Long[]{1L, 2L}).asInt());
        Assert.assertEquals((Object)false, (Object)ExprEval.ofLongArray((Object[])new Long[]{1L, 2L}).asBoolean());
        Assert.assertEquals((double)1.1, (double)ExprEval.ofDoubleArray((Object[])new Double[]{1.1}).asDouble(), (double)0.0);
        Assert.assertEquals((long)1L, (long)ExprEval.ofDoubleArray((Object[])new Double[]{1.1}).asLong());
        Assert.assertEquals((Object)"1.1", (Object)ExprEval.ofDoubleArray((Object[])new Double[]{1.1}).asString());
        Assert.assertEquals((long)1L, (long)ExprEval.ofDoubleArray((Object[])new Double[]{1.1}).asInt());
        Assert.assertEquals((Object)true, (Object)ExprEval.ofDoubleArray((Object[])new Double[]{1.1}).asBoolean());
        Assert.assertEquals(null, (Object)ExprEval.ofDoubleArray((Object[])new Double[]{null}).asString());
        Assert.assertEquals((double)0.0, (double)ExprEval.ofDoubleArray((Object[])new Double[]{1.1, 2.2}).asDouble(), (double)0.0);
        Assert.assertEquals((long)0L, (long)ExprEval.ofDoubleArray((Object[])new Double[]{1.1, 2.2}).asLong());
        Assert.assertEquals((Object)"[1.1, 2.2]", (Object)ExprEval.ofDoubleArray((Object[])new Double[]{1.1, 2.2}).asString());
        Assert.assertEquals((long)0L, (long)ExprEval.ofDoubleArray((Object[])new Double[]{1.1, 2.2}).asInt());
        Assert.assertEquals((Object)false, (Object)ExprEval.ofDoubleArray((Object[])new Double[]{1.1, 2.2}).asBoolean());
        Assert.assertEquals((Object)"foo", (Object)ExprEval.ofStringArray((Object[])new String[]{"foo"}).asString());
        Assert.assertEquals((Object)"1", (Object)ExprEval.ofStringArray((Object[])new String[]{"1"}).asString());
        Assert.assertEquals((long)1L, (long)ExprEval.ofStringArray((Object[])new String[]{"1"}).asLong());
        Assert.assertEquals((double)1.0, (double)ExprEval.ofStringArray((Object[])new String[]{"1"}).asDouble(), (double)0.0);
        Assert.assertEquals((long)1L, (long)ExprEval.ofStringArray((Object[])new String[]{"1"}).asInt());
        Assert.assertEquals((Object)false, (Object)ExprEval.ofStringArray((Object[])new String[]{"1"}).asBoolean());
        Assert.assertEquals((Object)true, (Object)ExprEval.ofStringArray((Object[])new String[]{"true"}).asBoolean());
        Assert.assertEquals((Object)"[1, 2.2]", (Object)ExprEval.ofStringArray((Object[])new String[]{"1", "2.2"}).asString());
        Assert.assertEquals((long)0L, (long)ExprEval.ofStringArray((Object[])new String[]{"1", "2.2"}).asLong());
        Assert.assertEquals((double)0.0, (double)ExprEval.ofStringArray((Object[])new String[]{"1", "2.2"}).asDouble(), (double)0.0);
        Assert.assertEquals((long)0L, (long)ExprEval.ofStringArray((Object[])new String[]{"1", "2.2"}).asInt());
        Assert.assertEquals((Object)false, (Object)ExprEval.ofStringArray((Object[])new String[]{"1", "2.2"}).asBoolean());
        Assert.assertEquals((Object)1L, (Object)ExprEval.ofLongArray((Object[])new Long[]{1L}).castTo(ExpressionType.LONG).value());
        Assert.assertEquals(null, (Object)ExprEval.ofLongArray((Object[])new Long[]{null}).castTo(ExpressionType.LONG).value());
        Assert.assertEquals((double)1.0, (double)ExprEval.ofLongArray((Object[])new Long[]{1L}).castTo(ExpressionType.DOUBLE).asDouble(), (double)0.0);
        Assert.assertEquals((Object)"1", (Object)ExprEval.ofLongArray((Object[])new Long[]{1L}).castTo(ExpressionType.STRING).value());
        Assert.assertEquals((double)1.1, (double)ExprEval.ofDoubleArray((Object[])new Double[]{1.1}).castTo(ExpressionType.DOUBLE).asDouble(), (double)0.0);
        Assert.assertEquals(null, (Object)ExprEval.ofDoubleArray((Object[])new Double[]{null}).castTo(ExpressionType.DOUBLE).value());
        Assert.assertEquals((Object)1L, (Object)ExprEval.ofDoubleArray((Object[])new Double[]{1.1}).castTo(ExpressionType.LONG).value());
        Assert.assertEquals((Object)"1.1", (Object)ExprEval.ofDoubleArray((Object[])new Double[]{1.1}).castTo(ExpressionType.STRING).value());
        Assert.assertEquals((Object)"foo", (Object)ExprEval.ofStringArray((Object[])new String[]{"foo"}).castTo(ExpressionType.STRING).value());
        Assert.assertEquals(null, (Object)ExprEval.ofStringArray((Object[])new String[]{"foo"}).castTo(ExpressionType.LONG).value());
        Assert.assertEquals(null, (Object)ExprEval.ofStringArray((Object[])new String[]{"foo"}).castTo(ExpressionType.DOUBLE).value());
        Assert.assertEquals((Object)"1", (Object)ExprEval.ofStringArray((Object[])new String[]{"1"}).castTo(ExpressionType.STRING).value());
        Assert.assertEquals((Object)1L, (Object)ExprEval.ofStringArray((Object[])new String[]{"1"}).castTo(ExpressionType.LONG).value());
        Assert.assertEquals((Object)1.0, (Object)ExprEval.ofStringArray((Object[])new String[]{"1"}).castTo(ExpressionType.DOUBLE).value());
    }

    @Test
    public void testStringArrayToScalarStringBadCast() {
        Throwable t = Assert.assertThrows(IAE.class, () -> ExprEval.ofStringArray((Object[])new String[]{"foo", "bar"}).castTo(ExpressionType.STRING));
        Assert.assertEquals((Object)"Invalid type, cannot cast [ARRAY<STRING>] to [STRING]", (Object)t.getMessage());
    }

    @Test
    public void testStringArrayToScalarLongBadCast() {
        Throwable t = Assert.assertThrows(IAE.class, () -> ExprEval.ofStringArray((Object[])new String[]{"foo", "bar"}).castTo(ExpressionType.LONG));
        Assert.assertEquals((Object)"Invalid type, cannot cast [ARRAY<STRING>] to [LONG]", (Object)t.getMessage());
    }

    @Test
    public void testStringArrayToScalarDoubleBadCast() {
        Throwable t = Assert.assertThrows(IAE.class, () -> ExprEval.ofStringArray((Object[])new String[]{"foo", "bar"}).castTo(ExpressionType.DOUBLE));
        Assert.assertEquals((Object)"Invalid type, cannot cast [ARRAY<STRING>] to [DOUBLE]", (Object)t.getMessage());
    }

    @Test
    public void testLongArrayToScalarStringBadCast() {
        Throwable t = Assert.assertThrows(IAE.class, () -> ExprEval.ofLongArray((Object[])new Long[]{1L, 2L}).castTo(ExpressionType.STRING));
        Assert.assertEquals((Object)"Invalid type, cannot cast [ARRAY<LONG>] to [STRING]", (Object)t.getMessage());
    }

    @Test
    public void testLongArrayToScalarLongBadCast() {
        Throwable t = Assert.assertThrows(IAE.class, () -> ExprEval.ofLongArray((Object[])new Long[]{1L, 2L}).castTo(ExpressionType.LONG));
        Assert.assertEquals((Object)"Invalid type, cannot cast [ARRAY<LONG>] to [LONG]", (Object)t.getMessage());
    }

    @Test
    public void testLongArrayToScalarDoubleBadCast() {
        Throwable t = Assert.assertThrows(IAE.class, () -> ExprEval.ofLongArray((Object[])new Long[]{1L, 2L}).castTo(ExpressionType.DOUBLE));
        Assert.assertEquals((Object)"Invalid type, cannot cast [ARRAY<LONG>] to [DOUBLE]", (Object)t.getMessage());
    }

    @Test
    public void testDoubleArrayToScalarStringBadCast() {
        Throwable t = Assert.assertThrows(IAE.class, () -> ExprEval.ofDoubleArray((Object[])new Double[]{1.1, 2.2}).castTo(ExpressionType.STRING));
        Assert.assertEquals((Object)"Invalid type, cannot cast [ARRAY<DOUBLE>] to [STRING]", (Object)t.getMessage());
    }

    @Test
    public void testDoubleArrayToScalarLongBadCast() {
        Throwable t = Assert.assertThrows(IAE.class, () -> ExprEval.ofDoubleArray((Object[])new Double[]{1.1, 2.2}).castTo(ExpressionType.LONG));
        Assert.assertEquals((Object)"Invalid type, cannot cast [ARRAY<DOUBLE>] to [LONG]", (Object)t.getMessage());
    }

    @Test
    public void testDoubleArrayToScalarDoubleBadCast() {
        Throwable t = Assert.assertThrows(IAE.class, () -> ExprEval.ofDoubleArray((Object[])new Double[]{1.1, 2.2}).castTo(ExpressionType.DOUBLE));
        Assert.assertEquals((Object)"Invalid type, cannot cast [ARRAY<DOUBLE>] to [DOUBLE]", (Object)t.getMessage());
    }

    @Test
    public void testNestedDataCast() {
        ExprEval cast = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)"hello").castTo(ExpressionType.STRING);
        Assert.assertEquals((Object)"hello", (Object)cast.value());
        Assert.assertEquals((Object)"hello", (Object)ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)"hello").asString());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)cast.type());
        cast = ExprEval.of((String)"hello").castTo(ExpressionType.NESTED_DATA);
        Assert.assertEquals((Object)"hello", (Object)cast.value());
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)cast.type());
        cast = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)123L).castTo(ExpressionType.STRING);
        Assert.assertEquals((Object)"123", (Object)cast.value());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)cast.type());
        cast = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)123L).castTo(ExpressionType.LONG);
        Assert.assertEquals((Object)123L, (Object)cast.value());
        Assert.assertEquals((long)123L, (long)ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)123L).asLong());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)cast.type());
        cast = ExprEval.of((long)123L).castTo(ExpressionType.NESTED_DATA);
        Assert.assertEquals((Object)123L, (Object)cast.value());
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)cast.type());
        cast = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)123L).castTo(ExpressionType.DOUBLE);
        Assert.assertEquals((Object)123.0, (Object)cast.value());
        Assert.assertEquals((double)123.0, (double)ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)123L).asDouble(), (double)0.0);
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)cast.type());
        cast = ExprEval.of((double)12.3).castTo(ExpressionType.NESTED_DATA);
        Assert.assertEquals((Object)12.3, (Object)cast.value());
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)cast.type());
        cast = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")).castTo(ExpressionType.STRING_ARRAY);
        Assert.assertArrayEquals((Object[])new Object[]{"a", "b", "c"}, (Object[])((Object[])cast.value()));
        Assert.assertArrayEquals((Object[])new Object[]{"a", "b", "c"}, (Object[])ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")).asArray());
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)cast.type());
        cast = ExprEval.ofArray((ExpressionType)ExpressionType.STRING_ARRAY, (Object[])new Object[]{"a", "b", "c"}).castTo(ExpressionType.NESTED_DATA);
        Assert.assertArrayEquals((Object[])new Object[]{"a", "b", "c"}, (Object[])((Object[])cast.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)cast.type());
        cast = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)).castTo(ExpressionType.LONG_ARRAY);
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, 3L}, (Object[])((Object[])cast.value()));
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, 3L}, (Object[])ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)).asArray());
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)cast.type());
        cast = ExprEval.ofArray((ExpressionType)ExpressionType.LONG_ARRAY, (Object[])new Object[]{1L, 2L, 3L}).castTo(ExpressionType.NESTED_DATA);
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, 3L}, (Object[])((Object[])cast.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)cast.type());
        cast = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)).castTo(ExpressionType.DOUBLE_ARRAY);
        Assert.assertArrayEquals((Object[])new Object[]{1.0, 2.0, 3.0}, (Object[])((Object[])cast.value()));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)cast.type());
        cast = ExprEval.ofArray((ExpressionType)ExpressionType.DOUBLE_ARRAY, (Object[])new Object[]{1.1, 2.2, 3.3}).castTo(ExpressionType.NESTED_DATA);
        Assert.assertArrayEquals((Object[])new Object[]{1.1, 2.2, 3.3}, (Object[])((Object[])cast.value()));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)cast.type());
        ExpressionType nestedArray = ExpressionTypeFactory.getInstance().ofArray(ExpressionType.NESTED_DATA);
        cast = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"x", (Object)1, (Object)"y", (Object)2), (Object)ImmutableMap.of((Object)"x", (Object)3, (Object)"y", (Object)4))).castTo(nestedArray);
        Assert.assertArrayEquals((Object[])new Object[]{ImmutableMap.of((Object)"x", (Object)1, (Object)"y", (Object)2), ImmutableMap.of((Object)"x", (Object)3, (Object)"y", (Object)4)}, (Object[])((Object[])cast.value()));
        Assert.assertEquals((Object)nestedArray, (Object)cast.type());
        Assert.assertArrayEquals((Object[])new Object[]{ImmutableMap.of((Object)"x", (Object)1, (Object)"y", (Object)2), ImmutableMap.of((Object)"x", (Object)3, (Object)"y", (Object)4)}, (Object[])ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"x", (Object)1, (Object)"y", (Object)2), (Object)ImmutableMap.of((Object)"x", (Object)3, (Object)"y", (Object)4))).asArray());
        cast = ExprEval.ofLong((Number)1234L).castTo(nestedArray);
        Assert.assertEquals((Object)nestedArray, (Object)cast.type());
        Assert.assertArrayEquals((Object[])new Object[]{1234L}, (Object[])cast.asArray());
        cast = ExprEval.of((String)"hello").castTo(nestedArray);
        Assert.assertEquals((Object)nestedArray, (Object)cast.type());
        Assert.assertArrayEquals((Object[])new Object[]{"hello"}, (Object[])cast.asArray());
        cast = ExprEval.ofDouble((Number)1.234).castTo(nestedArray);
        Assert.assertEquals((Object)nestedArray, (Object)cast.type());
        Assert.assertArrayEquals((Object[])new Object[]{1.234}, (Object[])cast.asArray());
        cast = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)1234L).castTo(nestedArray);
        Assert.assertArrayEquals((Object[])new Object[]{1234L}, (Object[])cast.asArray());
        Assert.assertEquals((Object)nestedArray, (Object)cast.type());
    }

    @Test
    public void testNestedAsOtherStuff() {
        ExprEval eval = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)StructuredData.wrap((Object)true));
        Assert.assertTrue((boolean)eval.asBoolean());
        Assert.assertFalse((boolean)eval.isNumericNull());
        Assert.assertEquals((long)1L, (long)eval.asInt());
        Assert.assertEquals((long)1L, (long)eval.asLong());
        Assert.assertEquals((double)1.0, (double)eval.asDouble(), (double)0.0);
        Assert.assertTrue((boolean)ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)true).asBoolean());
        eval = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)false);
        Assert.assertFalse((boolean)eval.asBoolean());
        Assert.assertFalse((boolean)eval.isNumericNull());
        Assert.assertEquals((long)0L, (long)eval.asInt());
        Assert.assertEquals((long)0L, (long)eval.asLong());
        Assert.assertEquals((double)0.0, (double)eval.asDouble(), (double)0.0);
        eval = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)"true");
        Assert.assertTrue((boolean)eval.asBoolean());
        Assert.assertFalse((boolean)eval.isNumericNull());
        Assert.assertEquals((long)1L, (long)eval.asLong());
        Assert.assertEquals((long)1L, (long)eval.asInt());
        Assert.assertEquals((double)1.0, (double)eval.asDouble(), (double)0.0);
        Assert.assertTrue((boolean)ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)StructuredData.wrap((Object)"true")).asBoolean());
        Assert.assertTrue((boolean)ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)"TRUE").asBoolean());
        Assert.assertTrue((boolean)ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)"True").asBoolean());
        eval = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)StructuredData.wrap((Object)1L));
        Assert.assertTrue((boolean)eval.asBoolean());
        Assert.assertFalse((boolean)eval.isNumericNull());
        Assert.assertEquals((long)1L, (long)eval.asLong());
        Assert.assertEquals((long)1L, (long)eval.asInt());
        Assert.assertEquals((double)1.0, (double)eval.asDouble(), (double)0.0);
        Assert.assertTrue((boolean)ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)1L).asBoolean());
        eval = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)StructuredData.wrap((Object)1.23));
        Assert.assertTrue((boolean)eval.asBoolean());
        Assert.assertFalse((boolean)eval.isNumericNull());
        Assert.assertEquals((long)1L, (long)eval.asLong());
        Assert.assertEquals((long)1L, (long)eval.asInt());
        Assert.assertEquals((double)1.23, (double)eval.asDouble(), (double)0.0);
        eval = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)"hello");
        Assert.assertFalse((boolean)eval.asBoolean());
        Assert.assertTrue((boolean)eval.isNumericNull());
        Assert.assertEquals((long)0L, (long)eval.asInt());
        Assert.assertEquals((long)0L, (long)eval.asLong());
        Assert.assertEquals((double)0.0, (double)eval.asDouble(), (double)0.0);
        eval = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, Arrays.asList("1", "2", "3"));
        Assert.assertFalse((boolean)eval.asBoolean());
        Assert.assertTrue((boolean)eval.isNumericNull());
        Assert.assertEquals((long)0L, (long)eval.asInt());
        Assert.assertEquals((long)0L, (long)eval.asLong());
        Assert.assertEquals((double)0.0, (double)eval.asDouble(), (double)0.0);
        Assert.assertArrayEquals((Object[])new Object[]{"1", "2", "3"}, (Object[])eval.asArray());
        eval = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, Arrays.asList(1L, 2L, 3L));
        Assert.assertFalse((boolean)eval.asBoolean());
        Assert.assertTrue((boolean)eval.isNumericNull());
        Assert.assertEquals((long)0L, (long)eval.asInt());
        Assert.assertEquals((long)0L, (long)eval.asLong());
        Assert.assertEquals((double)0.0, (double)eval.asDouble(), (double)0.0);
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, 3L}, (Object[])eval.asArray());
        eval = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, Arrays.asList(1.1, 2.2, 3.3));
        Assert.assertFalse((boolean)eval.asBoolean());
        Assert.assertTrue((boolean)eval.isNumericNull());
        Assert.assertEquals((long)0L, (long)eval.asInt());
        Assert.assertEquals((long)0L, (long)eval.asLong());
        Assert.assertEquals((double)0.0, (double)eval.asDouble(), (double)0.0);
        Assert.assertArrayEquals((Object[])new Object[]{1.1, 2.2, 3.3}, (Object[])eval.asArray());
        eval = ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"x", (Object)1, (Object)"y", (Object)2), (Object)ImmutableMap.of((Object)"x", (Object)3, (Object)"y", (Object)4)));
        Assert.assertFalse((boolean)eval.asBoolean());
        Assert.assertEquals((long)0L, (long)eval.asLong());
        Assert.assertEquals((long)0L, (long)eval.asInt());
        Assert.assertEquals((double)0.0, (double)eval.asDouble(), (double)0.0);
    }

    @Test
    public void testNonNestedComplexCastThrows() {
        ExpressionType someComplex = ExpressionTypeFactory.getInstance().ofComplex("tester");
        Throwable t = Assert.assertThrows(IllegalArgumentException.class, () -> ExprEval.ofType((ExpressionType)someComplex, (Object)"hello").castTo(ExpressionType.STRING));
        Assert.assertEquals((Object)"Invalid type, cannot cast [COMPLEX<tester>] to [STRING]", (Object)t.getMessage());
        t = Assert.assertThrows(IllegalArgumentException.class, () -> ExprEval.ofType((ExpressionType)someComplex, (Object)"hello").castTo(ExpressionType.LONG));
        Assert.assertEquals((Object)"Invalid type, cannot cast [COMPLEX<tester>] to [LONG]", (Object)t.getMessage());
        t = Assert.assertThrows(IllegalArgumentException.class, () -> ExprEval.ofType((ExpressionType)someComplex, (Object)"hello").castTo(ExpressionType.DOUBLE));
        Assert.assertEquals((Object)"Invalid type, cannot cast [COMPLEX<tester>] to [DOUBLE]", (Object)t.getMessage());
        t = Assert.assertThrows(IllegalArgumentException.class, () -> ExprEval.ofType((ExpressionType)someComplex, (Object)"hello").castTo(ExpressionType.STRING_ARRAY));
        Assert.assertEquals((Object)"Invalid type, cannot cast [COMPLEX<tester>] to [ARRAY<STRING>]", (Object)t.getMessage());
        t = Assert.assertThrows(IllegalArgumentException.class, () -> ExprEval.ofType((ExpressionType)someComplex, (Object)"hello").castTo(ExpressionType.LONG_ARRAY));
        Assert.assertEquals((Object)"Invalid type, cannot cast [COMPLEX<tester>] to [ARRAY<LONG>]", (Object)t.getMessage());
        t = Assert.assertThrows(IllegalArgumentException.class, () -> ExprEval.ofType((ExpressionType)someComplex, (Object)"hello").castTo(ExpressionType.DOUBLE_ARRAY));
        Assert.assertEquals((Object)"Invalid type, cannot cast [COMPLEX<tester>] to [ARRAY<DOUBLE>]", (Object)t.getMessage());
        t = Assert.assertThrows(IllegalArgumentException.class, () -> ExprEval.ofType((ExpressionType)someComplex, (Object)"hello").castTo(ExpressionType.NESTED_DATA));
        Assert.assertEquals((Object)"Invalid type, cannot cast [COMPLEX<tester>] to [COMPLEX<json>]", (Object)t.getMessage());
        t = Assert.assertThrows(IllegalArgumentException.class, () -> ExprEval.of((String)"hello").castTo(someComplex));
        Assert.assertEquals((Object)"Invalid type, cannot cast [STRING] to [COMPLEX<tester>]", (Object)t.getMessage());
        t = Assert.assertThrows(IllegalArgumentException.class, () -> ExprEval.of((long)123L).castTo(someComplex));
        Assert.assertEquals((Object)"Invalid type, cannot cast [LONG] to [COMPLEX<tester>]", (Object)t.getMessage());
        t = Assert.assertThrows(IllegalArgumentException.class, () -> ExprEval.of((double)1.23).castTo(someComplex));
        Assert.assertEquals((Object)"Invalid type, cannot cast [DOUBLE] to [COMPLEX<tester>]", (Object)t.getMessage());
        t = Assert.assertThrows(IllegalArgumentException.class, () -> ExprEval.ofStringArray((Object[])new Object[]{"a", "b", "c"}).castTo(someComplex));
        Assert.assertEquals((Object)"Invalid type, cannot cast [ARRAY<STRING>] to [COMPLEX<tester>]", (Object)t.getMessage());
        t = Assert.assertThrows(IllegalArgumentException.class, () -> ExprEval.ofLongArray((Object[])new Object[]{1L, 2L, 3L}).castTo(someComplex));
        Assert.assertEquals((Object)"Invalid type, cannot cast [ARRAY<LONG>] to [COMPLEX<tester>]", (Object)t.getMessage());
        t = Assert.assertThrows(IllegalArgumentException.class, () -> ExprEval.ofDoubleArray((Object[])new Object[]{1.1, 2.2, 3.3}).castTo(someComplex));
        Assert.assertEquals((Object)"Invalid type, cannot cast [ARRAY<DOUBLE>] to [COMPLEX<tester>]", (Object)t.getMessage());
        t = Assert.assertThrows(IllegalArgumentException.class, () -> ExprEval.ofComplex((ExpressionType)ExpressionType.NESTED_DATA, (Object)ImmutableMap.of((Object)"x", (Object)1L)).castTo(someComplex));
        Assert.assertEquals((Object)"Invalid type, cannot cast [COMPLEX<json>] to [COMPLEX<tester>]", (Object)t.getMessage());
    }

    @Test
    public void testIsNumericNull() {
        Assert.assertFalse((boolean)ExprEval.ofLong((Number)1L).isNumericNull());
        Assert.assertTrue((boolean)ExprEval.ofLong(null).isNumericNull());
        Assert.assertFalse((boolean)ExprEval.ofDouble((Number)1.0).isNumericNull());
        Assert.assertTrue((boolean)ExprEval.ofDouble(null).isNumericNull());
        Assert.assertTrue((boolean)ExprEval.of(null).isNumericNull());
        Assert.assertTrue((boolean)ExprEval.of((String)"one").isNumericNull());
        Assert.assertFalse((boolean)ExprEval.of((String)"1").isNumericNull());
        Assert.assertFalse((boolean)ExprEval.ofLongArray((Object[])new Long[]{1L}).isNumericNull());
        Assert.assertTrue((boolean)ExprEval.ofLongArray((Object[])new Long[]{null, 2L, 3L}).isNumericNull());
        Assert.assertTrue((boolean)ExprEval.ofLongArray((Object[])new Long[]{null}).isNumericNull());
        Assert.assertFalse((boolean)ExprEval.ofDoubleArray((Object[])new Double[]{1.1}).isNumericNull());
        Assert.assertTrue((boolean)ExprEval.ofDoubleArray((Object[])new Double[]{null, 1.1, 2.2}).isNumericNull());
        Assert.assertTrue((boolean)ExprEval.ofDoubleArray((Object[])new Double[]{null}).isNumericNull());
        Assert.assertFalse((boolean)ExprEval.ofStringArray((Object[])new String[]{"1"}).isNumericNull());
        Assert.assertTrue((boolean)ExprEval.ofStringArray((Object[])new String[]{null, "1", "2"}).isNumericNull());
        Assert.assertTrue((boolean)ExprEval.ofStringArray((Object[])new String[]{"one"}).isNumericNull());
        Assert.assertTrue((boolean)ExprEval.ofStringArray((Object[])new String[]{null}).isNumericNull());
    }

    @Test
    public void testBooleanReturn() {
        Expr.ObjectBinding bindings = InputBindings.forMap((Map)ImmutableMap.of((Object)"x", (Object)100L, (Object)"y", (Object)100L, (Object)"z", (Object)100.0, (Object)"w", (Object)100.0));
        ExprEval eval = Parser.parse((String)"x==y", (ExprMacroTable)ExprMacroTable.nil()).eval(bindings);
        Assert.assertTrue((boolean)eval.asBoolean());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        eval = Parser.parse((String)"x!=y", (ExprMacroTable)ExprMacroTable.nil()).eval(bindings);
        Assert.assertFalse((boolean)eval.asBoolean());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        eval = Parser.parse((String)"x==z", (ExprMacroTable)ExprMacroTable.nil()).eval(bindings);
        Assert.assertTrue((boolean)eval.asBoolean());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        eval = Parser.parse((String)"x!=z", (ExprMacroTable)ExprMacroTable.nil()).eval(bindings);
        Assert.assertFalse((boolean)eval.asBoolean());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        eval = Parser.parse((String)"z==w", (ExprMacroTable)ExprMacroTable.nil()).eval(bindings);
        Assert.assertTrue((boolean)eval.asBoolean());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        eval = Parser.parse((String)"z!=w", (ExprMacroTable)ExprMacroTable.nil()).eval(bindings);
        Assert.assertFalse((boolean)eval.asBoolean());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
    }

    @Test
    public void testLogicalOperators() {
        Expr.ObjectBinding bindings = InputBindings.nilBindings();
        Assert.assertEquals((Object)1L, (Object)this.eval("'true' && 'true'", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("'true' && 'false'", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("'false' && 'true'", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("'troo' && 'true'", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("'false' && 'false'", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("'true' || 'true'", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("'true' || 'false'", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("'false' || 'true'", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("'troo' || 'true'", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("'false' || 'false'", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("1 && 1", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("100 && 11", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("1 && 0", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("0 && 1", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("0 && 0", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("1 || 1", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("100 || 11", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("1 || 0", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("0 || 1", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("111 || 0", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("0 || 111", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("0 || 0", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("1.0 && 1.0", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("0.100 && 1.1", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("1.0 && 0.0", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("0.0 && 1.0", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("0.0 && 0.0", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("1.0 || 1.0", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("0.2 || 0.3", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("1.0 || 0.0", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("0.0 || 1.0", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("1.11 || 0.0", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("0.0 || 0.111", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("0.0 || 0.0", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("null || 1", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("1 || null", bindings).value());
        Assert.assertNull((Object)this.eval("null || 0", bindings).valueOrDefault());
        Assert.assertNull((Object)this.eval("0 || null", bindings).valueOrDefault());
        Assert.assertNull((Object)this.eval("null || null", bindings).valueOrDefault());
        Assert.assertNull((Object)this.eval("null && 1", bindings).valueOrDefault());
        Assert.assertNull((Object)this.eval("1 && null", bindings).valueOrDefault());
        Assert.assertNull((Object)this.eval("null && null", bindings).valueOrDefault());
        Assert.assertEquals((Object)0L, (Object)this.eval("null && 0", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("0 && null", bindings).value());
    }

    @Test
    public void testBooleanInputs() {
        HashMap<String, Object> bindingsMap = new HashMap<String, Object>();
        bindingsMap.put("l1", 100L);
        bindingsMap.put("l2", 0L);
        bindingsMap.put("d1", 1.1);
        bindingsMap.put("d2", 0.0);
        bindingsMap.put("s1", "true");
        bindingsMap.put("s2", "false");
        bindingsMap.put("b1", true);
        bindingsMap.put("b2", false);
        Expr.ObjectBinding bindings = InputBindings.forMap(bindingsMap);
        Assert.assertEquals((Object)1L, (Object)this.eval("s1 && s1", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("s1 && s2", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("s2 && s1", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("s2 && s2", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("s1 || s1", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("s1 || s2", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("s2 || s1", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("s2 || s2", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("l1 && l1", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("l1 && l2", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("l2 && l1", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("l2 && l2", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("b1 && b1", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("b1 && b2", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("b2 && b1", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("b2 && b2", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("d1 && d1", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("d1 && d2", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("d2 && d1", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("d2 && d2", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("b1", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("if(b1,1,0)", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("if(l1,1,0)", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("if(d1,1,0)", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("if(s1,1,0)", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("if(b2,1,0)", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("if(l2,1,0)", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("if(d2,1,0)", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("if(s2,1,0)", bindings).value());
    }

    @Test
    public void testArrayComparison() {
        Expr.ObjectBinding bindings = InputBindings.forInputSuppliers((Map)ImmutableMap.builder().put((Object)"stringArray", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING_ARRAY, () -> new Object[]{"a", "b", null, "c"})).put((Object)"longArray", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.LONG_ARRAY, () -> new Object[]{1L, null, 2L, 3L})).put((Object)"doubleArray", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.DOUBLE_ARRAY, () -> new Object[]{1.1, 2.2, 3.3, null})).build());
        Assert.assertEquals((Object)0L, (Object)this.eval("['a','b',null,'c'] > stringArray", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("['a','b',null,'c'] >= stringArray", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("['a','b',null,'c'] == stringArray", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("['a','b',null,'c'] != stringArray", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("notdistinctfrom(['a','b',null,'c'], stringArray)", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("isdistinctfrom(['a','b',null,'c'], stringArray)", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("['a','b',null,'c'] <= stringArray", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("['a','b',null,'c'] < stringArray", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("[1,null,2,3] > longArray", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("[1,null,2,3] >= longArray", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("[1,null,2,3] == longArray", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("[1,null,2,3] != longArray", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("notdistinctfrom([1,null,2,3], longArray)", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("isdistinctfrom([1,null,2,3], longArray)", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("[1,null,2,3] <= longArray", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("[1,null,2,3] < longArray", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("[1.1,2.2,3.3,null] > doubleArray", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("[1.1,2.2,3.3,null] >= doubleArray", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("[1.1,2.2,3.3,null] == doubleArray", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("[1.1,2.2,3.3,null] != doubleArray", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("notdistinctfrom([1.1,2.2,3.3,null], doubleArray)", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("isdistinctfrom([1.1,2.2,3.3,null], doubleArray)", bindings).value());
        Assert.assertEquals((Object)1L, (Object)this.eval("[1.1,2.2,3.3,null] <= doubleArray", bindings).value());
        Assert.assertEquals((Object)0L, (Object)this.eval("[1.1,2.2,3.3,null] < doubleArray", bindings).value());
    }

    @Test
    public void testValueOrDefault() {
        ExprEval longNull = ExprEval.ofLong(null);
        ExprEval doubleNull = ExprEval.ofDouble(null);
        Assert.assertTrue((boolean)longNull.isNumericNull());
        Assert.assertTrue((boolean)doubleNull.isNumericNull());
        Assert.assertNull(null, (Object)longNull.valueOrDefault());
        Assert.assertNull(null, (Object)doubleNull.valueOrDefault());
    }

    @Test
    public void testEvalOfType() {
        ExprEval eval = ExprEval.ofType((ExpressionType)ExpressionType.STRING, (Object)"stringy");
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)eval.type());
        Assert.assertEquals((Object)"stringy", (Object)eval.value());
        eval = ExprEval.ofType((ExpressionType)ExpressionType.STRING, (Object)1L);
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)eval.type());
        Assert.assertEquals((Object)"1", (Object)eval.value());
        eval = ExprEval.ofType((ExpressionType)ExpressionType.STRING, (Object)1.0);
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)eval.type());
        Assert.assertEquals((Object)"1.0", (Object)eval.value());
        eval = ExprEval.ofType((ExpressionType)ExpressionType.STRING, (Object)true);
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)eval.type());
        Assert.assertEquals((Object)"true", (Object)eval.value());
        eval = ExprEval.ofType((ExpressionType)ExpressionType.STRING, (Object)new Object[]{"a", "b", "c"});
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{"a", "b", "c"}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.STRING, (Object)new String[]{"a", "b", "c"});
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{"a", "b", "c"}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.STRING, Arrays.asList("a", "b", "c"));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{"a", "b", "c"}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG, (Object)1L);
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        Assert.assertEquals((Object)1L, (Object)eval.value());
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG, (Object)1.0);
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        Assert.assertEquals((Object)1L, (Object)eval.value());
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG, (Object)"1");
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        Assert.assertEquals((Object)1L, (Object)eval.value());
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG, (Object)true);
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        Assert.assertEquals((Object)1L, (Object)eval.value());
        eval = ExprEval.ofType((ExpressionType)ExpressionType.DOUBLE, (Object)1L);
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)eval.type());
        Assert.assertEquals((Object)1.0, (Object)eval.value());
        eval = ExprEval.ofType((ExpressionType)ExpressionType.DOUBLE, (Object)1.0);
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)eval.type());
        Assert.assertEquals((Object)1.0, (Object)eval.value());
        eval = ExprEval.ofType((ExpressionType)ExpressionType.DOUBLE, (Object)"1");
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)eval.type());
        Assert.assertEquals((Object)1.0, (Object)eval.value());
        eval = ExprEval.ofType((ExpressionType)ExpressionType.DOUBLE, (Object)true);
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)eval.type());
        Assert.assertEquals((Object)1.0, (Object)eval.value());
        TypeStrategiesTest.NullableLongPair pair = new TypeStrategiesTest.NullableLongPair(1L, 2L);
        ExpressionType type = ExpressionType.fromColumnType((TypeSignature)TypeStrategiesTest.NULLABLE_TEST_PAIR_TYPE);
        eval = ExprEval.ofType((ExpressionType)type, (Object)pair);
        Assert.assertEquals((Object)type, (Object)eval.type());
        Assert.assertEquals((Object)pair, (Object)eval.value());
        ByteBuffer buffer = ByteBuffer.allocate(TypeStrategiesTest.NULLABLE_TEST_PAIR_TYPE.getStrategy().estimateSizeBytes((Object)pair));
        TypeStrategiesTest.NULLABLE_TEST_PAIR_TYPE.getStrategy().write(buffer, (Object)pair, buffer.limit());
        byte[] pairBytes = buffer.array();
        eval = ExprEval.ofType((ExpressionType)type, (Object)pairBytes);
        Assert.assertEquals((Object)type, (Object)eval.type());
        Assert.assertEquals((Object)pair, (Object)eval.value());
        eval = ExprEval.ofType((ExpressionType)type, (Object)StringUtils.encodeBase64String((byte[])pairBytes));
        Assert.assertEquals((Object)type, (Object)eval.type());
        Assert.assertEquals((Object)pair, (Object)eval.value());
        eval = ExprEval.ofType((ExpressionType)ExpressionType.NESTED_DATA, (Object)ImmutableMap.of((Object)"x", (Object)1L, (Object)"y", (Object)2L));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)eval.type());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"x", (Object)1L, (Object)"y", (Object)2L), (Object)eval.value());
        ExpressionType stringyComplexThing = ExpressionType.fromString((String)"COMPLEX<somestringything>");
        eval = ExprEval.ofType((ExpressionType)stringyComplexThing, (Object)"notbase64");
        Assert.assertEquals((Object)stringyComplexThing, (Object)eval.type());
        Assert.assertEquals((Object)"notbase64", (Object)eval.value());
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG_ARRAY, (Object)new Object[]{1L, 2L, 3L});
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, 3L}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG_ARRAY, (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L));
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, 3L}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG_ARRAY, (Object)new Long[]{1L, 2L, 3L});
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, 3L}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG_ARRAY, (Object)new long[]{1L, 2L, 3L});
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, 3L}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG_ARRAY, (Object)new int[]{1, 2, 3});
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, 3L}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG_ARRAY, (Object)new Object[]{1L, 2L, null, 3L});
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, null, 3L}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG_ARRAY, (Object)new Object[]{"1", "2", "3"});
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, 3L}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG_ARRAY, (Object)new String[]{"1", "2", "3"});
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, 3L}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG_ARRAY, (Object)new Object[]{"1", "2", "wat", "3"});
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, null, 3L}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG_ARRAY, (Object)new Object[]{1.0, 2.0, 3.0});
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, 3L}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG_ARRAY, (Object)new double[]{1.0, 2.0, 3.0});
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, 3L}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG_ARRAY, (Object)new Object[]{1.0, 2.0, null, 3.0});
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, null, 3L}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG_ARRAY, (Object)new Object[]{1.0, 2L, "3", true, false});
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, 3L, 1L, 0L}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.LONG_ARRAY, (Object)new float[]{1.0f, 2.0f, 3.0f});
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, 3L}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.DOUBLE_ARRAY, (Object)new Object[]{1.0, 2.0, 3.0});
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1.0, 2.0, 3.0}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.DOUBLE_ARRAY, (Object)new Double[]{1.0, 2.0, 3.0});
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1.0, 2.0, 3.0}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.DOUBLE_ARRAY, (Object)new double[]{1.0, 2.0, 3.0});
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1.0, 2.0, 3.0}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.DOUBLE_ARRAY, (Object)new Object[]{"1", "2", "3"});
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1.0, 2.0, 3.0}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.DOUBLE_ARRAY, (Object)new Object[]{"1", "2", "wat", "3"});
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1.0, 2.0, null, 3.0}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.DOUBLE_ARRAY, (Object)new Object[]{1L, 2L, 3L});
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1.0, 2.0, 3.0}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.DOUBLE_ARRAY, (Object)new long[]{1L, 2L, 3L});
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1.0, 2.0, 3.0}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.DOUBLE_ARRAY, (Object)new Object[]{1L, 2L, null, 3L});
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1.0, 2.0, null, 3.0}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.DOUBLE_ARRAY, (Object)new Object[]{1.0, 2L, "3", true, false});
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1.0, 2.0, 3.0, 1.0, 0.0}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.DOUBLE_ARRAY, (Object)new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)});
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1.0, 2.0, 3.0}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.DOUBLE_ARRAY, (Object)new float[]{1.0f, 2.0f, 3.0f});
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{1.0, 2.0, 3.0}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.STRING_ARRAY, (Object)new Object[]{"1", "2", "3"});
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{"1", "2", "3"}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.STRING_ARRAY, (Object)new Object[]{1L, 2L, 3L});
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{"1", "2", "3"}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.STRING_ARRAY, (Object)new Object[]{1.0, 2.0, 3.0});
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{"1.0", "2.0", "3.0"}, (Object[])((Object[])eval.value()));
        eval = ExprEval.ofType((ExpressionType)ExpressionType.STRING_ARRAY, (Object)new Object[]{1.0, 2L, "3", true, false});
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{"1.0", "2", "3", "true", "false"}, (Object[])((Object[])eval.value()));
        ExpressionType nestedLongArray = ExpressionTypeFactory.getInstance().ofArray(ExpressionType.LONG_ARRAY);
        Object[] expectedLongArray = new Object[]{new Object[]{1L, 2L, 3L}, new Object[]{5L, null, 9L}, null, new Object[]{2L, 4L, 6L}};
        List<Object> longArrayInputs = Arrays.asList(new Object[]{new Object[]{1L, 2L, 3L}, new Object[]{5L, null, 9L}, null, new Object[]{2L, 4L, 6L}}, Arrays.asList({1L, 2L, 3L}, {5L, null, 9L}, null, {2L, 4L, 6L}), Arrays.asList(Arrays.asList(1L, 2L, 3L), Arrays.asList(5L, null, 9L), null, Arrays.asList(2L, 4L, 6L)), Arrays.asList(Arrays.asList(1L, 2L, 3L), Arrays.asList("5", "hello", "9"), null, new Object[]{2.2, 4.4, 6.6}));
        for (Object o : longArrayInputs) {
            eval = ExprEval.ofType((ExpressionType)nestedLongArray, (Object)o);
            Assert.assertEquals((Object)nestedLongArray, (Object)eval.type());
            Object[] val = (Object[])eval.value();
            Assert.assertEquals((long)expectedLongArray.length, (long)val.length);
            for (int i = 0; i < expectedLongArray.length; ++i) {
                Assert.assertArrayEquals((Object[])((Object[])expectedLongArray[i]), (Object[])((Object[])val[i]));
            }
        }
        ExpressionType nestedDoubleArray = ExpressionTypeFactory.getInstance().ofArray(ExpressionType.DOUBLE_ARRAY);
        Object[] expectedDoubleArray = new Object[]{new Object[]{1.1, 2.2, 3.3}, new Object[]{5.5, null, 9.9}, null, new Object[]{2.2, 4.4, 6.6}};
        List<Object> doubleArrayInputs = Arrays.asList(new Object[]{new Object[]{1.1, 2.2, 3.3}, new Object[]{5.5, null, 9.9}, null, new Object[]{2.2, 4.4, 6.6}}, new Object[]{Arrays.asList(1.1, 2.2, 3.3), Arrays.asList(5.5, null, 9.9), null, Arrays.asList(2.2, 4.4, 6.6)}, Arrays.asList(Arrays.asList(1.1, 2.2, 3.3), Arrays.asList(5.5, null, 9.9), null, Arrays.asList(2.2, 4.4, 6.6)), new Object[]{new Object[]{"1.1", "2.2", "3.3"}, Arrays.asList("5.5", null, "9.9"), null, new String[]{"2.2", "4.4", "6.6"}});
        for (Object o : doubleArrayInputs) {
            eval = ExprEval.ofType((ExpressionType)nestedDoubleArray, (Object)o);
            Assert.assertEquals((Object)nestedDoubleArray, (Object)eval.type());
            Object[] val = (Object[])eval.value();
            Assert.assertEquals((long)expectedLongArray.length, (long)val.length);
            for (int i = 0; i < expectedLongArray.length; ++i) {
                Assert.assertArrayEquals((Object[])((Object[])expectedDoubleArray[i]), (Object[])((Object[])val[i]));
            }
        }
    }

    @Test
    public void testBestEffortOf() {
        this.assertBestEffortOf("stringy", ExpressionType.STRING, "stringy");
        this.assertBestEffortOf(new byte[]{1, 2, 3, 4}, ExpressionType.STRING, StringUtils.encodeBase64String((byte[])new byte[]{1, 2, 3, 4}));
        this.assertBestEffortOf(1L, ExpressionType.LONG, 1L);
        this.assertBestEffortOf(1, ExpressionType.LONG, 1L);
        this.assertBestEffortOf(true, ExpressionType.LONG, 1L);
        this.assertBestEffortOf(Arrays.asList(true, false), ExpressionType.LONG_ARRAY, new Object[]{1L, 0L});
        this.assertBestEffortOf(1.0, ExpressionType.DOUBLE, 1.0);
        this.assertBestEffortOf(Float.valueOf(1.0f), ExpressionType.DOUBLE, 1.0);
        this.assertBestEffortOf(new Object[]{1L, 2L, 3L}, ExpressionType.LONG_ARRAY, new Object[]{1L, 2L, 3L});
        this.assertBestEffortOf(new Object[]{1L, 2L, null, 3L}, ExpressionType.LONG_ARRAY, new Object[]{1L, 2L, null, 3L});
        this.assertBestEffortOf(ImmutableList.of((Object)1L, (Object)2L, (Object)3L), ExpressionType.LONG_ARRAY, new Object[]{1L, 2L, 3L});
        this.assertBestEffortOf(new long[]{1L, 2L, 3L}, ExpressionType.LONG_ARRAY, new Object[]{1L, 2L, 3L});
        this.assertBestEffortOf(new Object[]{1, 2, 3}, ExpressionType.LONG_ARRAY, new Object[]{1L, 2L, 3L});
        this.assertBestEffortOf(new Integer[]{1, 2, 3}, ExpressionType.LONG_ARRAY, new Object[]{1L, 2L, 3L});
        this.assertBestEffortOf(new int[]{1, 2, 3}, ExpressionType.LONG_ARRAY, new Object[]{1L, 2L, 3L});
        this.assertBestEffortOf(new Object[]{1.0, 2.0, 3.0}, ExpressionType.DOUBLE_ARRAY, new Object[]{1.0, 2.0, 3.0});
        this.assertBestEffortOf(new Object[]{null, 1.0, 2.0, 3.0}, ExpressionType.DOUBLE_ARRAY, new Object[]{null, 1.0, 2.0, 3.0});
        this.assertBestEffortOf(new Double[]{1.0, 2.0, 3.0}, ExpressionType.DOUBLE_ARRAY, new Object[]{1.0, 2.0, 3.0});
        this.assertBestEffortOf(new double[]{1.0, 2.0, 3.0}, ExpressionType.DOUBLE_ARRAY, new Object[]{1.0, 2.0, 3.0});
        this.assertBestEffortOf(new Object[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)}, ExpressionType.DOUBLE_ARRAY, new Object[]{1.0, 2.0, 3.0});
        this.assertBestEffortOf(new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)}, ExpressionType.DOUBLE_ARRAY, new Object[]{1.0, 2.0, 3.0});
        this.assertBestEffortOf(new float[]{1.0f, 2.0f, 3.0f}, ExpressionType.DOUBLE_ARRAY, new Object[]{1.0, 2.0, 3.0});
        this.assertBestEffortOf(new Object[]{"1", "2", "3"}, ExpressionType.STRING_ARRAY, new Object[]{"1", "2", "3"});
        this.assertBestEffortOf(new String[]{"1", "2", "3"}, ExpressionType.STRING_ARRAY, new Object[]{"1", "2", "3"});
        this.assertBestEffortOf(ImmutableList.of((Object)"1", (Object)"2", (Object)"3"), ExpressionType.STRING_ARRAY, new Object[]{"1", "2", "3"});
        this.assertBestEffortOf(new Object[]{1.0, 2L}, ExpressionType.DOUBLE_ARRAY, new Object[]{1.0, 2.0});
        this.assertBestEffortOf(new Object[]{1.0, 2L, "3", true, false}, ExpressionType.STRING_ARRAY, new Object[]{"1.0", "2", "3", "true", "false"});
        this.assertBestEffortOf(ImmutableMap.of((Object)"x", (Object)1L, (Object)"y", (Object)2L), ExpressionType.NESTED_DATA, ImmutableMap.of((Object)"x", (Object)1L, (Object)"y", (Object)2L));
        SerializablePair someOtherComplex = new SerializablePair((Object)"hello", (Object)1234L);
        this.assertBestEffortOf(someOtherComplex, ExpressionType.UNKNOWN_COMPLEX, someOtherComplex);
    }

    private void assertBestEffortOf(@Nullable Object val, ExpressionType expectedType, @Nullable Object expectedValue) {
        ExprEval eval = ExprEval.bestEffortOf((Object)val);
        Assert.assertEquals((Object)expectedType, (Object)eval.type());
        if (eval.type().isArray()) {
            Assert.assertArrayEquals((Object[])((Object[])expectedValue), (Object[])eval.asArray());
        } else {
            Assert.assertEquals((Object)expectedValue, (Object)eval.value());
        }
        eval = ExprEval.ofType((ExpressionType)eval.type(), (Object)val);
        Assert.assertEquals((Object)expectedType, (Object)eval.type());
        if (eval.type().isArray()) {
            Assert.assertArrayEquals((Object[])((Object[])expectedValue), (Object[])eval.asArray());
        } else {
            Assert.assertEquals((Object)expectedValue, (Object)eval.value());
        }
    }
}

