/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.math.expr.ApplyFunctionExpr;
import org.apache.druid.math.expr.ArrayExpr;
import org.apache.druid.math.expr.BinAndExpr;
import org.apache.druid.math.expr.BinDivExpr;
import org.apache.druid.math.expr.BinEqExpr;
import org.apache.druid.math.expr.BinGeqExpr;
import org.apache.druid.math.expr.BinGtExpr;
import org.apache.druid.math.expr.BinLtExpr;
import org.apache.druid.math.expr.BinMinusExpr;
import org.apache.druid.math.expr.BinModuloExpr;
import org.apache.druid.math.expr.BinMulExpr;
import org.apache.druid.math.expr.BinNeqExpr;
import org.apache.druid.math.expr.BinOrExpr;
import org.apache.druid.math.expr.BinPlusExpr;
import org.apache.druid.math.expr.BinPowExpr;
import org.apache.druid.math.expr.ComplexExpr;
import org.apache.druid.math.expr.DoubleExpr;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionTypeFactory;
import org.apache.druid.math.expr.FunctionExpr;
import org.apache.druid.math.expr.IdentifierExpr;
import org.apache.druid.math.expr.LambdaExpr;
import org.apache.druid.math.expr.LongExpr;
import org.apache.druid.math.expr.NullDoubleExpr;
import org.apache.druid.math.expr.NullLongExpr;
import org.apache.druid.math.expr.StringExpr;
import org.apache.druid.math.expr.UnaryMinusExpr;
import org.apache.druid.math.expr.UnaryNotExpr;
import org.junit.Assert;
import org.junit.Test;

public class ExprTest {
    @Test
    public void testEqualsContractForBinOrExpr() {
        EqualsVerifier.forClass(BinOrExpr.class).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForBinGtExpr() {
        EqualsVerifier.forClass(BinGtExpr.class).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForBinMinusExpr() {
        EqualsVerifier.forClass(BinMinusExpr.class).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForBinPowExpr() {
        EqualsVerifier.forClass(BinPowExpr.class).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForBinMulExpr() {
        EqualsVerifier.forClass(BinMulExpr.class).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForBinDivExpr() {
        EqualsVerifier.forClass(BinDivExpr.class).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForBinModuloExpr() {
        EqualsVerifier.forClass(BinModuloExpr.class).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForBinPlusExpr() {
        EqualsVerifier.forClass(BinPlusExpr.class).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForBinLtExpr() {
        EqualsVerifier.forClass(BinLtExpr.class).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForBinGeqExpr() {
        EqualsVerifier.forClass(BinGeqExpr.class).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForBinEqExpr() {
        EqualsVerifier.forClass(BinEqExpr.class).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForBinNeqExpr() {
        EqualsVerifier.forClass(BinNeqExpr.class).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForBinAndExpr() {
        EqualsVerifier.forClass(BinAndExpr.class).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForFunctionExpr() {
        EqualsVerifier.forClass(FunctionExpr.class).usingGetClass().withIgnoredFields(new String[]{"function"}).verify();
    }

    @Test
    public void testEqualsContractForApplyFunctionExpr() {
        EqualsVerifier.forClass(ApplyFunctionExpr.class).usingGetClass().withIgnoredFields(new String[]{"function", "bindingAnalysis", "lambdaBindingAnalysis", "argsBindingAnalyses"}).verify();
    }

    @Test
    public void testEqualsContractForUnaryNotExpr() {
        EqualsVerifier.forClass(UnaryNotExpr.class).withIgnoredFields(new String[]{"op"}).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForUnaryMinusExpr() {
        EqualsVerifier.forClass(UnaryMinusExpr.class).withIgnoredFields(new String[]{"op"}).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForStringExpr() {
        EqualsVerifier.forClass(StringExpr.class).withIgnoredFields(new String[]{"outputType"}).withPrefabValues(ExpressionType.class, (Object)ExpressionType.STRING, (Object)ExpressionType.DOUBLE).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForDoubleExpr() {
        EqualsVerifier.forClass(DoubleExpr.class).withIgnoredFields(new String[]{"outputType"}).withPrefabValues(ExpressionType.class, (Object)ExpressionType.DOUBLE, (Object)ExpressionType.LONG).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForLongExpr() {
        EqualsVerifier.forClass(LongExpr.class).withIgnoredFields(new String[]{"outputType"}).withPrefabValues(ExpressionType.class, (Object)ExpressionType.LONG, (Object)ExpressionType.STRING).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForArrayExpr() {
        EqualsVerifier.forClass(ArrayExpr.class).withPrefabValues(Object.class, (Object)new Object[]{1L}, (Object)new Object[0]).withPrefabValues(ExpressionType.class, (Object)ExpressionType.LONG_ARRAY, (Object)ExpressionType.DOUBLE_ARRAY).withNonnullFields(new String[]{"outputType"}).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForComplexExpr() {
        EqualsVerifier.forClass(ComplexExpr.class).withPrefabValues(Object.class, (Object)new Object[]{1L}, (Object)new Object[0]).withPrefabValues(ExpressionType.class, (Object)ExpressionTypeFactory.getInstance().ofComplex("foo"), (Object)ExpressionTypeFactory.getInstance().ofComplex("bar")).withNonnullFields(new String[]{"outputType"}).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForIdentifierExpr() {
        EqualsVerifier.forClass(IdentifierExpr.class).usingGetClass().withIgnoredFields(new String[]{"binding"}).verify();
    }

    @Test
    public void testEqualsContractForLambdaExpr() {
        EqualsVerifier.forClass(LambdaExpr.class).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForNullLongExpr() {
        EqualsVerifier.forClass(NullLongExpr.class).withIgnoredFields(new String[]{"outputType", "value"}).withPrefabValues(ExpressionType.class, (Object)ExpressionType.LONG, (Object)ExpressionType.STRING).verify();
    }

    @Test
    public void testEqualsContractForNullDoubleExpr() {
        EqualsVerifier.forClass(NullDoubleExpr.class).withIgnoredFields(new String[]{"outputType", "value"}).withPrefabValues(ExpressionType.class, (Object)ExpressionType.DOUBLE, (Object)ExpressionType.STRING).verify();
    }

    @Test
    public void testShuttleVisitAll() {
        ArrayList visitedExprs = new ArrayList();
        Expr.Shuttle shuttle = expr -> {
            visitedExprs.add(expr);
            return expr;
        };
        shuttle.visitAll(Collections.emptyList());
        Assert.assertEquals((String)"Visiting an empty list", Collections.emptyList(), visitedExprs);
        List<IdentifierExpr> oneIdentifier = Collections.singletonList(new IdentifierExpr("ident"));
        visitedExprs.clear();
        shuttle.visitAll(oneIdentifier);
        Assert.assertEquals((String)"One identifier", oneIdentifier, visitedExprs);
        ImmutableList twoIdentifiers = ImmutableList.of((Object)new IdentifierExpr("ident1"), (Object)new IdentifierExpr("ident2"));
        visitedExprs.clear();
        shuttle.visitAll((List)twoIdentifiers);
        Assert.assertEquals((String)"Two identifiers", (Object)twoIdentifiers, visitedExprs);
    }
}

