/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ExpressionTypeTest {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ExpressionType SOME_COMPLEX = new ExpressionType(ExprType.COMPLEX, "foo", null);
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerde() throws JsonProcessingException {
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)ExpressionType.STRING), ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)ExpressionType.LONG), ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)ExpressionType.DOUBLE), ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)ExpressionType.STRING_ARRAY), ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)ExpressionType.LONG_ARRAY), ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)ExpressionType.DOUBLE_ARRAY), ExpressionType.class));
        Assert.assertEquals((Object)SOME_COMPLEX, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)SOME_COMPLEX), ExpressionType.class));
    }

    @Test
    public void testSerdeFromString() throws JsonProcessingException {
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)MAPPER.readValue("\"STRING\"", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)MAPPER.readValue("\"LONG\"", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)MAPPER.readValue("\"DOUBLE\"", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)MAPPER.readValue("\"ARRAY<STRING>\"", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)MAPPER.readValue("\"ARRAY<LONG>\"", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)MAPPER.readValue("\"ARRAY<DOUBLE>\"", ExpressionType.class));
        ExpressionType whatHaveIdone = new ExpressionType(ExprType.ARRAY, null, new ExpressionType(ExprType.ARRAY, null, SOME_COMPLEX));
        Assert.assertEquals((Object)whatHaveIdone, (Object)MAPPER.readValue("\"ARRAY<ARRAY<COMPLEX<foo>>>\"", ExpressionType.class));
        Assert.assertEquals((Object)SOME_COMPLEX, (Object)MAPPER.readValue("\"COMPLEX<foo>\"", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)MAPPER.readValue("\"string\"", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)MAPPER.readValue("\"long\"", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)MAPPER.readValue("\"double\"", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)MAPPER.readValue("\"STRING_ARRAY\"", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)MAPPER.readValue("\"LONG_ARRAY\"", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)MAPPER.readValue("\"DOUBLE_ARRAY\"", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)MAPPER.readValue("\"string_array\"", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)MAPPER.readValue("\"long_array\"", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)MAPPER.readValue("\"double_array\"", ExpressionType.class));
        Assert.assertNotEquals((Object)ExpressionType.STRING_ARRAY, (Object)MAPPER.readValue("\"array<string>\"", ExpressionType.class));
        Assert.assertNotEquals((Object)ExpressionType.LONG_ARRAY, (Object)MAPPER.readValue("\"array<LONG>\"", ExpressionType.class));
        Assert.assertNotEquals((Object)SOME_COMPLEX, (Object)MAPPER.readValue("\"COMPLEX<FOO>\"", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)MAPPER.readValue("\"ARRAY<double>\"", ExpressionType.class));
    }

    @Test
    public void testFutureProof() throws JsonProcessingException {
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)MAPPER.readValue("{\"type\":\"STRING\"}", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)MAPPER.readValue("{\"type\":\"LONG\"}", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)MAPPER.readValue("{\"type\":\"DOUBLE\"}", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)MAPPER.readValue("{\"type\":\"ARRAY\", \"elementType\":{\"type\":\"STRING\"}}", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)MAPPER.readValue("{\"type\":\"ARRAY\", \"elementType\":{\"type\":\"LONG\"}}", ExpressionType.class));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)MAPPER.readValue("{\"type\":\"ARRAY\", \"elementType\":{\"type\":\"DOUBLE\"}}", ExpressionType.class));
        Assert.assertEquals((Object)SOME_COMPLEX, (Object)MAPPER.readValue("{\"type\":\"COMPLEX\", \"complexTypeName\":\"foo\"}", ExpressionType.class));
        ExpressionType whatHaveIdone = new ExpressionType(ExprType.ARRAY, null, new ExpressionType(ExprType.ARRAY, null, SOME_COMPLEX));
        Assert.assertEquals((Object)whatHaveIdone, (Object)MAPPER.readValue("{\"type\":\"ARRAY\", \"elementType\":{\"type\":\"ARRAY\", \"elementType\":{\"type\":\"COMPLEX\", \"complexTypeName\":\"foo\"}}}", ExpressionType.class));
    }

    @Test
    public void testConvertFromColumnType() {
        Assert.assertNull((Object)ExpressionType.fromColumnType(null));
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionType.fromColumnType((TypeSignature)ColumnType.LONG));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionType.fromColumnType((TypeSignature)ColumnType.FLOAT));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionType.fromColumnType((TypeSignature)ColumnType.DOUBLE));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionType.fromColumnType((TypeSignature)ColumnType.STRING));
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)ExpressionType.fromColumnType((TypeSignature)ColumnType.LONG_ARRAY));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)ExpressionType.fromColumnType((TypeSignature)ColumnType.DOUBLE_ARRAY));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)ExpressionType.fromColumnType((TypeSignature)ColumnType.STRING_ARRAY));
        Assert.assertEquals((Object)SOME_COMPLEX, (Object)ExpressionType.fromColumnType((TypeSignature)ColumnType.ofComplex((String)SOME_COMPLEX.getComplexTypeName())));
        ExpressionType complexArray = new ExpressionType(ExprType.ARRAY, null, new ExpressionType(ExprType.ARRAY, null, SOME_COMPLEX));
        ColumnType complexArrayColumn = new ColumnType(ValueType.ARRAY, null, new ColumnType(ValueType.ARRAY, null, ColumnType.ofComplex((String)SOME_COMPLEX.getComplexTypeName())));
        Assert.assertEquals((Object)complexArray, (Object)ExpressionType.fromColumnType((TypeSignature)complexArrayColumn));
    }

    @Test
    public void testConvertFromColumnTypeStrict() {
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionType.fromColumnTypeStrict((TypeSignature)ColumnType.LONG));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionType.fromColumnTypeStrict((TypeSignature)ColumnType.FLOAT));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionType.fromColumnTypeStrict((TypeSignature)ColumnType.DOUBLE));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionType.fromColumnTypeStrict((TypeSignature)ColumnType.STRING));
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)ExpressionType.fromColumnTypeStrict((TypeSignature)ColumnType.LONG_ARRAY));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)ExpressionType.fromColumnTypeStrict((TypeSignature)ColumnType.DOUBLE_ARRAY));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)ExpressionType.fromColumnTypeStrict((TypeSignature)ColumnType.STRING_ARRAY));
        Assert.assertEquals((Object)SOME_COMPLEX, (Object)ExpressionType.fromColumnTypeStrict((TypeSignature)ColumnType.ofComplex((String)SOME_COMPLEX.getComplexTypeName())));
        ExpressionType complexArray = new ExpressionType(ExprType.ARRAY, null, new ExpressionType(ExprType.ARRAY, null, SOME_COMPLEX));
        ColumnType complexArrayColumn = new ColumnType(ValueType.ARRAY, null, new ColumnType(ValueType.ARRAY, null, ColumnType.ofComplex((String)SOME_COMPLEX.getComplexTypeName())));
        Assert.assertEquals((Object)complexArray, (Object)ExpressionType.fromColumnTypeStrict((TypeSignature)complexArrayColumn));
    }

    @Test
    public void testConvertFromColumnTypeStrictNull() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Unsupported unknown value type");
        ExpressionType.fromColumnTypeStrict(null);
    }

    @Test
    public void testConvertToColumnType() {
        Assert.assertEquals((Object)ColumnType.LONG, (Object)ExpressionType.toColumnType((ExpressionType)ExpressionType.LONG));
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)ExpressionType.toColumnType((ExpressionType)ExpressionType.DOUBLE));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)ExpressionType.toColumnType((ExpressionType)ExpressionType.STRING));
        Assert.assertEquals((Object)ColumnType.LONG_ARRAY, (Object)ExpressionType.toColumnType((ExpressionType)ExpressionType.LONG_ARRAY));
        Assert.assertEquals((Object)ColumnType.DOUBLE_ARRAY, (Object)ExpressionType.toColumnType((ExpressionType)ExpressionType.DOUBLE_ARRAY));
        Assert.assertEquals((Object)ColumnType.STRING_ARRAY, (Object)ExpressionType.toColumnType((ExpressionType)ExpressionType.STRING_ARRAY));
        Assert.assertEquals((Object)ColumnType.ofComplex((String)SOME_COMPLEX.getComplexTypeName()), (Object)ExpressionType.toColumnType((ExpressionType)SOME_COMPLEX));
        ExpressionType complexArray = new ExpressionType(ExprType.ARRAY, null, new ExpressionType(ExprType.ARRAY, null, SOME_COMPLEX));
        ColumnType complexArrayColumn = new ColumnType(ValueType.ARRAY, null, new ColumnType(ValueType.ARRAY, null, ColumnType.ofComplex((String)SOME_COMPLEX.getComplexTypeName())));
        Assert.assertEquals((Object)complexArrayColumn, (Object)ExpressionType.toColumnType((ExpressionType)complexArray));
    }
}

