/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.policy.RowFilterPolicy;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class DataSourceTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSerialization() throws IOException {
        TableDataSource dataSource = new TableDataSource("somedatasource");
        String json = JSON_MAPPER.writeValueAsString((Object)dataSource);
        DataSource serdeDataSource = (DataSource)JSON_MAPPER.readValue(json, DataSource.class);
        Assert.assertEquals((Object)dataSource, (Object)serdeDataSource);
    }

    @Test
    public void testLegacyDataSource() throws IOException {
        DataSource dataSource = (DataSource)JSON_MAPPER.readValue("\"somedatasource\"", DataSource.class);
        Assert.assertEquals((Object)new TableDataSource("somedatasource"), (Object)dataSource);
    }

    @Test
    public void testTableDataSource() throws IOException {
        DataSource dataSource = (DataSource)JSON_MAPPER.readValue("{\"type\":\"table\", \"name\":\"somedatasource\"}", DataSource.class);
        Assert.assertEquals((Object)new TableDataSource("somedatasource"), (Object)dataSource);
    }

    @Test
    public void testRestrictedDataSource() throws IOException {
        DataSource dataSource = (DataSource)JSON_MAPPER.readValue("{\"type\":\"restrict\",\"base\":{\"type\":\"table\",\"name\":\"somedatasource\"},\"policy\":{\"type\":\"noRestriction\"}}\n", DataSource.class);
        Assert.assertEquals((Object)RestrictedDataSource.create((DataSource)TableDataSource.create((String)"somedatasource"), (Policy)NoRestrictionPolicy.instance()), (Object)dataSource);
    }

    @Test
    public void testQueryDataSource() throws IOException {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        String dataSourceJSON = "{\"type\":\"query\", \"query\":" + JSON_MAPPER.writeValueAsString((Object)query) + "}";
        DataSource dataSource = (DataSource)JSON_MAPPER.readValue(dataSourceJSON, DataSource.class);
        Assert.assertEquals((Object)new QueryDataSource((Query)query), (Object)dataSource);
    }

    @Test
    public void testUnionDataSource() throws Exception {
        DataSource dataSource = (DataSource)JSON_MAPPER.readValue("{\"type\":\"union\", \"dataSources\":[\"ds1\", \"ds2\"]}", DataSource.class);
        Assert.assertTrue((boolean)(dataSource instanceof UnionDataSource));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new TableDataSource[]{new TableDataSource("ds1"), new TableDataSource("ds2")}), (Object)Lists.newArrayList((Iterable)((UnionDataSource)dataSource).getDataSourcesAsTableDataSources()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"ds1", (Object)"ds2"), (Object)dataSource.getTableNames());
        DataSource serde = (DataSource)JSON_MAPPER.readValue(JSON_MAPPER.writeValueAsString((Object)dataSource), DataSource.class);
        Assert.assertEquals((Object)dataSource, (Object)serde);
    }

    @Test
    public void testMapWithRestriction() {
        TableDataSource table1 = TableDataSource.create((String)"table1");
        TableDataSource table2 = TableDataSource.create((String)"table2");
        TableDataSource table3 = TableDataSource.create((String)"table3");
        UnionDataSource unionDataSource = new UnionDataSource((List)Lists.newArrayList((Object[])new DataSource[]{table1, table2, table3}));
        ImmutableMap restrictions = ImmutableMap.of((Object)"table1", Optional.of(NoRestrictionPolicy.instance()), (Object)"table2", Optional.of(NoRestrictionPolicy.instance()), (Object)"table3", Optional.of(RowFilterPolicy.from((DimFilter)new NullFilter("some-column", null))));
        Assert.assertEquals((Object)unionDataSource.withPolicies((Map)restrictions), (Object)new UnionDataSource((List)Lists.newArrayList((Object[])new DataSource[]{RestrictedDataSource.create((DataSource)table1, (Policy)NoRestrictionPolicy.instance()), RestrictedDataSource.create((DataSource)table2, (Policy)NoRestrictionPolicy.instance()), RestrictedDataSource.create((DataSource)table3, (Policy)RowFilterPolicy.from((DimFilter)new NullFilter("some-column", null)))})));
    }

    @Test
    public void testMapWithRestriction_onRestrictedDataSource_fromDruidSystem() {
        RestrictedDataSource restrictedDataSource = RestrictedDataSource.create((DataSource)TableDataSource.create((String)"table1"), (Policy)RowFilterPolicy.from((DimFilter)new NullFilter("some-column", null)));
        ImmutableMap noRestrictionPolicy = ImmutableMap.of((Object)"table1", Optional.of(NoRestrictionPolicy.instance()));
        Assert.assertEquals((Object)restrictedDataSource, (Object)restrictedDataSource.withPolicies((Map)noRestrictionPolicy));
    }

    @Test
    public void testMapWithRestriction_onRestrictedDataSource_alwaysThrows() {
        RestrictedDataSource restrictedDataSource = RestrictedDataSource.create((DataSource)TableDataSource.create((String)"table1"), (Policy)RowFilterPolicy.from((DimFilter)new NullFilter("random-column", null)));
        ImmutableMap anotherRestrictions = ImmutableMap.of((Object)"table1", Optional.of(RowFilterPolicy.from((DimFilter)new NullFilter("some-column", null))));
        ImmutableMap noPolicyFound = ImmutableMap.of((Object)"table1", Optional.empty());
        ImmutableMap policyWasNotChecked = ImmutableMap.of();
        ISE e = (ISE)Assert.assertThrows(ISE.class, () -> restrictedDataSource.withPolicies((Map)anotherRestrictions));
        Assert.assertEquals((Object)"Multiple restrictions on table [table1]: policy [RowFilterPolicy{rowFilter=random-column IS NULL}] and policy [RowFilterPolicy{rowFilter=some-column IS NULL}]", (Object)e.getMessage());
        ISE e2 = (ISE)Assert.assertThrows(ISE.class, () -> restrictedDataSource.withPolicies((Map)noPolicyFound));
        Assert.assertEquals((Object)"No restriction found on table [table1], but had policy [RowFilterPolicy{rowFilter=random-column IS NULL}] before.", (Object)e2.getMessage());
        ISE e3 = (ISE)Assert.assertThrows(ISE.class, () -> restrictedDataSource.withPolicies((Map)policyWasNotChecked));
        Assert.assertEquals((Object)"Missing policy check result for table [table1]", (Object)e3.getMessage());
    }
}

