/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.CancellationException;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class QueryInterruptedExceptionTest {
    private static final ObjectMapper MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testErrorCode() {
        Assert.assertEquals((Object)"Query cancelled", (Object)new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new CancellationException())).getErrorCode());
        Assert.assertEquals((Object)"Query cancelled", (Object)new QueryInterruptedException((Throwable)new CancellationException()).getErrorCode());
        Assert.assertEquals((Object)"Query interrupted", (Object)new QueryInterruptedException((Throwable)new InterruptedException()).getErrorCode());
        Assert.assertEquals((Object)"Unsupported operation", (Object)new QueryInterruptedException((Throwable)new UOE("Unsupported", new Object[0])).getErrorCode());
        Assert.assertEquals((Object)"Unknown exception", (Object)new QueryInterruptedException(null).getErrorCode());
        Assert.assertEquals((Object)"Unknown exception", (Object)new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0])).getErrorCode());
        Assert.assertEquals((Object)"Unknown exception", (Object)new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0]))).getErrorCode());
    }

    @Test
    public void testErrorMessage() {
        Assert.assertEquals(null, (Object)new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new CancellationException())).getMessage());
        Assert.assertEquals(null, (Object)new QueryInterruptedException((Throwable)new CancellationException()).getMessage());
        Assert.assertEquals(null, (Object)new QueryInterruptedException((Throwable)new InterruptedException()).getMessage());
        Assert.assertEquals(null, (Object)new QueryInterruptedException(null).getMessage());
        Assert.assertEquals((Object)"Something bad!", (Object)new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0])).getMessage());
        Assert.assertEquals((Object)"Something bad!", (Object)new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0]))).getMessage());
    }

    @Test
    public void testErrorClass() {
        Assert.assertEquals((Object)"java.util.concurrent.CancellationException", (Object)new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new CancellationException())).getErrorClass());
        Assert.assertEquals((Object)"java.util.concurrent.CancellationException", (Object)new QueryInterruptedException((Throwable)new CancellationException()).getErrorClass());
        Assert.assertEquals((Object)"java.lang.InterruptedException", (Object)new QueryInterruptedException((Throwable)new InterruptedException()).getErrorClass());
        Assert.assertEquals(null, (Object)new QueryInterruptedException(null).getErrorClass());
        Assert.assertEquals((Object)"org.apache.druid.java.util.common.ISE", (Object)new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0])).getErrorClass());
        Assert.assertEquals((Object)"org.apache.druid.java.util.common.ISE", (Object)new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0]))).getErrorClass());
    }

    @Test
    public void testHost() {
        Assert.assertEquals((Object)"myhost", (Object)new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new CancellationException(), "myhost")).getHost());
    }

    @Test
    public void testSerde() {
        Assert.assertEquals((Object)"Query cancelled", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new CancellationException()))).getErrorCode());
        Assert.assertEquals((Object)"java.util.concurrent.CancellationException", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new CancellationException()))).getErrorClass());
        Assert.assertEquals(null, (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new CancellationException()))).getMessage());
        Assert.assertEquals((Object)"java.util.concurrent.CancellationException", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new CancellationException())).getErrorClass());
        Assert.assertEquals((Object)"java.lang.InterruptedException", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new InterruptedException())).getErrorClass());
        Assert.assertEquals(null, (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException(null)).getErrorClass());
        Assert.assertEquals((Object)"org.apache.druid.java.util.common.ISE", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0]))).getErrorClass());
        Assert.assertEquals((Object)"org.apache.druid.java.util.common.ISE", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0])))).getErrorClass());
        Assert.assertEquals((Object)"Something bad!", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0]))).getMessage());
        Assert.assertEquals((Object)"Something bad!", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0])))).getMessage());
        Assert.assertEquals((Object)"Unknown exception", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0]))).getErrorCode());
        Assert.assertEquals((Object)"Unknown exception", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0])))).getErrorCode());
    }

    @Test
    public void testToStringShouldReturnUsefulInformation() {
        QueryInterruptedException exception = new QueryInterruptedException("error", "error messagez", "error class", "host");
        String exceptionString = exception.toString();
        Assert.assertTrue((boolean)exceptionString.startsWith(QueryInterruptedException.class.getSimpleName()));
        Assert.assertTrue((boolean)exceptionString.contains("code=error"));
        Assert.assertTrue((boolean)exceptionString.contains("msg=error messagez"));
        Assert.assertTrue((boolean)exceptionString.contains("class=error class"));
        Assert.assertTrue((boolean)exceptionString.contains("host=host"));
    }

    private static QueryInterruptedException roundTrip(QueryInterruptedException e) {
        try {
            return (QueryInterruptedException)MAPPER.readValue(MAPPER.writeValueAsBytes((Object)e), QueryInterruptedException.class);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }
}

