/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AbstractSerializablePairLongObjectBufferStore;
import org.apache.druid.query.aggregation.AbstractSerializablePairLongObjectColumnHeader;
import org.apache.druid.query.aggregation.SerializablePairLongFloat;
import org.apache.druid.query.aggregation.SerializablePairLongFloatBufferStore;
import org.apache.druid.query.aggregation.SerializablePairLongFloatColumnHeader;
import org.apache.druid.query.aggregation.SerializablePairLongFloatComplexColumn;
import org.apache.druid.query.aggregation.SerializablePairLongFloatComplexMetricSerde;
import org.apache.druid.query.aggregation.SerializablePairLongFloatSimpleStagedSerde;
import org.apache.druid.query.aggregation.SerializedStorage;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.serde.cell.ByteBufferProvider;
import org.apache.druid.segment.serde.cell.IOIterator;
import org.apache.druid.segment.serde.cell.NativeClearedByteBufferProvider;
import org.apache.druid.segment.serde.cell.StagedSerde;
import org.apache.druid.segment.writeout.HeapByteBufferWriteOutBytes;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SerializablePairLongFloatBufferStoreTest {
    private final Random random = new Random(0L);
    private static final int MIN_INTEGER = 100;
    private static final long MIN_LONG = 0L;
    private final SerializablePairLongFloat[] integerRangeArr = new SerializablePairLongFloat[]{new SerializablePairLongFloat(Long.valueOf(100L), Float.valueOf(10.0f)), new SerializablePairLongFloat(Long.valueOf(101L), Float.valueOf(20.0f)), new SerializablePairLongFloat(Long.valueOf(102L), Float.valueOf(30.0f))};
    private final SerializablePairLongFloat[] longRangeArr = new SerializablePairLongFloat[]{new SerializablePairLongFloat(Long.valueOf(0L), Float.valueOf(10.0f)), new SerializablePairLongFloat(Long.valueOf(101L), Float.valueOf(20.0f)), new SerializablePairLongFloat(Long.valueOf(102L), Float.valueOf(30.0f)), new SerializablePairLongFloat(Long.valueOf(Integer.MAX_VALUE), Float.valueOf(40.0f)), new SerializablePairLongFloat(Long.valueOf(Long.MAX_VALUE), Float.valueOf(50.0f))};
    private final SegmentWriteOutMedium writeOutMedium = new OnHeapMemorySegmentWriteOutMedium();
    private SerializablePairLongFloatBufferStore bufferStore;

    @Before
    public void setup() throws Exception {
        this.bufferStore = new SerializablePairLongFloatBufferStore(new SerializedStorage(this.writeOutMedium.makeWriteOutBytes(), (StagedSerde)new SerializablePairLongFloatSimpleStagedSerde()));
    }

    @Test
    public void testIteratorSimple() throws Exception {
        for (SerializablePairLongFloat value : this.integerRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        IOIterator iterator = this.bufferStore.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Assert.assertEquals((Object)this.integerRangeArr[i], (Object)iterator.next());
            ++i;
        }
    }

    @Test
    public void testIteratorNull() throws Exception {
        this.bufferStore.store(null);
        IOIterator iterator = this.bufferStore.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertNull((Object)iterator.next());
    }

    @Test
    public void testIteratorIdempotentHasNext() throws Exception {
        this.bufferStore.store((SerializablePair)this.integerRangeArr[0]);
        IOIterator iterator = this.bufferStore.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasNext());
    }

    @Test(expected=NoSuchElementException.class)
    public void testIteratorEmptyThrows() throws Exception {
        IOIterator iterator = this.bufferStore.iterator();
        iterator.next();
    }

    @Test
    public void testIteratorEmptyHasNext() throws Exception {
        IOIterator iterator = this.bufferStore.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testMinValueUsesInteger() throws Exception {
        for (SerializablePairLongFloat value : this.integerRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        SerializablePairLongFloatColumnHeader columnHeader = (SerializablePairLongFloatColumnHeader)this.bufferStore.createColumnHeader();
        Assert.assertEquals((long)((Long)this.integerRangeArr[0].lhs), (long)columnHeader.getMinValue());
        Assert.assertTrue((boolean)columnHeader.isUseIntegerDeltas());
    }

    @Test
    public void testMinValueUsesLong() throws Exception {
        for (SerializablePairLongFloat value : this.longRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        SerializablePairLongFloatColumnHeader columnHeader = (SerializablePairLongFloatColumnHeader)this.bufferStore.createColumnHeader();
        Assert.assertEquals((long)0L, (long)columnHeader.getMinValue());
        Assert.assertFalse((boolean)columnHeader.isUseIntegerDeltas());
    }

    @Test
    public void testMinValueUsesIntegerSerialization() throws Exception {
        for (SerializablePairLongFloat value : this.integerRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        SerializablePairLongFloatColumnHeader columnHeader = (SerializablePairLongFloatColumnHeader)this.bufferStore.createColumnHeader();
        HeapByteBufferWriteOutBytes channel = new HeapByteBufferWriteOutBytes();
        try (ResourceHolder resourceHolder = NativeClearedByteBufferProvider.INSTANCE.get();){
            columnHeader.transferTo((WritableByteChannel)channel);
            ByteBuffer byteBuffer = (ByteBuffer)resourceHolder.get();
            channel.writeTo(byteBuffer);
            byteBuffer.flip();
            SerializablePairLongFloatColumnHeader deserializedColumnhHeader = (SerializablePairLongFloatColumnHeader)AbstractSerializablePairLongObjectColumnHeader.fromBuffer((ByteBuffer)byteBuffer, SerializablePairLongFloat.class);
            Assert.assertEquals((long)100L, (long)deserializedColumnhHeader.getMinValue());
            Assert.assertTrue((boolean)deserializedColumnhHeader.isUseIntegerDeltas());
        }
    }

    @Test
    public void testMinValueSerialization() throws Exception {
        for (SerializablePairLongFloat value : this.longRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        SerializablePairLongFloatColumnHeader columnHeader = (SerializablePairLongFloatColumnHeader)this.bufferStore.createColumnHeader();
        HeapByteBufferWriteOutBytes channel = new HeapByteBufferWriteOutBytes();
        try (ResourceHolder resourceHolder = NativeClearedByteBufferProvider.INSTANCE.get();){
            columnHeader.transferTo((WritableByteChannel)channel);
            ByteBuffer byteBuffer = (ByteBuffer)resourceHolder.get();
            channel.writeTo(byteBuffer);
            byteBuffer.flip();
            SerializablePairLongFloatColumnHeader deserializedColumnhHeader = (SerializablePairLongFloatColumnHeader)AbstractSerializablePairLongObjectColumnHeader.fromBuffer((ByteBuffer)byteBuffer, SerializablePairLongFloat.class);
            Assert.assertEquals((long)0L, (long)deserializedColumnhHeader.getMinValue());
            Assert.assertFalse((boolean)deserializedColumnhHeader.isUseIntegerDeltas());
        }
    }

    @Test
    public void testLargeBuffer() throws Exception {
        SerializablePairLongFloat value = new SerializablePairLongFloat(Long.valueOf(Long.MAX_VALUE), Float.valueOf(Float.POSITIVE_INFINITY));
        this.bufferStore.store((SerializablePair)value);
        IOIterator iterator = this.bufferStore.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)value, (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testLargeValueCount() throws Exception {
        ArrayList<SerializablePairLongFloat> valueList = new ArrayList<SerializablePairLongFloat>();
        for (int i = 0; i < 10000; ++i) {
            valueList.add(new SerializablePairLongFloat(Long.valueOf(Integer.MAX_VALUE + (long)i), Float.valueOf(this.random.nextFloat())));
        }
        this.assertBufferedValuesEqual(valueList);
    }

    @Test
    public void testOverflowTransfer() throws Exception {
        this.bufferStore.store((SerializablePair)new SerializablePairLongFloat(Long.valueOf(Long.MIN_VALUE), Float.valueOf(10.0f)));
        this.bufferStore.store((SerializablePair)new SerializablePairLongFloat(Long.valueOf(Long.MAX_VALUE), Float.valueOf(10.0f)));
        SerializablePairLongFloatColumnHeader columnHeader = (SerializablePairLongFloatColumnHeader)this.bufferStore.createColumnHeader();
        Assert.assertEquals((long)0L, (long)columnHeader.getMinValue());
        AbstractSerializablePairLongObjectBufferStore.TransferredBuffer transferredBuffer = this.bufferStore.transferToRowWriter((ByteBufferProvider)NativeClearedByteBufferProvider.INSTANCE, this.writeOutMedium);
        Assert.assertEquals((long)90L, (long)transferredBuffer.getSerializedSize());
    }

    @Test
    public void testNullOnlyTransfer() throws Exception {
        this.bufferStore.store(null);
        this.bufferStore.store(null);
        this.bufferStore.store(null);
        SerializablePairLongFloatColumnHeader columnHeader = (SerializablePairLongFloatColumnHeader)this.bufferStore.createColumnHeader();
        Assert.assertEquals((long)0L, (long)columnHeader.getMinValue());
        AbstractSerializablePairLongObjectBufferStore.TransferredBuffer transferredBuffer = this.bufferStore.transferToRowWriter((ByteBufferProvider)NativeClearedByteBufferProvider.INSTANCE, this.writeOutMedium);
        Assert.assertEquals((long)59L, (long)transferredBuffer.getSerializedSize());
    }

    @Test
    public void testTransferIntegerRange() throws Exception {
        for (SerializablePairLongFloat value : this.integerRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        Assert.assertTrue((boolean)this.bufferStore.createColumnHeader().isUseIntegerDeltas());
        this.assertTransferredValuesEqual(this.integerRangeArr);
    }

    @Test
    public void testTransferLongRange() throws Exception {
        for (SerializablePairLongFloat value : this.longRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        Assert.assertFalse((boolean)this.bufferStore.createColumnHeader().isUseIntegerDeltas());
        this.assertTransferredValuesEqual(this.longRangeArr);
    }

    private void assertBufferedValuesEqual(List<SerializablePairLongFloat> input) throws IOException {
        for (SerializablePairLongFloat pairLongLong : input) {
            this.bufferStore.store((SerializablePair)pairLongLong);
        }
        IOIterator iterator = this.bufferStore.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Assert.assertEquals((Object)input.get(i), (Object)iterator.next());
            ++i;
        }
        Assert.assertEquals((String)StringUtils.format((String)"element count mismatch: expected %s, got %s", (Object[])new Object[]{input.size(), i}), (long)input.size(), (long)i);
    }

    private void assertTransferredValuesEqual(SerializablePairLongFloat[] input) throws IOException {
        AbstractSerializablePairLongObjectBufferStore.TransferredBuffer transferredBuffer = this.bufferStore.transferToRowWriter((ByteBufferProvider)NativeClearedByteBufferProvider.INSTANCE, this.writeOutMedium);
        HeapByteBufferWriteOutBytes resultChannel = new HeapByteBufferWriteOutBytes();
        transferredBuffer.writeTo((WritableByteChannel)resultChannel, null);
        try (SerializablePairLongFloatComplexColumn column = SerializablePairLongFloatBufferStoreTest.createComplexColumn(transferredBuffer, resultChannel);){
            for (int i = 0; i < input.length; ++i) {
                Assert.assertEquals((Object)input[i], (Object)column.getRowValue(i));
            }
        }
    }

    private static SerializablePairLongFloatComplexColumn createComplexColumn(AbstractSerializablePairLongObjectBufferStore.TransferredBuffer transferredBuffer, HeapByteBufferWriteOutBytes resultChannel) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(Ints.checkedCast((long)transferredBuffer.getSerializedSize()));
        resultChannel.readFully(0L, byteBuffer);
        byteBuffer.flip();
        SerializablePairLongFloatComplexMetricSerde complexMetricSerde = new SerializablePairLongFloatComplexMetricSerde();
        ColumnBuilder builder = new ColumnBuilder();
        complexMetricSerde.deserializeColumn(byteBuffer, builder);
        builder.setType(ValueType.COMPLEX);
        ColumnHolder columnHolder = builder.build();
        SerializablePairLongFloatComplexColumn column = (SerializablePairLongFloatComplexColumn)columnHolder.getColumn();
        return column;
    }
}

