/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.util.Random;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.SerializablePairLongFloat;
import org.apache.druid.query.aggregation.SerializablePairLongFloatDeltaEncodedStagedSerde;
import org.junit.Assert;
import org.junit.Test;

public class SerializablePairLongFloatDeltaEncodedStagedSerdeTest {
    private static final SerializablePairLongFloatDeltaEncodedStagedSerde INTEGER_SERDE = new SerializablePairLongFloatDeltaEncodedStagedSerde(0L, true);
    private static final SerializablePairLongFloatDeltaEncodedStagedSerde LONG_SERDE = new SerializablePairLongFloatDeltaEncodedStagedSerde(0L, false);
    private final Random random = new Random(0L);

    @Test
    public void testNull() {
        SerializablePairLongFloatDeltaEncodedStagedSerdeTest.assertValueEquals(null, 0, INTEGER_SERDE);
    }

    @Test
    public void testSimpleInteger() {
        SerializablePairLongFloatDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongFloat(Long.valueOf(100L), Float.valueOf(10.0f)), 9, INTEGER_SERDE);
    }

    @Test
    public void testNullRHSInteger() {
        SerializablePairLongFloatDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongFloat(Long.valueOf(100L), null), 5, INTEGER_SERDE);
    }

    @Test
    public void testLargeRHSInteger() {
        SerializablePairLongFloatDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongFloat(Long.valueOf(100L), Float.valueOf(this.random.nextFloat())), 9, INTEGER_SERDE);
    }

    @Test
    public void testSimpleLong() {
        SerializablePairLongFloatDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongFloat(Long.valueOf(100L), Float.valueOf(10.0f)), 13, LONG_SERDE);
    }

    @Test
    public void testNullRHSLong() {
        SerializablePairLongFloatDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongFloat(Long.valueOf(100L), null), 9, LONG_SERDE);
    }

    @Test
    public void testLargeRHSLong() {
        SerializablePairLongFloatDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongFloat(Long.valueOf(100L), Float.valueOf(this.random.nextFloat())), 13, LONG_SERDE);
    }

    private static void assertValueEquals(@Nullable SerializablePairLongFloat value, int size, SerializablePairLongFloatDeltaEncodedStagedSerde serde) {
        byte[] bytes = serde.serialize((Object)value);
        Assert.assertEquals((long)size, (long)bytes.length);
        SerializablePairLongFloat deserialized = (SerializablePairLongFloat)serde.deserialize(bytes);
        Assert.assertEquals((Object)value, (Object)deserialized);
    }
}

