/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.query.aggregation.any.NumericAnyVectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NumericAnyVectorAggregatorTest
extends InitializedNullHandlingTest {
    private static final int NULL_POSITION = 10;
    private static final int BUFFER_SIZE = 128;
    private static final long FOUND_OBJECT = 23L;
    private static final int POSITION = 2;
    private static final boolean[] NULLS = new boolean[]{false, false, true, false};
    private ByteBuffer buf;
    @Mock
    private VectorValueSelector selector;
    private NumericAnyVectorAggregator target;

    @Before
    public void setUp() {
        ((VectorValueSelector)Mockito.doReturn((Object)NULLS).when((Object)this.selector)).getNullVector();
        this.target = (NumericAnyVectorAggregator)Mockito.spy((Object)new NumericAnyVectorAggregator(this.selector){

            void initValue(ByteBuffer buf, int position) {
            }

            boolean putAnyValueFromRow(ByteBuffer buf, int position, int startRow, int endRow) {
                boolean isRowsWithinIndex;
                boolean bl = isRowsWithinIndex = startRow < endRow && startRow < NULLS.length;
                if (isRowsWithinIndex) {
                    buf.putLong(position, startRow);
                }
                return isRowsWithinIndex;
            }

            Object getNonNullObject(ByteBuffer buf, int position) {
                if (position == 3) {
                    return 23L;
                }
                return -1;
            }
        });
        byte[] randomBuffer = new byte[128];
        ThreadLocalRandom.current().nextBytes(randomBuffer);
        this.buf = ByteBuffer.wrap(randomBuffer);
        this.clearBufferForPositions(0, 2);
        this.buf.put(10, (byte)1);
    }

    @Test
    public void initShouldSetDoubleAfterPositionToZero() {
        this.target.init(this.buf, 2);
        Assert.assertEquals((long)0L, (long)(this.buf.get(2) & 2));
        Assert.assertEquals((long)1L, (long)this.buf.get(2));
    }

    @Test
    public void aggregateNotFoundAndHasNullsShouldPutNull() {
        this.target.aggregate(this.buf, 2, 0, 3);
        Assert.assertEquals((long)3L, (long)this.buf.get(2));
    }

    @Test
    public void aggregateNotFoundAndHasNullsOutsideRangeShouldPutValue() {
        this.target.aggregate(this.buf, 2, 0, 1);
        Assert.assertEquals((long)2L, (long)this.buf.get(2));
    }

    @Test
    public void aggregateNotFoundAndNoNullsShouldPutValue() {
        ((VectorValueSelector)Mockito.doReturn(null).when((Object)this.selector)).getNullVector();
        this.target.aggregate(this.buf, 2, 0, 3);
        Assert.assertEquals((long)2L, (long)this.buf.get(2));
    }

    @Test
    public void aggregateNotFoundNoNullsAndValuesOutsideRangeShouldNotPutValue() {
        ((VectorValueSelector)Mockito.doReturn(null).when((Object)this.selector)).getNullVector();
        this.target.aggregate(this.buf, 2, NULLS.length, NULLS.length + 1);
        Assert.assertNotEquals((long)2L, (long)(this.buf.get(2) & 2));
    }

    @Test
    public void aggregateBatchNoRowsShouldAggregateAllRows() {
        ((VectorValueSelector)Mockito.doReturn(null).when((Object)this.selector)).getNullVector();
        int[] positions = new int[]{0, 43, 70};
        int positionOffset = 2;
        this.clearBufferForPositions(positionOffset, positions);
        this.target.aggregate(this.buf, 3, positions, null, positionOffset);
        for (int i = 0; i < positions.length; ++i) {
            int position = positions[i] + positionOffset;
            Assert.assertEquals((long)2L, (long)(this.buf.get(position) & 2));
            Assert.assertEquals((long)i, (long)this.buf.getLong(position + 1));
        }
    }

    @Test
    public void aggregateBatchWithRowsShouldAggregateAllRows() {
        ((VectorValueSelector)Mockito.doReturn(null).when((Object)this.selector)).getNullVector();
        int[] positions = new int[]{0, 43, 70};
        int positionOffset = 2;
        this.clearBufferForPositions(positionOffset, positions);
        int[] rows = new int[]{3, 2, 0};
        this.target.aggregate(this.buf, 3, positions, rows, positionOffset);
        for (int i = 0; i < positions.length; ++i) {
            int position = positions[i] + positionOffset;
            Assert.assertEquals((long)2L, (long)(this.buf.get(position) & 2));
            Assert.assertEquals((long)rows[i], (long)this.buf.getLong(position + 1));
        }
    }

    @Test
    public void aggregateFoundShouldDoNothing() {
        long previous = this.buf.getLong(3);
        this.buf.put(2, (byte)2);
        this.target.aggregate(this.buf, 2, 0, 3);
        Assert.assertEquals((long)previous, (long)this.buf.getLong(3));
    }

    @Test
    public void getNullShouldReturnNull() {
        Assert.assertNull((Object)this.target.get(this.buf, 10));
    }

    @Test
    public void getNotNullShouldReturnValue() {
        Assert.assertEquals((Object)23L, (Object)this.target.get(this.buf, 2));
    }

    @Test
    public void isValueNull() {
        this.buf.put(2, (byte)4);
        Assert.assertFalse((boolean)this.target.isValueNull(this.buf, 2));
        this.buf.put(2, (byte)3);
        Assert.assertTrue((boolean)this.target.isValueNull(this.buf, 2));
    }

    private void clearBufferForPositions(int offset, int ... positions) {
        for (int position : positions) {
            this.buf.put(position + offset, (byte)0);
        }
    }
}

