/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.firstlast.last;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.SerializablePairLongLong;
import org.apache.druid.query.aggregation.TestLongColumnSelector;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.aggregation.firstlast.last.LongLastAggregatorFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LongLastAggregationTest
extends InitializedNullHandlingTest {
    private LongLastAggregatorFactory longLastAggFactory;
    private LongLastAggregatorFactory combiningAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private TestLongColumnSelector timeSelector;
    private TestLongColumnSelector customTimeSelector;
    private TestLongColumnSelector valueSelector;
    private TestObjectColumnSelector objectSelector;
    private long[] longValues = new long[]{23216L, 8635L, 1547123L, Long.MAX_VALUE};
    private long[] times = new long[]{1467935723L, 1467225653L, 1601848932L, 72515L};
    private long[] customTimes = new long[]{1L, 4L, 3L, 2L};
    private SerializablePairLongLong[] pairs = new SerializablePairLongLong[]{new SerializablePairLongLong(Long.valueOf(12531L), Long.valueOf(113267L)), new SerializablePairLongLong(Long.valueOf(12534L), null), new SerializablePairLongLong(Long.valueOf(123L), Long.valueOf(5437384L)), new SerializablePairLongLong(Long.valueOf(125755L), Long.valueOf(34583458L)), new SerializablePairLongLong(Long.valueOf(124L), Long.valueOf(34283452L))};

    @Before
    public void setup() {
        this.longLastAggFactory = new LongLastAggregatorFactory("billy", "nilly", null);
        this.combiningAggFactory = (LongLastAggregatorFactory)this.longLastAggFactory.getCombiningFactory();
        this.timeSelector = new TestLongColumnSelector(this.times);
        this.customTimeSelector = new TestLongColumnSelector(this.customTimes);
        this.valueSelector = new TestLongColumnSelector(this.longValues);
        this.objectSelector = new TestObjectColumnSelector<SerializablePairLongLong>(this.pairs);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("__time")).andReturn((Object)this.timeSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("customTime")).andReturn((Object)this.customTimeSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn((Object)this.valueSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("billy")).andReturn((Object)this.objectSelector);
        EasyMock.expect((Object)this.colSelectorFactory.getColumnCapabilities("nilly")).andReturn((Object)new ColumnCapabilitiesImpl().setType(ColumnType.LONG));
        EasyMock.expect((Object)this.colSelectorFactory.getColumnCapabilities("billy")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
    }

    @Test
    public void testLongLastAggregator() {
        Aggregator agg = this.longLastAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        Assert.assertEquals((long)this.times[2], (long)((Long)result.lhs));
        Assert.assertEquals((long)this.longValues[2], (long)((Long)result.rhs));
        Assert.assertEquals((long)this.longValues[2], (long)agg.getLong());
        Assert.assertEquals((float)this.longValues[2], (float)agg.getFloat(), (float)1.0f);
    }

    @Test
    public void testLongLastAggregatorWithTimeColumn() {
        Aggregator agg = new LongLastAggregatorFactory("billy", "nilly", "customTime").factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        Assert.assertEquals((long)this.customTimes[1], (long)((Long)result.lhs));
        Assert.assertEquals((long)this.longValues[1], (long)((Long)result.rhs));
        Assert.assertEquals((long)this.longValues[1], (long)agg.getLong());
        Assert.assertEquals((float)this.longValues[1], (float)agg.getFloat(), (float)1.0f);
    }

    @Test
    public void testLongLastBufferAggregator() {
        BufferAggregator agg = this.longLastAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.longLastAggFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        Assert.assertEquals((long)this.times[2], (long)((Long)result.lhs));
        Assert.assertEquals((long)this.longValues[2], (long)((Long)result.rhs));
        Assert.assertEquals((long)this.longValues[2], (long)agg.getLong(buffer, 0));
        Assert.assertEquals((float)this.longValues[2], (float)agg.getFloat(buffer, 0), (float)1.0f);
    }

    @Test
    public void testLongLastBufferAggregatorWithTimeColumn() {
        BufferAggregator agg = new LongLastAggregatorFactory("billy", "nilly", "customTime").factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.longLastAggFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        Assert.assertEquals((long)this.customTimes[1], (long)((Long)result.lhs));
        Assert.assertEquals((long)this.longValues[1], (long)((Long)result.rhs));
        Assert.assertEquals((long)this.longValues[1], (long)agg.getLong(buffer, 0));
        Assert.assertEquals((float)this.longValues[1], (float)agg.getFloat(buffer, 0), (float)1.0f);
    }

    @Test
    public void testCombine() {
        SerializablePairLongLong pair1 = new SerializablePairLongLong(Long.valueOf(1467225000L), Long.valueOf(64432L));
        SerializablePairLongLong pair2 = new SerializablePairLongLong(Long.valueOf(1467240000L), Long.valueOf(99999L));
        Assert.assertEquals((Object)pair2, (Object)this.longLastAggFactory.combine((Object)pair1, (Object)pair2));
    }

    @Test
    public void testComparatorWithNulls() {
        SerializablePairLongLong pair1 = new SerializablePairLongLong(Long.valueOf(1467225000L), Long.valueOf(1263L));
        SerializablePairLongLong pair2 = new SerializablePairLongLong(Long.valueOf(1467240000L), null);
        Comparator comparator = this.longLastAggFactory.getComparator();
        Assert.assertEquals((long)1L, (long)comparator.compare(pair1, pair2));
        Assert.assertEquals((long)0L, (long)comparator.compare(pair1, pair1));
        Assert.assertEquals((long)0L, (long)comparator.compare(pair2, pair2));
        Assert.assertEquals((long)-1L, (long)comparator.compare(pair2, pair1));
    }

    @Test
    public void testLongLastCombiningAggregator() {
        Aggregator agg = this.combiningAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        SerializablePairLongLong expected = this.pairs[3];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((Object)expected.rhs, (Object)result.rhs);
        Assert.assertEquals((long)((Long)expected.rhs), (long)agg.getLong());
        Assert.assertEquals((float)((Long)expected.rhs).longValue(), (float)agg.getFloat(), (float)1.0f);
    }

    @Test
    public void testLongLastCombiningBufferAggregator() {
        BufferAggregator agg = this.combiningAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.longLastAggFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        SerializablePairLongLong expected = this.pairs[3];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((Object)expected.rhs, (Object)result.rhs);
        Assert.assertEquals((long)((Long)expected.rhs), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((float)((Long)expected.rhs).longValue(), (float)agg.getFloat(buffer, 0), (float)1.0f);
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String longSpecJson = "{\"type\":\"longLast\",\"name\":\"billy\",\"fieldName\":\"nilly\"}";
        AggregatorFactory deserialized = (AggregatorFactory)mapper.readValue(longSpecJson, AggregatorFactory.class);
        Assert.assertEquals((Object)this.longLastAggFactory, (Object)deserialized);
        Assert.assertArrayEquals((byte[])this.longLastAggFactory.getCacheKey(), (byte[])deserialized.getCacheKey());
    }

    @Test
    public void testLongLastAggregateCombiner() {
        TestObjectColumnSelector<SerializablePairLongLong> columnSelector = new TestObjectColumnSelector<SerializablePairLongLong>(this.pairs);
        AggregateCombiner longLastAggregateCombiner = this.combiningAggFactory.makeAggregateCombiner();
        longLastAggregateCombiner.reset(columnSelector);
        Assert.assertEquals((Object)this.pairs[0], (Object)longLastAggregateCombiner.getObject());
        columnSelector.increment();
        longLastAggregateCombiner.fold(columnSelector);
        Assert.assertEquals((Object)this.pairs[1], (Object)longLastAggregateCombiner.getObject());
        columnSelector.increment();
        longLastAggregateCombiner.fold(columnSelector);
        Assert.assertEquals((Object)this.pairs[1], (Object)longLastAggregateCombiner.getObject());
        longLastAggregateCombiner.reset(columnSelector);
        Assert.assertEquals((Object)this.pairs[2], (Object)longLastAggregateCombiner.getObject());
    }

    private void aggregate(Aggregator agg) {
        agg.aggregate();
        this.timeSelector.increment();
        this.customTimeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }

    private void aggregate(BufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        this.timeSelector.increment();
        this.customTimeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }
}

