/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.explain;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import org.apache.druid.error.DruidException;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.explain.ExplainAttributes;
import org.junit.Assert;
import org.junit.Test;

public class ExplainAttributesTest {
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();

    @Test
    public void testGetters() {
        ExplainAttributes selectAttributes = new ExplainAttributes("SELECT", null, null, null, null);
        Assert.assertEquals((Object)"SELECT", (Object)selectAttributes.getStatementType());
        Assert.assertNull((Object)selectAttributes.getTargetDataSource());
        Assert.assertNull((Object)selectAttributes.getPartitionedBy());
        Assert.assertNull((Object)selectAttributes.getClusteredBy());
        Assert.assertNull((Object)selectAttributes.getReplaceTimeChunks());
    }

    @Test
    public void testSerdeOfSelectAttributes() {
        ExplainAttributes selectAttributes = new ExplainAttributes("SELECT", null, null, null, null);
        String expectedAttributes = "{\"statementType\":\"SELECT\"}";
        this.testSerde(selectAttributes, "{\"statementType\":\"SELECT\"}");
    }

    @Test
    public void testSerdeOfInsertAttributes() {
        ExplainAttributes insertAttributes = new ExplainAttributes("INSERT", "foo", Granularities.DAY, null, null);
        String expectedAttributes = "{\"statementType\":\"INSERT\",\"targetDataSource\":\"foo\",\"partitionedBy\":\"DAY\"}";
        this.testSerde(insertAttributes, "{\"statementType\":\"INSERT\",\"targetDataSource\":\"foo\",\"partitionedBy\":\"DAY\"}");
    }

    @Test
    public void testSerdeOfInsertAllAttributes() {
        ExplainAttributes insertAttributes = new ExplainAttributes("INSERT", "foo", Granularities.ALL, null, null);
        String expectedAttributes = "{\"statementType\":\"INSERT\",\"targetDataSource\":\"foo\",\"partitionedBy\":{\"type\":\"all\"}}";
        this.testSerde(insertAttributes, "{\"statementType\":\"INSERT\",\"targetDataSource\":\"foo\",\"partitionedBy\":{\"type\":\"all\"}}");
    }

    @Test
    public void testSerdeOfReplaceAttributes() {
        ExplainAttributes replaceAttributes = new ExplainAttributes("REPLACE", "foo", Granularities.HOUR, null, "ALL");
        String expectedAttributes = "{\"statementType\":\"REPLACE\",\"targetDataSource\":\"foo\",\"partitionedBy\":\"HOUR\",\"replaceTimeChunks\":\"ALL\"}";
        this.testSerde(replaceAttributes, "{\"statementType\":\"REPLACE\",\"targetDataSource\":\"foo\",\"partitionedBy\":\"HOUR\",\"replaceTimeChunks\":\"ALL\"}");
    }

    @Test
    public void testSerdeOfReplaceAttributesWithTimeChunks() {
        ExplainAttributes replaceAttributes = new ExplainAttributes("REPLACE", "foo", Granularities.HOUR, null, "2019-08-25T02:00:00.000Z/2019-08-25T03:00:00.000Z");
        String expectedAttributes = "{\"statementType\":\"REPLACE\",\"targetDataSource\":\"foo\",\"partitionedBy\":\"HOUR\",\"replaceTimeChunks\":\"2019-08-25T02:00:00.000Z/2019-08-25T03:00:00.000Z\"}";
        this.testSerde(replaceAttributes, "{\"statementType\":\"REPLACE\",\"targetDataSource\":\"foo\",\"partitionedBy\":\"HOUR\",\"replaceTimeChunks\":\"2019-08-25T02:00:00.000Z/2019-08-25T03:00:00.000Z\"}");
    }

    @Test
    public void testReplaceAttributesWithClusteredBy() {
        ExplainAttributes replaceAttributes = new ExplainAttributes("REPLACE", "foo", Granularities.HOUR, Arrays.asList("foo", "CEIL(`f2`)"), "ALL");
        String expectedAttributes = "{\"statementType\":\"REPLACE\",\"targetDataSource\":\"foo\",\"partitionedBy\":\"HOUR\",\"clusteredBy\":[\"foo\",\"CEIL(`f2`)\"],\"replaceTimeChunks\":\"ALL\"}";
        this.testSerde(replaceAttributes, "{\"statementType\":\"REPLACE\",\"targetDataSource\":\"foo\",\"partitionedBy\":\"HOUR\",\"clusteredBy\":[\"foo\",\"CEIL(`f2`)\"],\"replaceTimeChunks\":\"ALL\"}");
    }

    @Test
    public void testReplaceAttributesWithClusteredByAndTimeChunks() {
        ExplainAttributes replaceAttributes = new ExplainAttributes("REPLACE", "foo", Granularities.HOUR, Arrays.asList("foo", "boo"), "2019-08-25T02:00:00.000Z/2019-08-25T03:00:00.000Z");
        String expectedAttributes = "{\"statementType\":\"REPLACE\",\"targetDataSource\":\"foo\",\"partitionedBy\":\"HOUR\",\"clusteredBy\":[\"foo\",\"boo\"],\"replaceTimeChunks\":\"2019-08-25T02:00:00.000Z/2019-08-25T03:00:00.000Z\"}";
        this.testSerde(replaceAttributes, "{\"statementType\":\"REPLACE\",\"targetDataSource\":\"foo\",\"partitionedBy\":\"HOUR\",\"clusteredBy\":[\"foo\",\"boo\"],\"replaceTimeChunks\":\"2019-08-25T02:00:00.000Z/2019-08-25T03:00:00.000Z\"}");
    }

    private void testSerde(ExplainAttributes explainAttributes, String expectedSerializedAttributes) {
        ExplainAttributes observedAttributes;
        try {
            String observedSerializedAttributes = MAPPER.writeValueAsString((Object)explainAttributes);
            Assert.assertEquals((Object)expectedSerializedAttributes, (Object)observedSerializedAttributes);
            observedAttributes = (ExplainAttributes)MAPPER.readValue(observedSerializedAttributes, ExplainAttributes.class);
        }
        catch (Exception e) {
            throw DruidException.defensive((Throwable)e, (String)"Error serializing/deserializing explain plan[%s].", (Object[])new Object[]{explainAttributes});
        }
        Assert.assertEquals((Object)explainAttributes, (Object)observedAttributes);
    }
}

