/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.Arrays;
import java.util.Collections;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionProcessingException;
import org.apache.druid.math.expr.ExpressionValidationException;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.expression.IPv6AddressMatchExprMacro;
import org.apache.druid.query.expression.MacroTestBase;
import org.junit.Assert;
import org.junit.Test;

public class IPv6AddressMatchExprMacroTest
extends MacroTestBase {
    private static final Expr IPV6 = ExprEval.of((String)"201:ef:168::").toExpr();
    private static final Expr IPV6_CIDR = ExprEval.of((String)"201:ef:168::/32").toExpr();

    public IPv6AddressMatchExprMacroTest() {
        super((ExprMacroTable.ExprMacro)new IPv6AddressMatchExprMacro());
    }

    @Test
    public void testTooFewArgs() {
        this.expectException(ExpressionValidationException.class, "requires 2 arguments");
        this.apply(Collections.emptyList());
    }

    @Test
    public void testTooManyArgs() {
        Expr extraArgument = ExprEval.of((String)"An extra argument").toExpr();
        this.expectException(ExpressionValidationException.class, "requires 2 arguments");
        this.apply(Arrays.asList(IPV6, IPV6_CIDR, extraArgument));
    }

    @Test
    public void testSubnetArgInvalid() {
        this.expectException(ExpressionProcessingException.class, "Function[ipv6_match] failed to parse address");
        Expr invalidSubnet = ExprEval.of((String)"201:ef:168::/invalid").toExpr();
        this.apply(Arrays.asList(IPV6, invalidSubnet));
    }

    @Test
    public void testNullStringArg() {
        Expr nullString = ExprEval.of(null).toExpr();
        Assert.assertFalse((boolean)this.eval(nullString, IPV6_CIDR));
    }

    @Test
    public void testMatchingStringArgIPv6() {
        Assert.assertTrue((boolean)this.eval(IPV6, IPV6_CIDR));
    }

    @Test
    public void testNotMatchingStringArgIPv6() {
        Expr nonMatchingIpv6 = ExprEval.of((String)"2002:ef:168::").toExpr();
        Assert.assertFalse((boolean)this.eval(nonMatchingIpv6, IPV6_CIDR));
    }

    @Test
    public void testNotIpAddress() {
        Expr notIpAddress = ExprEval.of((String)"druid.apache.org").toExpr();
        Assert.assertFalse((boolean)this.eval(notIpAddress, IPV6_CIDR));
    }

    @Test
    public void testInclusive() {
        Expr subnet = IPV6_CIDR;
        Assert.assertTrue((boolean)this.eval(IPV6, subnet));
    }

    private boolean eval(Expr ... args) {
        Expr expr = this.apply(Arrays.asList(args));
        ExprEval eval = expr.eval(InputBindings.nilBindings());
        return eval.asBoolean();
    }
}

